package software.amazon.awscdk.services.glue;

/**
 * (experimental) Interface representing a created or an imported {@link Job}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.253Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.IJob")
@software.amazon.jsii.Jsii.Proxy(IJob.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IJob extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource, software.amazon.awscdk.services.iam.IGrantable {

    /**
     * (experimental) The ARN of the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getJobArn();

    /**
     * (experimental) The name of the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getJobName();

    /**
     * (experimental) Create a CloudWatch metric.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html">https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html</a>
     * @param metricName name of the metric typically prefixed with `glue.driver.`, `glue.<executorId>.` or `glue.ALL.`. This parameter is required.
     * @param type the metric type. This parameter is required.
     * @param props metric options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.MetricType type, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Create a CloudWatch metric.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html">https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html</a>
     * @param metricName name of the metric typically prefixed with `glue.driver.`, `glue.<executorId>.` or `glue.ALL.`. This parameter is required.
     * @param type the metric type. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.MetricType type);

    /**
     * (experimental) Create a CloudWatch Metric indicating job failure.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Create a CloudWatch Metric indicating job failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFailure();

    /**
     * (experimental) Create a CloudWatch Metric indicating job success.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Create a CloudWatch Metric indicating job success.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccess();

    /**
     * (experimental) Create a CloudWatch Metric indicating job timeout.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTimeout(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Create a CloudWatch Metric indicating job timeout.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTimeout();

    /**
     * (experimental) Defines a CloudWatch event rule triggered when something happens with this job.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options);

    /**
     * (experimental) Defines a CloudWatch event rule triggered when something happens with this job.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * (experimental) Defines a CloudWatch event rule triggered when this job moves to the FAILED state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onFailure(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options);

    /**
     * (experimental) Defines a CloudWatch event rule triggered when this job moves to the FAILED state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onFailure(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * (experimental) Defines a CloudWatch event rule triggered when this job moves to the input jobState.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
     * @param id This parameter is required.
     * @param jobState This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobState jobState, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options);

    /**
     * (experimental) Defines a CloudWatch event rule triggered when this job moves to the input jobState.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
     * @param id This parameter is required.
     * @param jobState This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobState jobState);

    /**
     * (experimental) Defines a CloudWatch event rule triggered when this job moves to the SUCCEEDED state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onSuccess(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options);

    /**
     * (experimental) Defines a CloudWatch event rule triggered when this job moves to the SUCCEEDED state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onSuccess(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * (experimental) Defines a CloudWatch event rule triggered when this job moves to the TIMEOUT state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onTimeout(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options);

    /**
     * (experimental) Defines a CloudWatch event rule triggered when this job moves to the TIMEOUT state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onTimeout(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.glue.IJob.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * (experimental) The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * (experimental) The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * (experimental) The principal to grant permissions to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
        }

        /**
         * (experimental) The ARN of the job.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getJobArn() {
            return software.amazon.jsii.Kernel.get(this, "jobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The name of the job.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getJobName() {
            return software.amazon.jsii.Kernel.get(this, "jobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * (experimental) Create a CloudWatch metric.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html">https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html</a>
         * @param metricName name of the metric typically prefixed with `glue.driver.`, `glue.<executorId>.` or `glue.ALL.`. This parameter is required.
         * @param type the metric type. This parameter is required.
         * @param props metric options.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.MetricType type, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), java.util.Objects.requireNonNull(type, "type is required"), props });
        }

        /**
         * (experimental) Create a CloudWatch metric.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html">https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html</a>
         * @param metricName name of the metric typically prefixed with `glue.driver.`, `glue.<executorId>.` or `glue.ALL.`. This parameter is required.
         * @param type the metric type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.MetricType type) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), java.util.Objects.requireNonNull(type, "type is required") });
        }

        /**
         * (experimental) Create a CloudWatch Metric indicating job failure.
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Create a CloudWatch Metric indicating job failure.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFailure() {
            return software.amazon.jsii.Kernel.call(this, "metricFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Create a CloudWatch Metric indicating job success.
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Create a CloudWatch Metric indicating job success.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccess() {
            return software.amazon.jsii.Kernel.call(this, "metricSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Create a CloudWatch Metric indicating job timeout.
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTimeout(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Create a CloudWatch Metric indicating job timeout.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTimeout() {
            return software.amazon.jsii.Kernel.call(this, "metricTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when something happens with this job.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when something happens with this job.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when this job moves to the FAILED state.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onFailure(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when this job moves to the FAILED state.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onFailure(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "onFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when this job moves to the input jobState.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         * @param jobState This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobState jobState, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jobState, "jobState is required"), options });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when this job moves to the input jobState.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         * @param jobState This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobState jobState) {
            return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jobState, "jobState is required") });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when this job moves to the SUCCEEDED state.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onSuccess(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when this job moves to the SUCCEEDED state.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onSuccess(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "onSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when this job moves to the TIMEOUT state.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onTimeout(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when this job moves to the TIMEOUT state.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onTimeout(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return software.amazon.jsii.Kernel.call(this, "onTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }
    }

    /**
     * Internal default implementation for {@link IJob}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IJob, software.amazon.awscdk.core.IResource.Jsii$Default, software.amazon.awscdk.services.iam.IGrantable.Jsii$Default {

        /**
         * (experimental) The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * (experimental) The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * (experimental) The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * (experimental) The principal to grant permissions to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
        }

        /**
         * (experimental) The ARN of the job.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getJobArn() {
            return software.amazon.jsii.Kernel.get(this, "jobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The name of the job.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getJobName() {
            return software.amazon.jsii.Kernel.get(this, "jobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * (experimental) Create a CloudWatch metric.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html">https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html</a>
         * @param metricName name of the metric typically prefixed with `glue.driver.`, `glue.<executorId>.` or `glue.ALL.`. This parameter is required.
         * @param type the metric type. This parameter is required.
         * @param props metric options.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.MetricType type, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), java.util.Objects.requireNonNull(type, "type is required"), props });
        }

        /**
         * (experimental) Create a CloudWatch Metric indicating job failure.
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Create a CloudWatch Metric indicating job success.
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Create a CloudWatch Metric indicating job timeout.
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTimeout(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when something happens with this job.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when this job moves to the FAILED state.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onFailure(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when this job moves to the input jobState.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         * @param jobState This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobState jobState, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jobState, "jobState is required"), options });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when this job moves to the SUCCEEDED state.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onSuccess(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * (experimental) Defines a CloudWatch event rule triggered when this job moves to the TIMEOUT state.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
         * @param id This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onTimeout(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return software.amazon.jsii.Kernel.call(this, "onTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }
    }
}
