package software.amazon.awscdk.services.glue;

/**
 * (experimental) Properties of a DataFormat instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * ClassificationString classificationString;
 * InputFormat inputFormat;
 * OutputFormat outputFormat;
 * SerializationLibrary serializationLibrary;
 * DataFormatProps dataFormatProps = DataFormatProps.builder()
 *         .inputFormat(inputFormat)
 *         .outputFormat(outputFormat)
 *         .serializationLibrary(serializationLibrary)
 *         // the properties below are optional
 *         .classificationString(classificationString)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.249Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.DataFormatProps")
@software.amazon.jsii.Jsii.Proxy(DataFormatProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DataFormatProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) `InputFormat` for this data format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.InputFormat getInputFormat();

    /**
     * (experimental) `OutputFormat` for this data format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.OutputFormat getOutputFormat();

    /**
     * (experimental) Serialization library for this data format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.SerializationLibrary getSerializationLibrary();

    /**
     * (experimental) Classification string given to tables with this data format.
     * <p>
     * Default: - No classification is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.ClassificationString getClassificationString() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DataFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DataFormatProps> {
        software.amazon.awscdk.services.glue.InputFormat inputFormat;
        software.amazon.awscdk.services.glue.OutputFormat outputFormat;
        software.amazon.awscdk.services.glue.SerializationLibrary serializationLibrary;
        software.amazon.awscdk.services.glue.ClassificationString classificationString;

        /**
         * Sets the value of {@link DataFormatProps#getInputFormat}
         * @param inputFormat `InputFormat` for this data format. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inputFormat(software.amazon.awscdk.services.glue.InputFormat inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        /**
         * Sets the value of {@link DataFormatProps#getOutputFormat}
         * @param outputFormat `OutputFormat` for this data format. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputFormat(software.amazon.awscdk.services.glue.OutputFormat outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        /**
         * Sets the value of {@link DataFormatProps#getSerializationLibrary}
         * @param serializationLibrary Serialization library for this data format. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serializationLibrary(software.amazon.awscdk.services.glue.SerializationLibrary serializationLibrary) {
            this.serializationLibrary = serializationLibrary;
            return this;
        }

        /**
         * Sets the value of {@link DataFormatProps#getClassificationString}
         * @param classificationString Classification string given to tables with this data format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder classificationString(software.amazon.awscdk.services.glue.ClassificationString classificationString) {
            this.classificationString = classificationString;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataFormatProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DataFormatProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataFormatProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataFormatProps {
        private final software.amazon.awscdk.services.glue.InputFormat inputFormat;
        private final software.amazon.awscdk.services.glue.OutputFormat outputFormat;
        private final software.amazon.awscdk.services.glue.SerializationLibrary serializationLibrary;
        private final software.amazon.awscdk.services.glue.ClassificationString classificationString;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inputFormat = software.amazon.jsii.Kernel.get(this, "inputFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.InputFormat.class));
            this.outputFormat = software.amazon.jsii.Kernel.get(this, "outputFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.OutputFormat.class));
            this.serializationLibrary = software.amazon.jsii.Kernel.get(this, "serializationLibrary", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.SerializationLibrary.class));
            this.classificationString = software.amazon.jsii.Kernel.get(this, "classificationString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.ClassificationString.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inputFormat = java.util.Objects.requireNonNull(builder.inputFormat, "inputFormat is required");
            this.outputFormat = java.util.Objects.requireNonNull(builder.outputFormat, "outputFormat is required");
            this.serializationLibrary = java.util.Objects.requireNonNull(builder.serializationLibrary, "serializationLibrary is required");
            this.classificationString = builder.classificationString;
        }

        @Override
        public final software.amazon.awscdk.services.glue.InputFormat getInputFormat() {
            return this.inputFormat;
        }

        @Override
        public final software.amazon.awscdk.services.glue.OutputFormat getOutputFormat() {
            return this.outputFormat;
        }

        @Override
        public final software.amazon.awscdk.services.glue.SerializationLibrary getSerializationLibrary() {
            return this.serializationLibrary;
        }

        @Override
        public final software.amazon.awscdk.services.glue.ClassificationString getClassificationString() {
            return this.classificationString;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("inputFormat", om.valueToTree(this.getInputFormat()));
            data.set("outputFormat", om.valueToTree(this.getOutputFormat()));
            data.set("serializationLibrary", om.valueToTree(this.getSerializationLibrary()));
            if (this.getClassificationString() != null) {
                data.set("classificationString", om.valueToTree(this.getClassificationString()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_glue.DataFormatProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataFormatProps.Jsii$Proxy that = (DataFormatProps.Jsii$Proxy) o;

            if (!inputFormat.equals(that.inputFormat)) return false;
            if (!outputFormat.equals(that.outputFormat)) return false;
            if (!serializationLibrary.equals(that.serializationLibrary)) return false;
            return this.classificationString != null ? this.classificationString.equals(that.classificationString) : that.classificationString == null;
        }

        @Override
        public final int hashCode() {
            int result = this.inputFormat.hashCode();
            result = 31 * result + (this.outputFormat.hashCode());
            result = 31 * result + (this.serializationLibrary.hashCode());
            result = 31 * result + (this.classificationString != null ? this.classificationString.hashCode() : 0);
            return result;
        }
    }
}
