package software.amazon.awscdk.services.elasticache;

/**
 * Properties for defining a `CfnReplicationGroup`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticache.*;
 * CfnReplicationGroupProps cfnReplicationGroupProps = CfnReplicationGroupProps.builder()
 *         .replicationGroupDescription("replicationGroupDescription")
 *         // the properties below are optional
 *         .atRestEncryptionEnabled(false)
 *         .authToken("authToken")
 *         .automaticFailoverEnabled(false)
 *         .autoMinorVersionUpgrade(false)
 *         .cacheNodeType("cacheNodeType")
 *         .cacheParameterGroupName("cacheParameterGroupName")
 *         .cacheSecurityGroupNames(List.of("cacheSecurityGroupNames"))
 *         .cacheSubnetGroupName("cacheSubnetGroupName")
 *         .dataTieringEnabled(false)
 *         .engine("engine")
 *         .engineVersion("engineVersion")
 *         .globalReplicationGroupId("globalReplicationGroupId")
 *         .ipDiscovery("ipDiscovery")
 *         .kmsKeyId("kmsKeyId")
 *         .logDeliveryConfigurations(List.of(LogDeliveryConfigurationRequestProperty.builder()
 *                 .destinationDetails(DestinationDetailsProperty.builder()
 *                         .cloudWatchLogsDetails(CloudWatchLogsDestinationDetailsProperty.builder()
 *                                 .logGroup("logGroup")
 *                                 .build())
 *                         .kinesisFirehoseDetails(KinesisFirehoseDestinationDetailsProperty.builder()
 *                                 .deliveryStream("deliveryStream")
 *                                 .build())
 *                         .build())
 *                 .destinationType("destinationType")
 *                 .logFormat("logFormat")
 *                 .logType("logType")
 *                 .build()))
 *         .multiAzEnabled(false)
 *         .networkType("networkType")
 *         .nodeGroupConfiguration(List.of(NodeGroupConfigurationProperty.builder()
 *                 .nodeGroupId("nodeGroupId")
 *                 .primaryAvailabilityZone("primaryAvailabilityZone")
 *                 .replicaAvailabilityZones(List.of("replicaAvailabilityZones"))
 *                 .replicaCount(123)
 *                 .slots("slots")
 *                 .build()))
 *         .notificationTopicArn("notificationTopicArn")
 *         .numCacheClusters(123)
 *         .numNodeGroups(123)
 *         .port(123)
 *         .preferredCacheClusterAZs(List.of("preferredCacheClusterAZs"))
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .primaryClusterId("primaryClusterId")
 *         .replicasPerNodeGroup(123)
 *         .replicationGroupId("replicationGroupId")
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .snapshotArns(List.of("snapshotArns"))
 *         .snapshotName("snapshotName")
 *         .snapshotRetentionLimit(123)
 *         .snapshottingClusterId("snapshottingClusterId")
 *         .snapshotWindow("snapshotWindow")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transitEncryptionEnabled(false)
 *         .userGroupIds(List.of("userGroupIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:00.632Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_elasticache.CfnReplicationGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnReplicationGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnReplicationGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A user-created description for the replication group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReplicationGroupDescription();

    /**
     * A flag that enables encryption at rest when set to `true` .
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
     * <p>
     * <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
     * <p>
     * Default: <code>false</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAtRestEncryptionEnabled() {
        return null;
    }

    /**
     * *Reserved parameter.* The password used to access a password protected server.
     * <p>
     * <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is <code>true</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with the Redis AUTH Command</a> .
     * <p>
     * <blockquote>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code> , an <code>AuthToken</code> , and a <code>CacheSubnetGroup</code> .
     * <p>
     * </blockquote>
     * <p>
     * Password constraints:
     * <p>
     * <ul>
     * <li>Must be only printable ASCII characters.</li>
     * <li>Must be at least 16 characters and no more than 128 characters in length.</li>
     * <li>Nonalphanumeric characters are restricted to (!, &amp;, #, $, ^, &lt;, &gt;, -, ).</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.
     * <p>
     * <blockquote>
     * <p>
     * If ADDING the AuthToken, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">Replacement</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthToken() {
        return null;
    }

    /**
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
     * <p>
     * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutomaticFailoverEnabled() {
        return null;
    }

    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoMinorVersionUpgrade() {
        return null;
    }

    /**
     * The compute and memory capacity of the nodes in the node group (shard).
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.
     * <p>
     * <ul>
     * <li>General purpose:</li>
     * <li>Current generation:</li>
     * </ul>
     * <p>
     * <em>M6g node types:</em> <code>cache.m6g.large</code> , <code>cache.m6g.xlarge</code> , <code>cache.m6g.2xlarge</code> , <code>cache.m6g.4xlarge</code> , <code>cache.m6g.12xlarge</code> , <code>cache.m6g.24xlarge</code>
     * <p>
     * <em>M5 node types:</em> <code>cache.m5.large</code> , <code>cache.m5.xlarge</code> , <code>cache.m5.2xlarge</code> , <code>cache.m5.4xlarge</code> , <code>cache.m5.12xlarge</code> , <code>cache.m5.24xlarge</code>
     * <p>
     * <em>M4 node types:</em> <code>cache.m4.large</code> , <code>cache.m4.xlarge</code> , <code>cache.m4.2xlarge</code> , <code>cache.m4.4xlarge</code> , <code>cache.m4.10xlarge</code>
     * <p>
     * <em>T4g node types:</em> <code>cache.t4g.micro</code> , <code>cache.t4g.small</code> , <code>cache.t4g.medium</code>
     * <p>
     * <em>T3 node types:</em> <code>cache.t3.micro</code> , <code>cache.t3.small</code> , <code>cache.t3.medium</code>
     * <p>
     * <em>T2 node types:</em> <code>cache.t2.micro</code> , <code>cache.t2.small</code> , <code>cache.t2.medium</code>
     * <p>
     * <ul>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>T1 node types:</em> <code>cache.t1.micro</code>
     * <p>
     * <em>M1 node types:</em> <code>cache.m1.small</code> , <code>cache.m1.medium</code> , <code>cache.m1.large</code> , <code>cache.m1.xlarge</code>
     * <p>
     * <em>M3 node types:</em> <code>cache.m3.medium</code> , <code>cache.m3.large</code> , <code>cache.m3.xlarge</code> , <code>cache.m3.2xlarge</code>
     * <p>
     * <ul>
     * <li>Compute optimized:</li>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>C1 node types:</em> <code>cache.c1.xlarge</code>
     * <p>
     * <ul>
     * <li>Memory optimized:</li>
     * <li>Current generation:</li>
     * </ul>
     * <p>
     * <em>R6gd node types:</em> <code>cache.r6gd.xlarge</code> , <code>cache.r6gd.2xlarge</code> , <code>cache.r6gd.4xlarge</code> , <code>cache.r6gd.8xlarge</code> , <code>cache.r6gd.12xlarge</code> , <code>cache.r6gd.16xlarge</code>
     * <p>
     * <blockquote>
     * <p>
     * The <code>r6gd</code> family is available in the following regions: <code>us-east-2</code> , <code>us-east-1</code> , <code>us-west-2</code> , <code>us-west-1</code> , <code>eu-west-1</code> , <code>eu-central-1</code> , <code>ap-northeast-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> .
     * <p>
     * </blockquote>
     * <p>
     * <em>R6g node types:</em> <code>cache.r6g.large</code> , <code>cache.r6g.xlarge</code> , <code>cache.r6g.2xlarge</code> , <code>cache.r6g.4xlarge</code> , <code>cache.r6g.12xlarge</code> , <code>cache.r6g.24xlarge</code>
     * <p>
     * <em>R5 node types:</em> <code>cache.r5.large</code> , <code>cache.r5.xlarge</code> , <code>cache.r5.2xlarge</code> , <code>cache.r5.4xlarge</code> , <code>cache.r5.12xlarge</code> , <code>cache.r5.24xlarge</code>
     * <p>
     * <em>R4 node types:</em> <code>cache.r4.large</code> , <code>cache.r4.xlarge</code> , <code>cache.r4.2xlarge</code> , <code>cache.r4.4xlarge</code> , <code>cache.r4.8xlarge</code> , <code>cache.r4.16xlarge</code>
     * <p>
     * <ul>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>M2 node types:</em> <code>cache.m2.xlarge</code> , <code>cache.m2.2xlarge</code> , <code>cache.m2.4xlarge</code>
     * <p>
     * <em>R3 node types:</em> <code>cache.r3.large</code> , <code>cache.r3.xlarge</code> , <code>cache.r3.2xlarge</code> , <code>cache.r3.4xlarge</code> , <code>cache.r3.8xlarge</code>
     * <p>
     * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types by Amazon Region</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacheNodeType() {
        return null;
    }

    /**
     * The name of the parameter group to associate with this replication group.
     * <p>
     * If this argument is omitted, the default cache parameter group for the specified engine is used.
     * <p>
     * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name.
     * <p>
     * <ul>
     * <li>To create a Redis (cluster mode disabled) replication group, use <code>CacheParameterGroupName=default.redis3.2</code> .</li>
     * <li>To create a Redis (cluster mode enabled) replication group, use <code>CacheParameterGroupName=default.redis3.2.cluster.on</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacheParameterGroupName() {
        return null;
    }

    /**
     * A list of cache security group names to associate with this replication group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCacheSecurityGroupNames() {
        return null;
    }

    /**
     * The name of the cache subnet group to be used for the replication group.
     * <p>
     * <blockquote>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html">AWS::ElastiCache::SubnetGroup</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacheSubnetGroupName() {
        return null;
    }

    /**
     * Enables data tiering.
     * <p>
     * Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataTieringEnabled() {
        return null;
    }

    /**
     * The name of the cache engine to be used for the clusters in this replication group.
     * <p>
     * The value must be set to <code>Redis</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return null;
    }

    /**
     * The version number of the cache engine to be used for the clusters in this replication group.
     * <p>
     * To view the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.
     * <p>
     * <em>Important:</em> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a> ) in the <em>ElastiCache User Guide</em> , but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return null;
    }

    /**
     * The name of the Global datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGlobalReplicationGroupId() {
        return null;
    }

    /**
     * The network type you choose when creating a replication group, either `ipv4` | `ipv6` .
     * <p>
     * IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="https://docs.aws.amazon.com/https://aws.amazon.com/ec2/nitro/">Nitro system</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpDiscovery() {
        return null;
    }

    /**
     * The ID of the KMS key used to encrypt the disk on the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Specifies the destination, format and type of the logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogDeliveryConfigurations() {
        return null;
    }

    /**
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMultiAzEnabled() {
        return null;
    }

    /**
     * Must be either `ipv4` | `ipv6` | `dual_stack` .
     * <p>
     * IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="https://docs.aws.amazon.com/https://aws.amazon.com/ec2/nitro/">Nitro system</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkType() {
        return null;
    }

    /**
     * `NodeGroupConfiguration` is a property of the `AWS::ElastiCache::ReplicationGroup` resource that configures an Amazon ElastiCache (ElastiCache) Redis cluster node group.
     * <p>
     * If you set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding</a> to <code>true</code> , you can update <code>NodeGroupConfiguration</code> without interruption. When <code>UseOnlineResharding</code> is set to <code>false</code> , or is not specified, updating <code>NodeGroupConfiguration</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNodeGroupConfiguration() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
     * <p>
     * <blockquote>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNotificationTopicArn() {
        return null;
    }

    /**
     * The number of clusters this replication group initially has.
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.
     * <p>
     * If <code>AutomaticFailoverEnabled</code> is <code>true</code> , the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.
     * <p>
     * The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumCacheClusters() {
        return null;
    }

    /**
     * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group.
     * <p>
     * For Redis (cluster mode disabled) either omit this parameter or set it to 1.
     * <p>
     * If you set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding</a> to <code>true</code> , you can update <code>NumNodeGroups</code> without interruption. When <code>UseOnlineResharding</code> is set to <code>false</code> , or is not specified, updating <code>NumNodeGroups</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumNodeGroups() {
        return null;
    }

    /**
     * The port number on which each member of the replication group accepts connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * A list of EC2 Availability Zones in which the replication group's clusters are created.
     * <p>
     * The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use <code>NodeGroupConfiguration</code> instead.
     * <p>
     * <blockquote>
     * <p>
     * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code> .
     * <p>
     * </blockquote>
     * <p>
     * Default: system chosen Availability Zones.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPreferredCacheClusterAZs() {
        return null;
    }

    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed.
     * <p>
     * It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * <p>
     * Valid values for <code>ddd</code> are:
     * <p>
     * <ul>
     * <li><code>sun</code></li>
     * <li><code>mon</code></li>
     * <li><code>tue</code></li>
     * <li><code>wed</code></li>
     * <li><code>thu</code></li>
     * <li><code>fri</code></li>
     * <li><code>sat</code></li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * The identifier of the cluster that serves as the primary for this replication group.
     * <p>
     * This cluster must already exist and have a status of <code>available</code> .
     * <p>
     * This parameter is not required if <code>NumCacheClusters</code> , <code>NumNodeGroups</code> , or <code>ReplicasPerNodeGroup</code> is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrimaryClusterId() {
        return null;
    }

    /**
     * An optional parameter that specifies the number of replica nodes in each node group (shard).
     * <p>
     * Valid values are 0 to 5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getReplicasPerNodeGroup() {
        return null;
    }

    /**
     * The replication group identifier. This parameter is stored as a lowercase string.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>A name must contain from 1 to 40 alphanumeric characters or hyphens.</li>
     * <li>The first character must be a letter.</li>
     * <li>A name cannot end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReplicationGroupId() {
        return null;
    }

    /**
     * One or more Amazon VPC security groups associated with this replication group.
     * <p>
     * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3.
     * <p>
     * The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter <em>NumNodeGroups</em> or the number of node groups configured by <em>NodeGroupConfiguration</em> regardless of the number of ARNs specified here.
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSnapshotArns() {
        return null;
    }

    /**
     * The name of a snapshot from which to restore data into the new replication group.
     * <p>
     * The snapshot status changes to <code>restoring</code> while the new replication group is being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotName() {
        return null;
    }

    /**
     * The number of days for which ElastiCache retains automatic snapshots before deleting them.
     * <p>
     * For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cluster).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSnapshotRetentionLimit() {
        return null;
    }

    /**
     * The cluster ID that is used as the daily snapshot source for the replication group.
     * <p>
     * This parameter cannot be set for Redis (cluster mode enabled) replication groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshottingClusterId() {
        return null;
    }

    /**
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * <p>
     * Example: <code>05:00-09:00</code>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotWindow() {
        return null;
    }

    /**
     * A list of tags to be added to this resource.
     * <p>
     * Tags are comma-separated key,value pairs (e.g. Key= <code>myKey</code> , Value= <code>myKeyValue</code> . You can include multiple tags as shown following: Key= <code>myKey</code> , Value= <code>myKeyValue</code> Key= <code>mySecondKey</code> , Value= <code>mySecondKeyValue</code> . Tags on replication groups will be replicated to all nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * A flag that enables in-transit encryption when set to `true` .
     * <p>
     * You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.
     * <p>
     * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code> , the <code>EngineVersion</code> parameter is <code>3.2.6</code> or <code>4.x</code> onward, and the cluster is being created in an Amazon VPC.
     * <p>
     * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code> .
     * <p>
     * <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
     * <p>
     * Default: <code>false</code>
     * <p>
     * <blockquote>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code> , an <code>AuthToken</code> , and a <code>CacheSubnetGroup</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTransitEncryptionEnabled() {
        return null;
    }

    /**
     * The ID of user group to associate with the replication group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUserGroupIds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnReplicationGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnReplicationGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnReplicationGroupProps> {
        java.lang.String replicationGroupDescription;
        java.lang.Object atRestEncryptionEnabled;
        java.lang.String authToken;
        java.lang.Object automaticFailoverEnabled;
        java.lang.Object autoMinorVersionUpgrade;
        java.lang.String cacheNodeType;
        java.lang.String cacheParameterGroupName;
        java.util.List<java.lang.String> cacheSecurityGroupNames;
        java.lang.String cacheSubnetGroupName;
        java.lang.Object dataTieringEnabled;
        java.lang.String engine;
        java.lang.String engineVersion;
        java.lang.String globalReplicationGroupId;
        java.lang.String ipDiscovery;
        java.lang.String kmsKeyId;
        java.lang.Object logDeliveryConfigurations;
        java.lang.Object multiAzEnabled;
        java.lang.String networkType;
        java.lang.Object nodeGroupConfiguration;
        java.lang.String notificationTopicArn;
        java.lang.Number numCacheClusters;
        java.lang.Number numNodeGroups;
        java.lang.Number port;
        java.util.List<java.lang.String> preferredCacheClusterAZs;
        java.lang.String preferredMaintenanceWindow;
        java.lang.String primaryClusterId;
        java.lang.Number replicasPerNodeGroup;
        java.lang.String replicationGroupId;
        java.util.List<java.lang.String> securityGroupIds;
        java.util.List<java.lang.String> snapshotArns;
        java.lang.String snapshotName;
        java.lang.Number snapshotRetentionLimit;
        java.lang.String snapshottingClusterId;
        java.lang.String snapshotWindow;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.Object transitEncryptionEnabled;
        java.util.List<java.lang.String> userGroupIds;

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getReplicationGroupDescription}
         * @param replicationGroupDescription A user-created description for the replication group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationGroupDescription(java.lang.String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getAtRestEncryptionEnabled}
         * @param atRestEncryptionEnabled A flag that enables encryption at rest when set to `true` .
         *                                You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
         *                                <p>
         *                                <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
         *                                <p>
         *                                Default: <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder atRestEncryptionEnabled(java.lang.Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getAtRestEncryptionEnabled}
         * @param atRestEncryptionEnabled A flag that enables encryption at rest when set to `true` .
         *                                You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
         *                                <p>
         *                                <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
         *                                <p>
         *                                Default: <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder atRestEncryptionEnabled(software.amazon.awscdk.core.IResolvable atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getAuthToken}
         * @param authToken *Reserved parameter.* The password used to access a password protected server.
         *                  <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is <code>true</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with the Redis AUTH Command</a> .
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code> , an <code>AuthToken</code> , and a <code>CacheSubnetGroup</code> .
         *                  <p>
         *                  </blockquote>
         *                  <p>
         *                  Password constraints:
         *                  <p>
         *                  <ul>
         *                  <li>Must be only printable ASCII characters.</li>
         *                  <li>Must be at least 16 characters and no more than 128 characters in length.</li>
         *                  <li>Nonalphanumeric characters are restricted to (!, &amp;, #, $, ^, &lt;, &gt;, -, ).</li>
         *                  </ul>
         *                  <p>
         *                  For more information, see <a href="https://docs.aws.amazon.com/http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  If ADDING the AuthToken, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">Replacement</a> .
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authToken(java.lang.String authToken) {
            this.authToken = authToken;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getAutomaticFailoverEnabled}
         * @param automaticFailoverEnabled Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
         *                                 <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
         *                                 <p>
         *                                 Default: false
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticFailoverEnabled(java.lang.Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getAutomaticFailoverEnabled}
         * @param automaticFailoverEnabled Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
         *                                 <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
         *                                 <p>
         *                                 Default: false
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticFailoverEnabled(software.amazon.awscdk.core.IResolvable automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(java.lang.Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(software.amazon.awscdk.core.IResolvable autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getCacheNodeType}
         * @param cacheNodeType The compute and memory capacity of the nodes in the node group (shard).
         *                      The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.
         *                      <p>
         *                      <ul>
         *                      <li>General purpose:</li>
         *                      <li>Current generation:</li>
         *                      </ul>
         *                      <p>
         *                      <em>M6g node types:</em> <code>cache.m6g.large</code> , <code>cache.m6g.xlarge</code> , <code>cache.m6g.2xlarge</code> , <code>cache.m6g.4xlarge</code> , <code>cache.m6g.12xlarge</code> , <code>cache.m6g.24xlarge</code>
         *                      <p>
         *                      <em>M5 node types:</em> <code>cache.m5.large</code> , <code>cache.m5.xlarge</code> , <code>cache.m5.2xlarge</code> , <code>cache.m5.4xlarge</code> , <code>cache.m5.12xlarge</code> , <code>cache.m5.24xlarge</code>
         *                      <p>
         *                      <em>M4 node types:</em> <code>cache.m4.large</code> , <code>cache.m4.xlarge</code> , <code>cache.m4.2xlarge</code> , <code>cache.m4.4xlarge</code> , <code>cache.m4.10xlarge</code>
         *                      <p>
         *                      <em>T4g node types:</em> <code>cache.t4g.micro</code> , <code>cache.t4g.small</code> , <code>cache.t4g.medium</code>
         *                      <p>
         *                      <em>T3 node types:</em> <code>cache.t3.micro</code> , <code>cache.t3.small</code> , <code>cache.t3.medium</code>
         *                      <p>
         *                      <em>T2 node types:</em> <code>cache.t2.micro</code> , <code>cache.t2.small</code> , <code>cache.t2.medium</code>
         *                      <p>
         *                      <ul>
         *                      <li>Previous generation: (not recommended)</li>
         *                      </ul>
         *                      <p>
         *                      <em>T1 node types:</em> <code>cache.t1.micro</code>
         *                      <p>
         *                      <em>M1 node types:</em> <code>cache.m1.small</code> , <code>cache.m1.medium</code> , <code>cache.m1.large</code> , <code>cache.m1.xlarge</code>
         *                      <p>
         *                      <em>M3 node types:</em> <code>cache.m3.medium</code> , <code>cache.m3.large</code> , <code>cache.m3.xlarge</code> , <code>cache.m3.2xlarge</code>
         *                      <p>
         *                      <ul>
         *                      <li>Compute optimized:</li>
         *                      <li>Previous generation: (not recommended)</li>
         *                      </ul>
         *                      <p>
         *                      <em>C1 node types:</em> <code>cache.c1.xlarge</code>
         *                      <p>
         *                      <ul>
         *                      <li>Memory optimized:</li>
         *                      <li>Current generation:</li>
         *                      </ul>
         *                      <p>
         *                      <em>R6gd node types:</em> <code>cache.r6gd.xlarge</code> , <code>cache.r6gd.2xlarge</code> , <code>cache.r6gd.4xlarge</code> , <code>cache.r6gd.8xlarge</code> , <code>cache.r6gd.12xlarge</code> , <code>cache.r6gd.16xlarge</code>
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      The <code>r6gd</code> family is available in the following regions: <code>us-east-2</code> , <code>us-east-1</code> , <code>us-west-2</code> , <code>us-west-1</code> , <code>eu-west-1</code> , <code>eu-central-1</code> , <code>ap-northeast-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> .
         *                      <p>
         *                      </blockquote>
         *                      <p>
         *                      <em>R6g node types:</em> <code>cache.r6g.large</code> , <code>cache.r6g.xlarge</code> , <code>cache.r6g.2xlarge</code> , <code>cache.r6g.4xlarge</code> , <code>cache.r6g.12xlarge</code> , <code>cache.r6g.24xlarge</code>
         *                      <p>
         *                      <em>R5 node types:</em> <code>cache.r5.large</code> , <code>cache.r5.xlarge</code> , <code>cache.r5.2xlarge</code> , <code>cache.r5.4xlarge</code> , <code>cache.r5.12xlarge</code> , <code>cache.r5.24xlarge</code>
         *                      <p>
         *                      <em>R4 node types:</em> <code>cache.r4.large</code> , <code>cache.r4.xlarge</code> , <code>cache.r4.2xlarge</code> , <code>cache.r4.4xlarge</code> , <code>cache.r4.8xlarge</code> , <code>cache.r4.16xlarge</code>
         *                      <p>
         *                      <ul>
         *                      <li>Previous generation: (not recommended)</li>
         *                      </ul>
         *                      <p>
         *                      <em>M2 node types:</em> <code>cache.m2.xlarge</code> , <code>cache.m2.2xlarge</code> , <code>cache.m2.4xlarge</code>
         *                      <p>
         *                      <em>R3 node types:</em> <code>cache.r3.large</code> , <code>cache.r3.xlarge</code> , <code>cache.r3.2xlarge</code> , <code>cache.r3.4xlarge</code> , <code>cache.r3.8xlarge</code>
         *                      <p>
         *                      For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types by Amazon Region</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheNodeType(java.lang.String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getCacheParameterGroupName}
         * @param cacheParameterGroupName The name of the parameter group to associate with this replication group.
         *                                If this argument is omitted, the default cache parameter group for the specified engine is used.
         *                                <p>
         *                                If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name.
         *                                <p>
         *                                <ul>
         *                                <li>To create a Redis (cluster mode disabled) replication group, use <code>CacheParameterGroupName=default.redis3.2</code> .</li>
         *                                <li>To create a Redis (cluster mode enabled) replication group, use <code>CacheParameterGroupName=default.redis3.2.cluster.on</code> .</li>
         *                                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheParameterGroupName(java.lang.String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getCacheSecurityGroupNames}
         * @param cacheSecurityGroupNames A list of cache security group names to associate with this replication group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheSecurityGroupNames(java.util.List<java.lang.String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = cacheSecurityGroupNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getCacheSubnetGroupName}
         * @param cacheSubnetGroupName The name of the cache subnet group to be used for the replication group.
         *                             <blockquote>
         *                             <p>
         *                             If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html">AWS::ElastiCache::SubnetGroup</a> .
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheSubnetGroupName(java.lang.String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getDataTieringEnabled}
         * @param dataTieringEnabled Enables data tiering.
         *                           Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataTieringEnabled(java.lang.Boolean dataTieringEnabled) {
            this.dataTieringEnabled = dataTieringEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getDataTieringEnabled}
         * @param dataTieringEnabled Enables data tiering.
         *                           Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataTieringEnabled(software.amazon.awscdk.core.IResolvable dataTieringEnabled) {
            this.dataTieringEnabled = dataTieringEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getEngine}
         * @param engine The name of the cache engine to be used for the clusters in this replication group.
         *               The value must be set to <code>Redis</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getEngineVersion}
         * @param engineVersion The version number of the cache engine to be used for the clusters in this replication group.
         *                      To view the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.
         *                      <p>
         *                      <em>Important:</em> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a> ) in the <em>ElastiCache User Guide</em> , but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getGlobalReplicationGroupId}
         * @param globalReplicationGroupId The name of the Global datastore.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalReplicationGroupId(java.lang.String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getIpDiscovery}
         * @param ipDiscovery The network type you choose when creating a replication group, either `ipv4` | `ipv6` .
         *                    IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="https://docs.aws.amazon.com/https://aws.amazon.com/ec2/nitro/">Nitro system</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipDiscovery(java.lang.String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getKmsKeyId}
         * @param kmsKeyId The ID of the KMS key used to encrypt the disk on the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getLogDeliveryConfigurations}
         * @param logDeliveryConfigurations Specifies the destination, format and type of the logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDeliveryConfigurations(software.amazon.awscdk.core.IResolvable logDeliveryConfigurations) {
            this.logDeliveryConfigurations = logDeliveryConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getLogDeliveryConfigurations}
         * @param logDeliveryConfigurations Specifies the destination, format and type of the logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDeliveryConfigurations(java.util.List<? extends java.lang.Object> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = logDeliveryConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getMultiAzEnabled}
         * @param multiAzEnabled A flag indicating if you have Multi-AZ enabled to enhance fault tolerance.
         *                       For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAzEnabled(java.lang.Boolean multiAzEnabled) {
            this.multiAzEnabled = multiAzEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getMultiAzEnabled}
         * @param multiAzEnabled A flag indicating if you have Multi-AZ enabled to enhance fault tolerance.
         *                       For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAzEnabled(software.amazon.awscdk.core.IResolvable multiAzEnabled) {
            this.multiAzEnabled = multiAzEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getNetworkType}
         * @param networkType Must be either `ipv4` | `ipv6` | `dual_stack` .
         *                    IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="https://docs.aws.amazon.com/https://aws.amazon.com/ec2/nitro/">Nitro system</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkType(java.lang.String networkType) {
            this.networkType = networkType;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getNodeGroupConfiguration}
         * @param nodeGroupConfiguration `NodeGroupConfiguration` is a property of the `AWS::ElastiCache::ReplicationGroup` resource that configures an Amazon ElastiCache (ElastiCache) Redis cluster node group.
         *                               If you set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding</a> to <code>true</code> , you can update <code>NodeGroupConfiguration</code> without interruption. When <code>UseOnlineResharding</code> is set to <code>false</code> , or is not specified, updating <code>NodeGroupConfiguration</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeGroupConfiguration(software.amazon.awscdk.core.IResolvable nodeGroupConfiguration) {
            this.nodeGroupConfiguration = nodeGroupConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getNodeGroupConfiguration}
         * @param nodeGroupConfiguration `NodeGroupConfiguration` is a property of the `AWS::ElastiCache::ReplicationGroup` resource that configures an Amazon ElastiCache (ElastiCache) Redis cluster node group.
         *                               If you set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding</a> to <code>true</code> , you can update <code>NodeGroupConfiguration</code> without interruption. When <code>UseOnlineResharding</code> is set to <code>false</code> , or is not specified, updating <code>NodeGroupConfiguration</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeGroupConfiguration(java.util.List<? extends java.lang.Object> nodeGroupConfiguration) {
            this.nodeGroupConfiguration = nodeGroupConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getNotificationTopicArn}
         * @param notificationTopicArn The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
         *                             <blockquote>
         *                             <p>
         *                             The Amazon SNS topic owner must be the same as the cluster owner.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTopicArn(java.lang.String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getNumCacheClusters}
         * @param numCacheClusters The number of clusters this replication group initially has.
         *                         This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.
         *                         <p>
         *                         If <code>AutomaticFailoverEnabled</code> is <code>true</code> , the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.
         *                         <p>
         *                         The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numCacheClusters(java.lang.Number numCacheClusters) {
            this.numCacheClusters = numCacheClusters;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getNumNodeGroups}
         * @param numNodeGroups An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group.
         *                      For Redis (cluster mode disabled) either omit this parameter or set it to 1.
         *                      <p>
         *                      If you set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-useonlineresharding">UseOnlineResharding</a> to <code>true</code> , you can update <code>NumNodeGroups</code> without interruption. When <code>UseOnlineResharding</code> is set to <code>false</code> , or is not specified, updating <code>NumNodeGroups</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         *                      <p>
         *                      Default: 1
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numNodeGroups(java.lang.Number numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getPort}
         * @param port The port number on which each member of the replication group accepts connections.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getPreferredCacheClusterAZs}
         * @param preferredCacheClusterAZs A list of EC2 Availability Zones in which the replication group's clusters are created.
         *                                 The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.
         *                                 <p>
         *                                 This parameter is not used if there is more than one node group (shard). You should use <code>NodeGroupConfiguration</code> instead.
         *                                 <p>
         *                                 <blockquote>
         *                                 <p>
         *                                 If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.
         *                                 <p>
         *                                 The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code> .
         *                                 <p>
         *                                 </blockquote>
         *                                 <p>
         *                                 Default: system chosen Availability Zones.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredCacheClusterAZs(java.util.List<java.lang.String> preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs = preferredCacheClusterAZs;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow Specifies the weekly time range during which maintenance on the cluster is performed.
         *                                   It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
         *                                   <p>
         *                                   Valid values for <code>ddd</code> are:
         *                                   <p>
         *                                   <ul>
         *                                   <li><code>sun</code></li>
         *                                   <li><code>mon</code></li>
         *                                   <li><code>tue</code></li>
         *                                   <li><code>wed</code></li>
         *                                   <li><code>thu</code></li>
         *                                   <li><code>fri</code></li>
         *                                   <li><code>sat</code></li>
         *                                   </ul>
         *                                   <p>
         *                                   Example: <code>sun:23:00-mon:01:30</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getPrimaryClusterId}
         * @param primaryClusterId The identifier of the cluster that serves as the primary for this replication group.
         *                         This cluster must already exist and have a status of <code>available</code> .
         *                         <p>
         *                         This parameter is not required if <code>NumCacheClusters</code> , <code>NumNodeGroups</code> , or <code>ReplicasPerNodeGroup</code> is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryClusterId(java.lang.String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getReplicasPerNodeGroup}
         * @param replicasPerNodeGroup An optional parameter that specifies the number of replica nodes in each node group (shard).
         *                             Valid values are 0 to 5.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicasPerNodeGroup(java.lang.Number replicasPerNodeGroup) {
            this.replicasPerNodeGroup = replicasPerNodeGroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getReplicationGroupId}
         * @param replicationGroupId The replication group identifier. This parameter is stored as a lowercase string.
         *                           Constraints:
         *                           <p>
         *                           <ul>
         *                           <li>A name must contain from 1 to 40 alphanumeric characters or hyphens.</li>
         *                           <li>The first character must be a letter.</li>
         *                           <li>A name cannot end with a hyphen or contain two consecutive hyphens.</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationGroupId(java.lang.String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getSecurityGroupIds}
         * @param securityGroupIds One or more Amazon VPC security groups associated with this replication group.
         *                         Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getSnapshotArns}
         * @param snapshotArns A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3.
         *                     The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter <em>NumNodeGroups</em> or the number of node groups configured by <em>NodeGroupConfiguration</em> regardless of the number of ARNs specified here.
         *                     <p>
         *                     Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotArns(java.util.List<java.lang.String> snapshotArns) {
            this.snapshotArns = snapshotArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getSnapshotName}
         * @param snapshotName The name of a snapshot from which to restore data into the new replication group.
         *                     The snapshot status changes to <code>restoring</code> while the new replication group is being created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotName(java.lang.String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getSnapshotRetentionLimit}
         * @param snapshotRetentionLimit The number of days for which ElastiCache retains automatic snapshots before deleting them.
         *                               For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.
         *                               <p>
         *                               Default: 0 (i.e., automatic backups are disabled for this cluster).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotRetentionLimit(java.lang.Number snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getSnapshottingClusterId}
         * @param snapshottingClusterId The cluster ID that is used as the daily snapshot source for the replication group.
         *                              This parameter cannot be set for Redis (cluster mode enabled) replication groups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshottingClusterId(java.lang.String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getSnapshotWindow}
         * @param snapshotWindow The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
         *                       Example: <code>05:00-09:00</code>
         *                       <p>
         *                       If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotWindow(java.lang.String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getTags}
         * @param tags A list of tags to be added to this resource.
         *             Tags are comma-separated key,value pairs (e.g. Key= <code>myKey</code> , Value= <code>myKeyValue</code> . You can include multiple tags as shown following: Key= <code>myKey</code> , Value= <code>myKeyValue</code> Key= <code>mySecondKey</code> , Value= <code>mySecondKeyValue</code> . Tags on replication groups will be replicated to all nodes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getTransitEncryptionEnabled}
         * @param transitEncryptionEnabled A flag that enables in-transit encryption when set to `true` .
         *                                 You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.
         *                                 <p>
         *                                 This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code> , the <code>EngineVersion</code> parameter is <code>3.2.6</code> or <code>4.x</code> onward, and the cluster is being created in an Amazon VPC.
         *                                 <p>
         *                                 If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code> .
         *                                 <p>
         *                                 <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
         *                                 <p>
         *                                 Default: <code>false</code>
         *                                 <p>
         *                                 <blockquote>
         *                                 <p>
         *                                 For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code> , an <code>AuthToken</code> , and a <code>CacheSubnetGroup</code> .
         *                                 <p>
         *                                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionEnabled(java.lang.Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getTransitEncryptionEnabled}
         * @param transitEncryptionEnabled A flag that enables in-transit encryption when set to `true` .
         *                                 You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.
         *                                 <p>
         *                                 This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code> , the <code>EngineVersion</code> parameter is <code>3.2.6</code> or <code>4.x</code> onward, and the cluster is being created in an Amazon VPC.
         *                                 <p>
         *                                 If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code> .
         *                                 <p>
         *                                 <em>Required:</em> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code> or <code>4.x</code> onward.
         *                                 <p>
         *                                 Default: <code>false</code>
         *                                 <p>
         *                                 <blockquote>
         *                                 <p>
         *                                 For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code> , an <code>AuthToken</code> , and a <code>CacheSubnetGroup</code> .
         *                                 <p>
         *                                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionEnabled(software.amazon.awscdk.core.IResolvable transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationGroupProps#getUserGroupIds}
         * @param userGroupIds The ID of user group to associate with the replication group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userGroupIds(java.util.List<java.lang.String> userGroupIds) {
            this.userGroupIds = userGroupIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnReplicationGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnReplicationGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnReplicationGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnReplicationGroupProps {
        private final java.lang.String replicationGroupDescription;
        private final java.lang.Object atRestEncryptionEnabled;
        private final java.lang.String authToken;
        private final java.lang.Object automaticFailoverEnabled;
        private final java.lang.Object autoMinorVersionUpgrade;
        private final java.lang.String cacheNodeType;
        private final java.lang.String cacheParameterGroupName;
        private final java.util.List<java.lang.String> cacheSecurityGroupNames;
        private final java.lang.String cacheSubnetGroupName;
        private final java.lang.Object dataTieringEnabled;
        private final java.lang.String engine;
        private final java.lang.String engineVersion;
        private final java.lang.String globalReplicationGroupId;
        private final java.lang.String ipDiscovery;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object logDeliveryConfigurations;
        private final java.lang.Object multiAzEnabled;
        private final java.lang.String networkType;
        private final java.lang.Object nodeGroupConfiguration;
        private final java.lang.String notificationTopicArn;
        private final java.lang.Number numCacheClusters;
        private final java.lang.Number numNodeGroups;
        private final java.lang.Number port;
        private final java.util.List<java.lang.String> preferredCacheClusterAZs;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.lang.String primaryClusterId;
        private final java.lang.Number replicasPerNodeGroup;
        private final java.lang.String replicationGroupId;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.util.List<java.lang.String> snapshotArns;
        private final java.lang.String snapshotName;
        private final java.lang.Number snapshotRetentionLimit;
        private final java.lang.String snapshottingClusterId;
        private final java.lang.String snapshotWindow;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Object transitEncryptionEnabled;
        private final java.util.List<java.lang.String> userGroupIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.replicationGroupDescription = software.amazon.jsii.Kernel.get(this, "replicationGroupDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.atRestEncryptionEnabled = software.amazon.jsii.Kernel.get(this, "atRestEncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.authToken = software.amazon.jsii.Kernel.get(this, "authToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.automaticFailoverEnabled = software.amazon.jsii.Kernel.get(this, "automaticFailoverEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoMinorVersionUpgrade = software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cacheNodeType = software.amazon.jsii.Kernel.get(this, "cacheNodeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cacheParameterGroupName = software.amazon.jsii.Kernel.get(this, "cacheParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cacheSecurityGroupNames = software.amazon.jsii.Kernel.get(this, "cacheSecurityGroupNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cacheSubnetGroupName = software.amazon.jsii.Kernel.get(this, "cacheSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataTieringEnabled = software.amazon.jsii.Kernel.get(this, "dataTieringEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.globalReplicationGroupId = software.amazon.jsii.Kernel.get(this, "globalReplicationGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipDiscovery = software.amazon.jsii.Kernel.get(this, "ipDiscovery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logDeliveryConfigurations = software.amazon.jsii.Kernel.get(this, "logDeliveryConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.multiAzEnabled = software.amazon.jsii.Kernel.get(this, "multiAzEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.networkType = software.amazon.jsii.Kernel.get(this, "networkType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nodeGroupConfiguration = software.amazon.jsii.Kernel.get(this, "nodeGroupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.notificationTopicArn = software.amazon.jsii.Kernel.get(this, "notificationTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.numCacheClusters = software.amazon.jsii.Kernel.get(this, "numCacheClusters", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.numNodeGroups = software.amazon.jsii.Kernel.get(this, "numNodeGroups", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preferredCacheClusterAZs = software.amazon.jsii.Kernel.get(this, "preferredCacheClusterAZs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.primaryClusterId = software.amazon.jsii.Kernel.get(this, "primaryClusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicasPerNodeGroup = software.amazon.jsii.Kernel.get(this, "replicasPerNodeGroup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.replicationGroupId = software.amazon.jsii.Kernel.get(this, "replicationGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.snapshotArns = software.amazon.jsii.Kernel.get(this, "snapshotArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.snapshotName = software.amazon.jsii.Kernel.get(this, "snapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snapshotRetentionLimit = software.amazon.jsii.Kernel.get(this, "snapshotRetentionLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.snapshottingClusterId = software.amazon.jsii.Kernel.get(this, "snapshottingClusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snapshotWindow = software.amazon.jsii.Kernel.get(this, "snapshotWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.transitEncryptionEnabled = software.amazon.jsii.Kernel.get(this, "transitEncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.userGroupIds = software.amazon.jsii.Kernel.get(this, "userGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.replicationGroupDescription = java.util.Objects.requireNonNull(builder.replicationGroupDescription, "replicationGroupDescription is required");
            this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
            this.authToken = builder.authToken;
            this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
            this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
            this.cacheNodeType = builder.cacheNodeType;
            this.cacheParameterGroupName = builder.cacheParameterGroupName;
            this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
            this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
            this.dataTieringEnabled = builder.dataTieringEnabled;
            this.engine = builder.engine;
            this.engineVersion = builder.engineVersion;
            this.globalReplicationGroupId = builder.globalReplicationGroupId;
            this.ipDiscovery = builder.ipDiscovery;
            this.kmsKeyId = builder.kmsKeyId;
            this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
            this.multiAzEnabled = builder.multiAzEnabled;
            this.networkType = builder.networkType;
            this.nodeGroupConfiguration = builder.nodeGroupConfiguration;
            this.notificationTopicArn = builder.notificationTopicArn;
            this.numCacheClusters = builder.numCacheClusters;
            this.numNodeGroups = builder.numNodeGroups;
            this.port = builder.port;
            this.preferredCacheClusterAZs = builder.preferredCacheClusterAZs;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.primaryClusterId = builder.primaryClusterId;
            this.replicasPerNodeGroup = builder.replicasPerNodeGroup;
            this.replicationGroupId = builder.replicationGroupId;
            this.securityGroupIds = builder.securityGroupIds;
            this.snapshotArns = builder.snapshotArns;
            this.snapshotName = builder.snapshotName;
            this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
            this.snapshottingClusterId = builder.snapshottingClusterId;
            this.snapshotWindow = builder.snapshotWindow;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
            this.userGroupIds = builder.userGroupIds;
        }

        @Override
        public final java.lang.String getReplicationGroupDescription() {
            return this.replicationGroupDescription;
        }

        @Override
        public final java.lang.Object getAtRestEncryptionEnabled() {
            return this.atRestEncryptionEnabled;
        }

        @Override
        public final java.lang.String getAuthToken() {
            return this.authToken;
        }

        @Override
        public final java.lang.Object getAutomaticFailoverEnabled() {
            return this.automaticFailoverEnabled;
        }

        @Override
        public final java.lang.Object getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final java.lang.String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final java.lang.String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final java.util.List<java.lang.String> getCacheSecurityGroupNames() {
            return this.cacheSecurityGroupNames;
        }

        @Override
        public final java.lang.String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        @Override
        public final java.lang.Object getDataTieringEnabled() {
            return this.dataTieringEnabled;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.String getGlobalReplicationGroupId() {
            return this.globalReplicationGroupId;
        }

        @Override
        public final java.lang.String getIpDiscovery() {
            return this.ipDiscovery;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getLogDeliveryConfigurations() {
            return this.logDeliveryConfigurations;
        }

        @Override
        public final java.lang.Object getMultiAzEnabled() {
            return this.multiAzEnabled;
        }

        @Override
        public final java.lang.String getNetworkType() {
            return this.networkType;
        }

        @Override
        public final java.lang.Object getNodeGroupConfiguration() {
            return this.nodeGroupConfiguration;
        }

        @Override
        public final java.lang.String getNotificationTopicArn() {
            return this.notificationTopicArn;
        }

        @Override
        public final java.lang.Number getNumCacheClusters() {
            return this.numCacheClusters;
        }

        @Override
        public final java.lang.Number getNumNodeGroups() {
            return this.numNodeGroups;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.util.List<java.lang.String> getPreferredCacheClusterAZs() {
            return this.preferredCacheClusterAZs;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.lang.String getPrimaryClusterId() {
            return this.primaryClusterId;
        }

        @Override
        public final java.lang.Number getReplicasPerNodeGroup() {
            return this.replicasPerNodeGroup;
        }

        @Override
        public final java.lang.String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.util.List<java.lang.String> getSnapshotArns() {
            return this.snapshotArns;
        }

        @Override
        public final java.lang.String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final java.lang.Number getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final java.lang.String getSnapshottingClusterId() {
            return this.snapshottingClusterId;
        }

        @Override
        public final java.lang.String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        @Override
        public final java.util.List<java.lang.String> getUserGroupIds() {
            return this.userGroupIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("replicationGroupDescription", om.valueToTree(this.getReplicationGroupDescription()));
            if (this.getAtRestEncryptionEnabled() != null) {
                data.set("atRestEncryptionEnabled", om.valueToTree(this.getAtRestEncryptionEnabled()));
            }
            if (this.getAuthToken() != null) {
                data.set("authToken", om.valueToTree(this.getAuthToken()));
            }
            if (this.getAutomaticFailoverEnabled() != null) {
                data.set("automaticFailoverEnabled", om.valueToTree(this.getAutomaticFailoverEnabled()));
            }
            if (this.getAutoMinorVersionUpgrade() != null) {
                data.set("autoMinorVersionUpgrade", om.valueToTree(this.getAutoMinorVersionUpgrade()));
            }
            if (this.getCacheNodeType() != null) {
                data.set("cacheNodeType", om.valueToTree(this.getCacheNodeType()));
            }
            if (this.getCacheParameterGroupName() != null) {
                data.set("cacheParameterGroupName", om.valueToTree(this.getCacheParameterGroupName()));
            }
            if (this.getCacheSecurityGroupNames() != null) {
                data.set("cacheSecurityGroupNames", om.valueToTree(this.getCacheSecurityGroupNames()));
            }
            if (this.getCacheSubnetGroupName() != null) {
                data.set("cacheSubnetGroupName", om.valueToTree(this.getCacheSubnetGroupName()));
            }
            if (this.getDataTieringEnabled() != null) {
                data.set("dataTieringEnabled", om.valueToTree(this.getDataTieringEnabled()));
            }
            if (this.getEngine() != null) {
                data.set("engine", om.valueToTree(this.getEngine()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getGlobalReplicationGroupId() != null) {
                data.set("globalReplicationGroupId", om.valueToTree(this.getGlobalReplicationGroupId()));
            }
            if (this.getIpDiscovery() != null) {
                data.set("ipDiscovery", om.valueToTree(this.getIpDiscovery()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getLogDeliveryConfigurations() != null) {
                data.set("logDeliveryConfigurations", om.valueToTree(this.getLogDeliveryConfigurations()));
            }
            if (this.getMultiAzEnabled() != null) {
                data.set("multiAzEnabled", om.valueToTree(this.getMultiAzEnabled()));
            }
            if (this.getNetworkType() != null) {
                data.set("networkType", om.valueToTree(this.getNetworkType()));
            }
            if (this.getNodeGroupConfiguration() != null) {
                data.set("nodeGroupConfiguration", om.valueToTree(this.getNodeGroupConfiguration()));
            }
            if (this.getNotificationTopicArn() != null) {
                data.set("notificationTopicArn", om.valueToTree(this.getNotificationTopicArn()));
            }
            if (this.getNumCacheClusters() != null) {
                data.set("numCacheClusters", om.valueToTree(this.getNumCacheClusters()));
            }
            if (this.getNumNodeGroups() != null) {
                data.set("numNodeGroups", om.valueToTree(this.getNumNodeGroups()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredCacheClusterAZs() != null) {
                data.set("preferredCacheClusterAZs", om.valueToTree(this.getPreferredCacheClusterAZs()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getPrimaryClusterId() != null) {
                data.set("primaryClusterId", om.valueToTree(this.getPrimaryClusterId()));
            }
            if (this.getReplicasPerNodeGroup() != null) {
                data.set("replicasPerNodeGroup", om.valueToTree(this.getReplicasPerNodeGroup()));
            }
            if (this.getReplicationGroupId() != null) {
                data.set("replicationGroupId", om.valueToTree(this.getReplicationGroupId()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSnapshotArns() != null) {
                data.set("snapshotArns", om.valueToTree(this.getSnapshotArns()));
            }
            if (this.getSnapshotName() != null) {
                data.set("snapshotName", om.valueToTree(this.getSnapshotName()));
            }
            if (this.getSnapshotRetentionLimit() != null) {
                data.set("snapshotRetentionLimit", om.valueToTree(this.getSnapshotRetentionLimit()));
            }
            if (this.getSnapshottingClusterId() != null) {
                data.set("snapshottingClusterId", om.valueToTree(this.getSnapshottingClusterId()));
            }
            if (this.getSnapshotWindow() != null) {
                data.set("snapshotWindow", om.valueToTree(this.getSnapshotWindow()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTransitEncryptionEnabled() != null) {
                data.set("transitEncryptionEnabled", om.valueToTree(this.getTransitEncryptionEnabled()));
            }
            if (this.getUserGroupIds() != null) {
                data.set("userGroupIds", om.valueToTree(this.getUserGroupIds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_elasticache.CfnReplicationGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnReplicationGroupProps.Jsii$Proxy that = (CfnReplicationGroupProps.Jsii$Proxy) o;

            if (!replicationGroupDescription.equals(that.replicationGroupDescription)) return false;
            if (this.atRestEncryptionEnabled != null ? !this.atRestEncryptionEnabled.equals(that.atRestEncryptionEnabled) : that.atRestEncryptionEnabled != null) return false;
            if (this.authToken != null ? !this.authToken.equals(that.authToken) : that.authToken != null) return false;
            if (this.automaticFailoverEnabled != null ? !this.automaticFailoverEnabled.equals(that.automaticFailoverEnabled) : that.automaticFailoverEnabled != null) return false;
            if (this.autoMinorVersionUpgrade != null ? !this.autoMinorVersionUpgrade.equals(that.autoMinorVersionUpgrade) : that.autoMinorVersionUpgrade != null) return false;
            if (this.cacheNodeType != null ? !this.cacheNodeType.equals(that.cacheNodeType) : that.cacheNodeType != null) return false;
            if (this.cacheParameterGroupName != null ? !this.cacheParameterGroupName.equals(that.cacheParameterGroupName) : that.cacheParameterGroupName != null) return false;
            if (this.cacheSecurityGroupNames != null ? !this.cacheSecurityGroupNames.equals(that.cacheSecurityGroupNames) : that.cacheSecurityGroupNames != null) return false;
            if (this.cacheSubnetGroupName != null ? !this.cacheSubnetGroupName.equals(that.cacheSubnetGroupName) : that.cacheSubnetGroupName != null) return false;
            if (this.dataTieringEnabled != null ? !this.dataTieringEnabled.equals(that.dataTieringEnabled) : that.dataTieringEnabled != null) return false;
            if (this.engine != null ? !this.engine.equals(that.engine) : that.engine != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.globalReplicationGroupId != null ? !this.globalReplicationGroupId.equals(that.globalReplicationGroupId) : that.globalReplicationGroupId != null) return false;
            if (this.ipDiscovery != null ? !this.ipDiscovery.equals(that.ipDiscovery) : that.ipDiscovery != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.logDeliveryConfigurations != null ? !this.logDeliveryConfigurations.equals(that.logDeliveryConfigurations) : that.logDeliveryConfigurations != null) return false;
            if (this.multiAzEnabled != null ? !this.multiAzEnabled.equals(that.multiAzEnabled) : that.multiAzEnabled != null) return false;
            if (this.networkType != null ? !this.networkType.equals(that.networkType) : that.networkType != null) return false;
            if (this.nodeGroupConfiguration != null ? !this.nodeGroupConfiguration.equals(that.nodeGroupConfiguration) : that.nodeGroupConfiguration != null) return false;
            if (this.notificationTopicArn != null ? !this.notificationTopicArn.equals(that.notificationTopicArn) : that.notificationTopicArn != null) return false;
            if (this.numCacheClusters != null ? !this.numCacheClusters.equals(that.numCacheClusters) : that.numCacheClusters != null) return false;
            if (this.numNodeGroups != null ? !this.numNodeGroups.equals(that.numNodeGroups) : that.numNodeGroups != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredCacheClusterAZs != null ? !this.preferredCacheClusterAZs.equals(that.preferredCacheClusterAZs) : that.preferredCacheClusterAZs != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.primaryClusterId != null ? !this.primaryClusterId.equals(that.primaryClusterId) : that.primaryClusterId != null) return false;
            if (this.replicasPerNodeGroup != null ? !this.replicasPerNodeGroup.equals(that.replicasPerNodeGroup) : that.replicasPerNodeGroup != null) return false;
            if (this.replicationGroupId != null ? !this.replicationGroupId.equals(that.replicationGroupId) : that.replicationGroupId != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.snapshotArns != null ? !this.snapshotArns.equals(that.snapshotArns) : that.snapshotArns != null) return false;
            if (this.snapshotName != null ? !this.snapshotName.equals(that.snapshotName) : that.snapshotName != null) return false;
            if (this.snapshotRetentionLimit != null ? !this.snapshotRetentionLimit.equals(that.snapshotRetentionLimit) : that.snapshotRetentionLimit != null) return false;
            if (this.snapshottingClusterId != null ? !this.snapshottingClusterId.equals(that.snapshottingClusterId) : that.snapshottingClusterId != null) return false;
            if (this.snapshotWindow != null ? !this.snapshotWindow.equals(that.snapshotWindow) : that.snapshotWindow != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.transitEncryptionEnabled != null ? !this.transitEncryptionEnabled.equals(that.transitEncryptionEnabled) : that.transitEncryptionEnabled != null) return false;
            return this.userGroupIds != null ? this.userGroupIds.equals(that.userGroupIds) : that.userGroupIds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.replicationGroupDescription.hashCode();
            result = 31 * result + (this.atRestEncryptionEnabled != null ? this.atRestEncryptionEnabled.hashCode() : 0);
            result = 31 * result + (this.authToken != null ? this.authToken.hashCode() : 0);
            result = 31 * result + (this.automaticFailoverEnabled != null ? this.automaticFailoverEnabled.hashCode() : 0);
            result = 31 * result + (this.autoMinorVersionUpgrade != null ? this.autoMinorVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.cacheNodeType != null ? this.cacheNodeType.hashCode() : 0);
            result = 31 * result + (this.cacheParameterGroupName != null ? this.cacheParameterGroupName.hashCode() : 0);
            result = 31 * result + (this.cacheSecurityGroupNames != null ? this.cacheSecurityGroupNames.hashCode() : 0);
            result = 31 * result + (this.cacheSubnetGroupName != null ? this.cacheSubnetGroupName.hashCode() : 0);
            result = 31 * result + (this.dataTieringEnabled != null ? this.dataTieringEnabled.hashCode() : 0);
            result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.globalReplicationGroupId != null ? this.globalReplicationGroupId.hashCode() : 0);
            result = 31 * result + (this.ipDiscovery != null ? this.ipDiscovery.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.logDeliveryConfigurations != null ? this.logDeliveryConfigurations.hashCode() : 0);
            result = 31 * result + (this.multiAzEnabled != null ? this.multiAzEnabled.hashCode() : 0);
            result = 31 * result + (this.networkType != null ? this.networkType.hashCode() : 0);
            result = 31 * result + (this.nodeGroupConfiguration != null ? this.nodeGroupConfiguration.hashCode() : 0);
            result = 31 * result + (this.notificationTopicArn != null ? this.notificationTopicArn.hashCode() : 0);
            result = 31 * result + (this.numCacheClusters != null ? this.numCacheClusters.hashCode() : 0);
            result = 31 * result + (this.numNodeGroups != null ? this.numNodeGroups.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredCacheClusterAZs != null ? this.preferredCacheClusterAZs.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.primaryClusterId != null ? this.primaryClusterId.hashCode() : 0);
            result = 31 * result + (this.replicasPerNodeGroup != null ? this.replicasPerNodeGroup.hashCode() : 0);
            result = 31 * result + (this.replicationGroupId != null ? this.replicationGroupId.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.snapshotArns != null ? this.snapshotArns.hashCode() : 0);
            result = 31 * result + (this.snapshotName != null ? this.snapshotName.hashCode() : 0);
            result = 31 * result + (this.snapshotRetentionLimit != null ? this.snapshotRetentionLimit.hashCode() : 0);
            result = 31 * result + (this.snapshottingClusterId != null ? this.snapshottingClusterId.hashCode() : 0);
            result = 31 * result + (this.snapshotWindow != null ? this.snapshotWindow.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.transitEncryptionEnabled != null ? this.transitEncryptionEnabled.hashCode() : 0);
            result = 31 * result + (this.userGroupIds != null ? this.userGroupIds.hashCode() : 0);
            return result;
        }
    }
}
