package software.amazon.awscdk.services.ecs.patterns;

/**
 * (experimental) The properties for the base NetworkLoadBalancedEc2Service or NetworkLoadBalancedFargateService service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.ecs.patterns.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.route53.*;
 * import software.amazon.awscdk.services.servicediscovery.*;
 * Cluster cluster;
 * ContainerDefinition containerDefinition;
 * ContainerImage containerImage;
 * Duration duration;
 * HostedZone hostedZone;
 * LogDriver logDriver;
 * INamespace namespace;
 * NetworkLoadBalancer networkLoadBalancer;
 * Role role;
 * Secret secret;
 * Vpc vpc;
 * NetworkLoadBalancedServiceBaseProps networkLoadBalancedServiceBaseProps = NetworkLoadBalancedServiceBaseProps.builder()
 *         .circuitBreaker(DeploymentCircuitBreaker.builder()
 *                 .rollback(false)
 *                 .build())
 *         .cloudMapOptions(CloudMapOptions.builder()
 *                 .cloudMapNamespace(namespace)
 *                 .container(containerDefinition)
 *                 .containerPort(123)
 *                 .dnsRecordType(DnsRecordType.A)
 *                 .dnsTtl(duration)
 *                 .failureThreshold(123)
 *                 .name("name")
 *                 .build())
 *         .cluster(cluster)
 *         .deploymentController(DeploymentController.builder()
 *                 .type(DeploymentControllerType.ECS)
 *                 .build())
 *         .desiredCount(123)
 *         .domainName("domainName")
 *         .domainZone(hostedZone)
 *         .enableECSManagedTags(false)
 *         .healthCheckGracePeriod(duration)
 *         .listenerPort(123)
 *         .loadBalancer(networkLoadBalancer)
 *         .maxHealthyPercent(123)
 *         .minHealthyPercent(123)
 *         .propagateTags(PropagatedTagSource.SERVICE)
 *         .publicLoadBalancer(false)
 *         .recordType(NetworkLoadBalancedServiceRecordType.ALIAS)
 *         .serviceName("serviceName")
 *         .taskImageOptions(NetworkLoadBalancedTaskImageOptions.builder()
 *                 .image(containerImage)
 *                 // the properties below are optional
 *                 .containerName("containerName")
 *                 .containerPort(123)
 *                 .dockerLabels(Map.of(
 *                         "dockerLabelsKey", "dockerLabels"))
 *                 .enableLogging(false)
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .executionRole(role)
 *                 .family("family")
 *                 .logDriver(logDriver)
 *                 .secrets(Map.of(
 *                         "secretsKey", secret))
 *                 .taskRole(role)
 *                 .build())
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:00.031Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecs_patterns.NetworkLoadBalancedServiceBaseProps")
@software.amazon.jsii.Jsii.Proxy(NetworkLoadBalancedServiceBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface NetworkLoadBalancedServiceBaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Whether to enable the deployment circuit breaker.
     * <p>
     * If this property is defined, circuit breaker will be implicitly
     * enabled.
     * <p>
     * Default: - disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker getCircuitBreaker() {
        return null;
    }

    /**
     * (experimental) The options for configuring an Amazon ECS service to use service discovery.
     * <p>
     * Default: - AWS Cloud Map service discovery is not enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CloudMapOptions getCloudMapOptions() {
        return null;
    }

    /**
     * (experimental) The name of the cluster that hosts the service.
     * <p>
     * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
     * <p>
     * Default: - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return null;
    }

    /**
     * (experimental) Specifies which deployment controller to use for the service.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
     * <p>
     * Default: - Rolling update (ECS)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.DeploymentController getDeploymentController() {
        return null;
    }

    /**
     * (experimental) The desired number of instantiations of the task definition to keep running on the service.
     * <p>
     * The minimum value is 1
     * <p>
     * Default: - If the feature flag, ECS_REMOVE_DEFAULT_DESIRED_COUNT is false, the default is 1;
     * if true, the default is 1 for all new services and uses the existing services desired count
     * when updating an existing service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredCount() {
        return null;
    }

    /**
     * (experimental) The domain name for the service, e.g. "api.example.com.".
     * <p>
     * Default: - No domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * (experimental) The Route53 hosted zone for the domain, e.g. "example.com.".
     * <p>
     * Default: - No Route53 hosted domain zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone getDomainZone() {
        return null;
    }

    /**
     * (experimental) Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableECSManagedTags() {
        return null;
    }

    /**
     * (experimental) The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
     * <p>
     * Default: - defaults to 60 seconds if at least one load balancer is in-use and it is not already set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getHealthCheckGracePeriod() {
        return null;
    }

    /**
     * (experimental) Listener port of the network load balancer that will serve traffic to the service.
     * <p>
     * Default: 80
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getListenerPort() {
        return null;
    }

    /**
     * (experimental) The network load balancer that will serve traffic to the service.
     * <p>
     * If the load balancer has been imported, the vpc attribute must be specified
     * in the call to fromNetworkLoadBalancerAttributes().
     * <p>
     * [disable-awslint:ref-via-interface]
     * <p>
     * Default: - a new load balancer will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer getLoadBalancer() {
        return null;
    }

    /**
     * (experimental) The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
     * <p>
     * Default: - 100 if daemon, otherwise 200
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxHealthyPercent() {
        return null;
    }

    /**
     * (experimental) The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
     * <p>
     * Default: - 0 if daemon, otherwise 50
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinHealthyPercent() {
        return null;
    }

    /**
     * (experimental) Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
     * <p>
     * Tags can only be propagated to the tasks within the service during service creation.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
        return null;
    }

    /**
     * (experimental) Determines whether the Load Balancer will be internet-facing.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPublicLoadBalancer() {
        return null;
    }

    /**
     * (experimental) Specifies whether the Route53 record should be a CNAME, an A record using the Alias feature or no record at all.
     * <p>
     * This is useful if you need to work with DNS systems that do not support alias records.
     * <p>
     * Default: NetworkLoadBalancedServiceRecordType.ALIAS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceRecordType getRecordType() {
        return null;
    }

    /**
     * (experimental) The name of the service.
     * <p>
     * Default: - CloudFormation-generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return null;
    }

    /**
     * (experimental) The properties required to create a new task definition.
     * <p>
     * One of taskImageOptions or taskDefinition must be specified.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions getTaskImageOptions() {
        return null;
    }

    /**
     * (experimental) The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
     * <p>
     * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
     * <p>
     * Default: - uses the VPC defined in the cluster or creates a new VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NetworkLoadBalancedServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkLoadBalancedServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkLoadBalancedServiceBaseProps> {
        software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker;
        software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        software.amazon.awscdk.services.ecs.ICluster cluster;
        software.amazon.awscdk.services.ecs.DeploymentController deploymentController;
        java.lang.Number desiredCount;
        java.lang.String domainName;
        software.amazon.awscdk.services.route53.IHostedZone domainZone;
        java.lang.Boolean enableEcsManagedTags;
        software.amazon.awscdk.core.Duration healthCheckGracePeriod;
        java.lang.Number listenerPort;
        software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer;
        java.lang.Number maxHealthyPercent;
        java.lang.Number minHealthyPercent;
        software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        java.lang.Boolean publicLoadBalancer;
        software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceRecordType recordType;
        java.lang.String serviceName;
        software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions taskImageOptions;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getCircuitBreaker}
         * @param circuitBreaker Whether to enable the deployment circuit breaker.
         *                       If this property is defined, circuit breaker will be implicitly
         *                       enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder circuitBreaker(software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getCloudMapOptions}
         * @param cloudMapOptions The options for configuring an Amazon ECS service to use service discovery.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudMapOptions(software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getCluster}
         * @param cluster The name of the cluster that hosts the service.
         *                If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getDeploymentController}
         * @param deploymentController Specifies which deployment controller to use for the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deploymentController(software.amazon.awscdk.services.ecs.DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getDesiredCount}
         * @param desiredCount The desired number of instantiations of the task definition to keep running on the service.
         *                     The minimum value is 1
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder desiredCount(java.lang.Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getDomainName}
         * @param domainName The domain name for the service, e.g. "api.example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getDomainZone}
         * @param domainZone The Route53 hosted zone for the domain, e.g. "example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainZone(software.amazon.awscdk.services.route53.IHostedZone domainZone) {
            this.domainZone = domainZone;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getEnableEcsManagedTags}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getHealthCheckGracePeriod}
         * @param healthCheckGracePeriod The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder healthCheckGracePeriod(software.amazon.awscdk.core.Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getListenerPort}
         * @param listenerPort Listener port of the network load balancer that will serve traffic to the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder listenerPort(java.lang.Number listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getLoadBalancer}
         * @param loadBalancer The network load balancer that will serve traffic to the service.
         *                     If the load balancer has been imported, the vpc attribute must be specified
         *                     in the call to fromNetworkLoadBalancerAttributes().
         *                     <p>
         *                     [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder loadBalancer(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getMaxHealthyPercent}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxHealthyPercent(java.lang.Number maxHealthyPercent) {
            this.maxHealthyPercent = maxHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getMinHealthyPercent}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minHealthyPercent(java.lang.Number minHealthyPercent) {
            this.minHealthyPercent = minHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         *                      Tags can only be propagated to the tasks within the service during service creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder propagateTags(software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getPublicLoadBalancer}
         * @param publicLoadBalancer Determines whether the Load Balancer will be internet-facing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publicLoadBalancer(java.lang.Boolean publicLoadBalancer) {
            this.publicLoadBalancer = publicLoadBalancer;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getRecordType}
         * @param recordType Specifies whether the Route53 record should be a CNAME, an A record using the Alias feature or no record at all.
         *                   This is useful if you need to work with DNS systems that do not support alias records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder recordType(software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceRecordType recordType) {
            this.recordType = recordType;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getServiceName}
         * @param serviceName The name of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getTaskImageOptions}
         * @param taskImageOptions The properties required to create a new task definition.
         *                         One of taskImageOptions or taskDefinition must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder taskImageOptions(software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions taskImageOptions) {
            this.taskImageOptions = taskImageOptions;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedServiceBaseProps#getVpc}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         *            If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkLoadBalancedServiceBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public NetworkLoadBalancedServiceBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkLoadBalancedServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkLoadBalancedServiceBaseProps {
        private final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker;
        private final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final software.amazon.awscdk.services.ecs.DeploymentController deploymentController;
        private final java.lang.Number desiredCount;
        private final java.lang.String domainName;
        private final software.amazon.awscdk.services.route53.IHostedZone domainZone;
        private final java.lang.Boolean enableEcsManagedTags;
        private final software.amazon.awscdk.core.Duration healthCheckGracePeriod;
        private final java.lang.Number listenerPort;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer;
        private final java.lang.Number maxHealthyPercent;
        private final java.lang.Number minHealthyPercent;
        private final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private final java.lang.Boolean publicLoadBalancer;
        private final software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceRecordType recordType;
        private final java.lang.String serviceName;
        private final software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions taskImageOptions;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.circuitBreaker = software.amazon.jsii.Kernel.get(this, "circuitBreaker", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker.class));
            this.cloudMapOptions = software.amazon.jsii.Kernel.get(this, "cloudMapOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CloudMapOptions.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
            this.deploymentController = software.amazon.jsii.Kernel.get(this, "deploymentController", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentController.class));
            this.desiredCount = software.amazon.jsii.Kernel.get(this, "desiredCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainZone = software.amazon.jsii.Kernel.get(this, "domainZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
            this.enableEcsManagedTags = software.amazon.jsii.Kernel.get(this, "enableECSManagedTags", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.healthCheckGracePeriod = software.amazon.jsii.Kernel.get(this, "healthCheckGracePeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.listenerPort = software.amazon.jsii.Kernel.get(this, "listenerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.loadBalancer = software.amazon.jsii.Kernel.get(this, "loadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer.class));
            this.maxHealthyPercent = software.amazon.jsii.Kernel.get(this, "maxHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minHealthyPercent = software.amazon.jsii.Kernel.get(this, "minHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PropagatedTagSource.class));
            this.publicLoadBalancer = software.amazon.jsii.Kernel.get(this, "publicLoadBalancer", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.recordType = software.amazon.jsii.Kernel.get(this, "recordType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceRecordType.class));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.taskImageOptions = software.amazon.jsii.Kernel.get(this, "taskImageOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.circuitBreaker = builder.circuitBreaker;
            this.cloudMapOptions = builder.cloudMapOptions;
            this.cluster = builder.cluster;
            this.deploymentController = builder.deploymentController;
            this.desiredCount = builder.desiredCount;
            this.domainName = builder.domainName;
            this.domainZone = builder.domainZone;
            this.enableEcsManagedTags = builder.enableEcsManagedTags;
            this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
            this.listenerPort = builder.listenerPort;
            this.loadBalancer = builder.loadBalancer;
            this.maxHealthyPercent = builder.maxHealthyPercent;
            this.minHealthyPercent = builder.minHealthyPercent;
            this.propagateTags = builder.propagateTags;
            this.publicLoadBalancer = builder.publicLoadBalancer;
            this.recordType = builder.recordType;
            this.serviceName = builder.serviceName;
            this.taskImageOptions = builder.taskImageOptions;
            this.vpc = builder.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker getCircuitBreaker() {
            return this.circuitBreaker;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.CloudMapOptions getCloudMapOptions() {
            return this.cloudMapOptions;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.DeploymentController getDeploymentController() {
            return this.deploymentController;
        }

        @Override
        public final java.lang.Number getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHostedZone getDomainZone() {
            return this.domainZone;
        }

        @Override
        public final java.lang.Boolean getEnableECSManagedTags() {
            return this.enableEcsManagedTags;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public final java.lang.Number getListenerPort() {
            return this.listenerPort;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer getLoadBalancer() {
            return this.loadBalancer;
        }

        @Override
        public final java.lang.Number getMaxHealthyPercent() {
            return this.maxHealthyPercent;
        }

        @Override
        public final java.lang.Number getMinHealthyPercent() {
            return this.minHealthyPercent;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final java.lang.Boolean getPublicLoadBalancer() {
            return this.publicLoadBalancer;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceRecordType getRecordType() {
            return this.recordType;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions getTaskImageOptions() {
            return this.taskImageOptions;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCircuitBreaker() != null) {
                data.set("circuitBreaker", om.valueToTree(this.getCircuitBreaker()));
            }
            if (this.getCloudMapOptions() != null) {
                data.set("cloudMapOptions", om.valueToTree(this.getCloudMapOptions()));
            }
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }
            if (this.getDeploymentController() != null) {
                data.set("deploymentController", om.valueToTree(this.getDeploymentController()));
            }
            if (this.getDesiredCount() != null) {
                data.set("desiredCount", om.valueToTree(this.getDesiredCount()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getDomainZone() != null) {
                data.set("domainZone", om.valueToTree(this.getDomainZone()));
            }
            if (this.getEnableECSManagedTags() != null) {
                data.set("enableECSManagedTags", om.valueToTree(this.getEnableECSManagedTags()));
            }
            if (this.getHealthCheckGracePeriod() != null) {
                data.set("healthCheckGracePeriod", om.valueToTree(this.getHealthCheckGracePeriod()));
            }
            if (this.getListenerPort() != null) {
                data.set("listenerPort", om.valueToTree(this.getListenerPort()));
            }
            if (this.getLoadBalancer() != null) {
                data.set("loadBalancer", om.valueToTree(this.getLoadBalancer()));
            }
            if (this.getMaxHealthyPercent() != null) {
                data.set("maxHealthyPercent", om.valueToTree(this.getMaxHealthyPercent()));
            }
            if (this.getMinHealthyPercent() != null) {
                data.set("minHealthyPercent", om.valueToTree(this.getMinHealthyPercent()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getPublicLoadBalancer() != null) {
                data.set("publicLoadBalancer", om.valueToTree(this.getPublicLoadBalancer()));
            }
            if (this.getRecordType() != null) {
                data.set("recordType", om.valueToTree(this.getRecordType()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }
            if (this.getTaskImageOptions() != null) {
                data.set("taskImageOptions", om.valueToTree(this.getTaskImageOptions()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_ecs_patterns.NetworkLoadBalancedServiceBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkLoadBalancedServiceBaseProps.Jsii$Proxy that = (NetworkLoadBalancedServiceBaseProps.Jsii$Proxy) o;

            if (this.circuitBreaker != null ? !this.circuitBreaker.equals(that.circuitBreaker) : that.circuitBreaker != null) return false;
            if (this.cloudMapOptions != null ? !this.cloudMapOptions.equals(that.cloudMapOptions) : that.cloudMapOptions != null) return false;
            if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) return false;
            if (this.deploymentController != null ? !this.deploymentController.equals(that.deploymentController) : that.deploymentController != null) return false;
            if (this.desiredCount != null ? !this.desiredCount.equals(that.desiredCount) : that.desiredCount != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.domainZone != null ? !this.domainZone.equals(that.domainZone) : that.domainZone != null) return false;
            if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
            if (this.healthCheckGracePeriod != null ? !this.healthCheckGracePeriod.equals(that.healthCheckGracePeriod) : that.healthCheckGracePeriod != null) return false;
            if (this.listenerPort != null ? !this.listenerPort.equals(that.listenerPort) : that.listenerPort != null) return false;
            if (this.loadBalancer != null ? !this.loadBalancer.equals(that.loadBalancer) : that.loadBalancer != null) return false;
            if (this.maxHealthyPercent != null ? !this.maxHealthyPercent.equals(that.maxHealthyPercent) : that.maxHealthyPercent != null) return false;
            if (this.minHealthyPercent != null ? !this.minHealthyPercent.equals(that.minHealthyPercent) : that.minHealthyPercent != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.publicLoadBalancer != null ? !this.publicLoadBalancer.equals(that.publicLoadBalancer) : that.publicLoadBalancer != null) return false;
            if (this.recordType != null ? !this.recordType.equals(that.recordType) : that.recordType != null) return false;
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
            if (this.taskImageOptions != null ? !this.taskImageOptions.equals(that.taskImageOptions) : that.taskImageOptions != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.circuitBreaker != null ? this.circuitBreaker.hashCode() : 0;
            result = 31 * result + (this.cloudMapOptions != null ? this.cloudMapOptions.hashCode() : 0);
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            result = 31 * result + (this.deploymentController != null ? this.deploymentController.hashCode() : 0);
            result = 31 * result + (this.desiredCount != null ? this.desiredCount.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.domainZone != null ? this.domainZone.hashCode() : 0);
            result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
            result = 31 * result + (this.healthCheckGracePeriod != null ? this.healthCheckGracePeriod.hashCode() : 0);
            result = 31 * result + (this.listenerPort != null ? this.listenerPort.hashCode() : 0);
            result = 31 * result + (this.loadBalancer != null ? this.loadBalancer.hashCode() : 0);
            result = 31 * result + (this.maxHealthyPercent != null ? this.maxHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.minHealthyPercent != null ? this.minHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.publicLoadBalancer != null ? this.publicLoadBalancer.hashCode() : 0);
            result = 31 * result + (this.recordType != null ? this.recordType.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.taskImageOptions != null ? this.taskImageOptions.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
