package software.amazon.awscdk.services.ecs;

/**
 * (experimental) The log settings to use to for logging the execute command session.
 * <p>
 * For more information, see
 * [Logging] https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandconfiguration.html#cfn-ecs-cluster-executecommandconfiguration-logging
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Key kmsKey = new Key(this, "KmsKey");
 * // Pass the KMS key in the `encryptionKey` field to associate the key to the log group
 * LogGroup logGroup = LogGroup.Builder.create(this, "LogGroup")
 *         .encryptionKey(kmsKey)
 *         .build();
 * // Pass the KMS key in the `encryptionKey` field to associate the key to the S3 bucket
 * Bucket execBucket = Bucket.Builder.create(this, "EcsExecBucket")
 *         .encryptionKey(kmsKey)
 *         .build();
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         .vpc(vpc)
 *         .executeCommandConfiguration(ExecuteCommandConfiguration.builder()
 *                 .kmsKey(kmsKey)
 *                 .logConfiguration(ExecuteCommandLogConfiguration.builder()
 *                         .cloudWatchLogGroup(logGroup)
 *                         .cloudWatchEncryptionEnabled(true)
 *                         .s3Bucket(execBucket)
 *                         .s3EncryptionEnabled(true)
 *                         .s3KeyPrefix("exec-command-output")
 *                         .build())
 *                 .logging(ExecuteCommandLogging.OVERRIDE)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:59.774Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecs.ExecuteCommandLogging")
public enum ExecuteCommandLogging {
    /**
     * (experimental) The execute command session is not logged.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NONE,
    /**
     * (experimental) The awslogs configuration in the task definition is used.
     * <p>
     * If no logging parameter is specified, it defaults to this value. If no awslogs log driver is configured in the task definition, the output won't be logged.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DEFAULT,
    /**
     * (experimental) Specify the logging details as a part of logConfiguration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    OVERRIDE,
}
