package software.amazon.awscdk.services.ecr.assets;

/**
 * (experimental) Options to control invalidation of `DockerImageAsset` asset hashes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.assets.DockerImageAsset;
 * DockerImageAsset asset = DockerImageAsset.Builder.create(this, "MyBuildImage")
 *         .directory(join(__dirname, "my-image"))
 *         .buildArgs(Map.of(
 *                 "HTTP_PROXY", "http://10.20.30.2:1234"))
 *         .invalidation(DockerImageAssetInvalidationOptions.builder()
 *                 .buildArgs(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:59.369Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecr_assets.DockerImageAssetInvalidationOptions")
@software.amazon.jsii.Jsii.Proxy(DockerImageAssetInvalidationOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DockerImageAssetInvalidationOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Use `buildArgs` while calculating the asset hash.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBuildArgs() {
        return null;
    }

    /**
     * (experimental) Use `extraHash` while calculating the asset hash.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExtraHash() {
        return null;
    }

    /**
     * (experimental) Use `file` while calculating the asset hash.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFile() {
        return null;
    }

    /**
     * (experimental) Use `networkMode` while calculating the asset hash.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getNetworkMode() {
        return null;
    }

    /**
     * (experimental) Use `platform` while calculating the asset hash.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPlatform() {
        return null;
    }

    /**
     * (experimental) Use `repositoryName` while calculating the asset hash.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRepositoryName() {
        return null;
    }

    /**
     * (experimental) Use `target` while calculating the asset hash.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTarget() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DockerImageAssetInvalidationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DockerImageAssetInvalidationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DockerImageAssetInvalidationOptions> {
        java.lang.Boolean buildArgs;
        java.lang.Boolean extraHash;
        java.lang.Boolean file;
        java.lang.Boolean networkMode;
        java.lang.Boolean platform;
        java.lang.Boolean repositoryName;
        java.lang.Boolean target;

        /**
         * Sets the value of {@link DockerImageAssetInvalidationOptions#getBuildArgs}
         * @param buildArgs Use `buildArgs` while calculating the asset hash.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildArgs(java.lang.Boolean buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetInvalidationOptions#getExtraHash}
         * @param extraHash Use `extraHash` while calculating the asset hash.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder extraHash(java.lang.Boolean extraHash) {
            this.extraHash = extraHash;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetInvalidationOptions#getFile}
         * @param file Use `file` while calculating the asset hash.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder file(java.lang.Boolean file) {
            this.file = file;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetInvalidationOptions#getNetworkMode}
         * @param networkMode Use `networkMode` while calculating the asset hash.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder networkMode(java.lang.Boolean networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetInvalidationOptions#getPlatform}
         * @param platform Use `platform` while calculating the asset hash.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder platform(java.lang.Boolean platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetInvalidationOptions#getRepositoryName}
         * @param repositoryName Use `repositoryName` while calculating the asset hash.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repositoryName(java.lang.Boolean repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageAssetInvalidationOptions#getTarget}
         * @param target Use `target` while calculating the asset hash.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder target(java.lang.Boolean target) {
            this.target = target;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerImageAssetInvalidationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DockerImageAssetInvalidationOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DockerImageAssetInvalidationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerImageAssetInvalidationOptions {
        private final java.lang.Boolean buildArgs;
        private final java.lang.Boolean extraHash;
        private final java.lang.Boolean file;
        private final java.lang.Boolean networkMode;
        private final java.lang.Boolean platform;
        private final java.lang.Boolean repositoryName;
        private final java.lang.Boolean target;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.buildArgs = software.amazon.jsii.Kernel.get(this, "buildArgs", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.extraHash = software.amazon.jsii.Kernel.get(this, "extraHash", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.networkMode = software.amazon.jsii.Kernel.get(this, "networkMode", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.buildArgs = builder.buildArgs;
            this.extraHash = builder.extraHash;
            this.file = builder.file;
            this.networkMode = builder.networkMode;
            this.platform = builder.platform;
            this.repositoryName = builder.repositoryName;
            this.target = builder.target;
        }

        @Override
        public final java.lang.Boolean getBuildArgs() {
            return this.buildArgs;
        }

        @Override
        public final java.lang.Boolean getExtraHash() {
            return this.extraHash;
        }

        @Override
        public final java.lang.Boolean getFile() {
            return this.file;
        }

        @Override
        public final java.lang.Boolean getNetworkMode() {
            return this.networkMode;
        }

        @Override
        public final java.lang.Boolean getPlatform() {
            return this.platform;
        }

        @Override
        public final java.lang.Boolean getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final java.lang.Boolean getTarget() {
            return this.target;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBuildArgs() != null) {
                data.set("buildArgs", om.valueToTree(this.getBuildArgs()));
            }
            if (this.getExtraHash() != null) {
                data.set("extraHash", om.valueToTree(this.getExtraHash()));
            }
            if (this.getFile() != null) {
                data.set("file", om.valueToTree(this.getFile()));
            }
            if (this.getNetworkMode() != null) {
                data.set("networkMode", om.valueToTree(this.getNetworkMode()));
            }
            if (this.getPlatform() != null) {
                data.set("platform", om.valueToTree(this.getPlatform()));
            }
            if (this.getRepositoryName() != null) {
                data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            }
            if (this.getTarget() != null) {
                data.set("target", om.valueToTree(this.getTarget()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_ecr_assets.DockerImageAssetInvalidationOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DockerImageAssetInvalidationOptions.Jsii$Proxy that = (DockerImageAssetInvalidationOptions.Jsii$Proxy) o;

            if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) return false;
            if (this.extraHash != null ? !this.extraHash.equals(that.extraHash) : that.extraHash != null) return false;
            if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
            if (this.networkMode != null ? !this.networkMode.equals(that.networkMode) : that.networkMode != null) return false;
            if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) return false;
            if (this.repositoryName != null ? !this.repositoryName.equals(that.repositoryName) : that.repositoryName != null) return false;
            return this.target != null ? this.target.equals(that.target) : that.target == null;
        }

        @Override
        public final int hashCode() {
            int result = this.buildArgs != null ? this.buildArgs.hashCode() : 0;
            result = 31 * result + (this.extraHash != null ? this.extraHash.hashCode() : 0);
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + (this.networkMode != null ? this.networkMode.hashCode() : 0);
            result = 31 * result + (this.platform != null ? this.platform.hashCode() : 0);
            result = 31 * result + (this.repositoryName != null ? this.repositoryName.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            return result;
        }
    }
}
