package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnVPCEndpointService`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVPCEndpointServiceProps cfnVPCEndpointServiceProps = CfnVPCEndpointServiceProps.builder()
 *         .acceptanceRequired(false)
 *         .contributorInsightsEnabled(false)
 *         .gatewayLoadBalancerArns(List.of("gatewayLoadBalancerArns"))
 *         .networkLoadBalancerArns(List.of("networkLoadBalancerArns"))
 *         .payerResponsibility("payerResponsibility")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:58.933Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ec2.CfnVPCEndpointServiceProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPCEndpointServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVPCEndpointServiceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether requests from service consumers to create an endpoint to your service must be accepted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAcceptanceRequired() {
        return null;
    }

    /**
     * Indicates whether to enable the built-in Contributor Insights rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContributorInsightsEnabled() {
        return null;
    }

    /**
     * The Amazon Resource Names (ARNs) of the Gateway Load Balancers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGatewayLoadBalancerArns() {
        return null;
    }

    /**
     * The Amazon Resource Names (ARNs) of the Network Load Balancers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNetworkLoadBalancerArns() {
        return null;
    }

    /**
     * The entity that is responsible for the endpoint costs.
     * <p>
     * The default is the endpoint owner. If you set the payer responsibility to the service owner, you cannot set it back to the endpoint owner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPayerResponsibility() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVPCEndpointServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCEndpointServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVPCEndpointServiceProps> {
        java.lang.Object acceptanceRequired;
        java.lang.Object contributorInsightsEnabled;
        java.util.List<java.lang.String> gatewayLoadBalancerArns;
        java.util.List<java.lang.String> networkLoadBalancerArns;
        java.lang.String payerResponsibility;

        /**
         * Sets the value of {@link CfnVPCEndpointServiceProps#getAcceptanceRequired}
         * @param acceptanceRequired Indicates whether requests from service consumers to create an endpoint to your service must be accepted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptanceRequired(java.lang.Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointServiceProps#getAcceptanceRequired}
         * @param acceptanceRequired Indicates whether requests from service consumers to create an endpoint to your service must be accepted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptanceRequired(software.amazon.awscdk.core.IResolvable acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointServiceProps#getContributorInsightsEnabled}
         * @param contributorInsightsEnabled Indicates whether to enable the built-in Contributor Insights rules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsightsEnabled(java.lang.Boolean contributorInsightsEnabled) {
            this.contributorInsightsEnabled = contributorInsightsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointServiceProps#getContributorInsightsEnabled}
         * @param contributorInsightsEnabled Indicates whether to enable the built-in Contributor Insights rules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsightsEnabled(software.amazon.awscdk.core.IResolvable contributorInsightsEnabled) {
            this.contributorInsightsEnabled = contributorInsightsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointServiceProps#getGatewayLoadBalancerArns}
         * @param gatewayLoadBalancerArns The Amazon Resource Names (ARNs) of the Gateway Load Balancers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayLoadBalancerArns(java.util.List<java.lang.String> gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns = gatewayLoadBalancerArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointServiceProps#getNetworkLoadBalancerArns}
         * @param networkLoadBalancerArns The Amazon Resource Names (ARNs) of the Network Load Balancers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkLoadBalancerArns(java.util.List<java.lang.String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = networkLoadBalancerArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointServiceProps#getPayerResponsibility}
         * @param payerResponsibility The entity that is responsible for the endpoint costs.
         *                            The default is the endpoint owner. If you set the payer responsibility to the service owner, you cannot set it back to the endpoint owner.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder payerResponsibility(java.lang.String payerResponsibility) {
            this.payerResponsibility = payerResponsibility;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCEndpointServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVPCEndpointServiceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVPCEndpointServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCEndpointServiceProps {
        private final java.lang.Object acceptanceRequired;
        private final java.lang.Object contributorInsightsEnabled;
        private final java.util.List<java.lang.String> gatewayLoadBalancerArns;
        private final java.util.List<java.lang.String> networkLoadBalancerArns;
        private final java.lang.String payerResponsibility;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.acceptanceRequired = software.amazon.jsii.Kernel.get(this, "acceptanceRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.contributorInsightsEnabled = software.amazon.jsii.Kernel.get(this, "contributorInsightsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.gatewayLoadBalancerArns = software.amazon.jsii.Kernel.get(this, "gatewayLoadBalancerArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.networkLoadBalancerArns = software.amazon.jsii.Kernel.get(this, "networkLoadBalancerArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.payerResponsibility = software.amazon.jsii.Kernel.get(this, "payerResponsibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.acceptanceRequired = builder.acceptanceRequired;
            this.contributorInsightsEnabled = builder.contributorInsightsEnabled;
            this.gatewayLoadBalancerArns = builder.gatewayLoadBalancerArns;
            this.networkLoadBalancerArns = builder.networkLoadBalancerArns;
            this.payerResponsibility = builder.payerResponsibility;
        }

        @Override
        public final java.lang.Object getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final java.lang.Object getContributorInsightsEnabled() {
            return this.contributorInsightsEnabled;
        }

        @Override
        public final java.util.List<java.lang.String> getGatewayLoadBalancerArns() {
            return this.gatewayLoadBalancerArns;
        }

        @Override
        public final java.util.List<java.lang.String> getNetworkLoadBalancerArns() {
            return this.networkLoadBalancerArns;
        }

        @Override
        public final java.lang.String getPayerResponsibility() {
            return this.payerResponsibility;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAcceptanceRequired() != null) {
                data.set("acceptanceRequired", om.valueToTree(this.getAcceptanceRequired()));
            }
            if (this.getContributorInsightsEnabled() != null) {
                data.set("contributorInsightsEnabled", om.valueToTree(this.getContributorInsightsEnabled()));
            }
            if (this.getGatewayLoadBalancerArns() != null) {
                data.set("gatewayLoadBalancerArns", om.valueToTree(this.getGatewayLoadBalancerArns()));
            }
            if (this.getNetworkLoadBalancerArns() != null) {
                data.set("networkLoadBalancerArns", om.valueToTree(this.getNetworkLoadBalancerArns()));
            }
            if (this.getPayerResponsibility() != null) {
                data.set("payerResponsibility", om.valueToTree(this.getPayerResponsibility()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_ec2.CfnVPCEndpointServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCEndpointServiceProps.Jsii$Proxy that = (CfnVPCEndpointServiceProps.Jsii$Proxy) o;

            if (this.acceptanceRequired != null ? !this.acceptanceRequired.equals(that.acceptanceRequired) : that.acceptanceRequired != null) return false;
            if (this.contributorInsightsEnabled != null ? !this.contributorInsightsEnabled.equals(that.contributorInsightsEnabled) : that.contributorInsightsEnabled != null) return false;
            if (this.gatewayLoadBalancerArns != null ? !this.gatewayLoadBalancerArns.equals(that.gatewayLoadBalancerArns) : that.gatewayLoadBalancerArns != null) return false;
            if (this.networkLoadBalancerArns != null ? !this.networkLoadBalancerArns.equals(that.networkLoadBalancerArns) : that.networkLoadBalancerArns != null) return false;
            return this.payerResponsibility != null ? this.payerResponsibility.equals(that.payerResponsibility) : that.payerResponsibility == null;
        }

        @Override
        public final int hashCode() {
            int result = this.acceptanceRequired != null ? this.acceptanceRequired.hashCode() : 0;
            result = 31 * result + (this.contributorInsightsEnabled != null ? this.contributorInsightsEnabled.hashCode() : 0);
            result = 31 * result + (this.gatewayLoadBalancerArns != null ? this.gatewayLoadBalancerArns.hashCode() : 0);
            result = 31 * result + (this.networkLoadBalancerArns != null ? this.networkLoadBalancerArns.hashCode() : 0);
            result = 31 * result + (this.payerResponsibility != null ? this.payerResponsibility.hashCode() : 0);
            return result;
        }
    }
}
