package software.amazon.awscdk.services.connect;

/**
 * A CloudFormation `AWS::Connect::InstanceStorageConfig`.
 * <p>
 * The storage configuration for the instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnInstanceStorageConfig cfnInstanceStorageConfig = CfnInstanceStorageConfig.Builder.create(this, "MyCfnInstanceStorageConfig")
 *         .instanceArn("instanceArn")
 *         .resourceType("resourceType")
 *         .storageType("storageType")
 *         // the properties below are optional
 *         .kinesisFirehoseConfig(KinesisFirehoseConfigProperty.builder()
 *                 .firehoseArn("firehoseArn")
 *                 .build())
 *         .kinesisStreamConfig(KinesisStreamConfigProperty.builder()
 *                 .streamArn("streamArn")
 *                 .build())
 *         .kinesisVideoStreamConfig(KinesisVideoStreamConfigProperty.builder()
 *                 .prefix("prefix")
 *                 .retentionPeriodHours(123)
 *                 // the properties below are optional
 *                 .encryptionConfig(EncryptionConfigProperty.builder()
 *                         .encryptionType("encryptionType")
 *                         .keyId("keyId")
 *                         .build())
 *                 .build())
 *         .s3Config(S3ConfigProperty.builder()
 *                 .bucketName("bucketName")
 *                 .bucketPrefix("bucketPrefix")
 *                 // the properties below are optional
 *                 .encryptionConfig(EncryptionConfigProperty.builder()
 *                         .encryptionType("encryptionType")
 *                         .keyId("keyId")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:57.328Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnInstanceStorageConfig")
public class CfnInstanceStorageConfig extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnInstanceStorageConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstanceStorageConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Connect::InstanceStorageConfig`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInstanceStorageConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnInstanceStorageConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAssociationId() {
        return software.amazon.jsii.Kernel.get(this, "attrAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceArn", java.util.Objects.requireNonNull(value, "instanceArn is required"));
    }

    /**
     * A valid resource type.
     * <p>
     * Following are the valid resource types: <code>CHAT_TRANSCRIPTS</code> | <code>CALL_RECORDINGS</code> | <code>SCHEDULED_REPORTS</code> | <code>MEDIA_STREAMS</code> | <code>CONTACT_TRACE_RECORDS</code> | <code>AGENT_EVENTS</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A valid resource type.
     * <p>
     * Following are the valid resource types: <code>CHAT_TRANSCRIPTS</code> | <code>CALL_RECORDINGS</code> | <code>SCHEDULED_REPORTS</code> | <code>MEDIA_STREAMS</code> | <code>CONTACT_TRACE_RECORDS</code> | <code>AGENT_EVENTS</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceType", java.util.Objects.requireNonNull(value, "resourceType is required"));
    }

    /**
     * A valid storage type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStorageType() {
        return software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A valid storage type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "storageType", java.util.Objects.requireNonNull(value, "storageType is required"));
    }

    /**
     * The configuration of the Kinesis Firehose delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKinesisFirehoseConfig() {
        return software.amazon.jsii.Kernel.get(this, "kinesisFirehoseConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of the Kinesis Firehose delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisFirehoseConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.KinesisFirehoseConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "kinesisFirehoseConfig", value);
    }

    /**
     * The configuration of the Kinesis Firehose delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisFirehoseConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kinesisFirehoseConfig", value);
    }

    /**
     * The configuration of the Kinesis data stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamConfig() {
        return software.amazon.jsii.Kernel.get(this, "kinesisStreamConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of the Kinesis data stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisStreamConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.KinesisStreamConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "kinesisStreamConfig", value);
    }

    /**
     * The configuration of the Kinesis data stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisStreamConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kinesisStreamConfig", value);
    }

    /**
     * The configuration of the Kinesis video stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKinesisVideoStreamConfig() {
        return software.amazon.jsii.Kernel.get(this, "kinesisVideoStreamConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of the Kinesis video stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisVideoStreamConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.KinesisVideoStreamConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "kinesisVideoStreamConfig", value);
    }

    /**
     * The configuration of the Kinesis video stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisVideoStreamConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kinesisVideoStreamConfig", value);
    }

    /**
     * The S3 bucket configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getS3Config() {
        return software.amazon.jsii.Kernel.get(this, "s3Config", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The S3 bucket configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Config(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.S3ConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "s3Config", value);
    }

    /**
     * The S3 bucket configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Config(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "s3Config", value);
    }
    /**
     * The encryption configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EncryptionConfigProperty encryptionConfigProperty = EncryptionConfigProperty.builder()
     *         .encryptionType("encryptionType")
     *         .keyId("keyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnInstanceStorageConfig.EncryptionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of encryption.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncryptionType();

        /**
         * The full ARN of the encryption key.
         * <p>
         * <blockquote>
         * <p>
         * Be sure to provide the full ARN of the encryption key, not just the ID.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyId();

        /**
         * @return a {@link Builder} of {@link EncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigProperty> {
            java.lang.String encryptionType;
            java.lang.String keyId;

            /**
             * Sets the value of {@link EncryptionConfigProperty#getEncryptionType}
             * @param encryptionType The type of encryption. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionType(java.lang.String encryptionType) {
                this.encryptionType = encryptionType;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigProperty#getKeyId}
             * @param keyId The full ARN of the encryption key. This parameter is required.
             *              <blockquote>
             *              <p>
             *              Be sure to provide the full ARN of the encryption key, not just the ID.
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyId(java.lang.String keyId) {
                this.keyId = keyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigProperty {
            private final java.lang.String encryptionType;
            private final java.lang.String keyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionType = software.amazon.jsii.Kernel.get(this, "encryptionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyId = software.amazon.jsii.Kernel.get(this, "keyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionType = java.util.Objects.requireNonNull(builder.encryptionType, "encryptionType is required");
                this.keyId = java.util.Objects.requireNonNull(builder.keyId, "keyId is required");
            }

            @Override
            public final java.lang.String getEncryptionType() {
                return this.encryptionType;
            }

            @Override
            public final java.lang.String getKeyId() {
                return this.keyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionType", om.valueToTree(this.getEncryptionType()));
                data.set("keyId", om.valueToTree(this.getKeyId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_connect.CfnInstanceStorageConfig.EncryptionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigProperty.Jsii$Proxy that = (EncryptionConfigProperty.Jsii$Proxy) o;

                if (!encryptionType.equals(that.encryptionType)) return false;
                return this.keyId.equals(that.keyId);
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionType.hashCode();
                result = 31 * result + (this.keyId.hashCode());
                return result;
            }
        }
    }
    /**
     * Configuration information of a Kinesis Data Firehose delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * KinesisFirehoseConfigProperty kinesisFirehoseConfigProperty = KinesisFirehoseConfigProperty.builder()
     *         .firehoseArn("firehoseArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnInstanceStorageConfig.KinesisFirehoseConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisFirehoseConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisFirehoseConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFirehoseArn();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisFirehoseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisFirehoseConfigProperty> {
            java.lang.String firehoseArn;

            /**
             * Sets the value of {@link KinesisFirehoseConfigProperty#getFirehoseArn}
             * @param firehoseArn The Amazon Resource Name (ARN) of the delivery stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firehoseArn(java.lang.String firehoseArn) {
                this.firehoseArn = firehoseArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisFirehoseConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisFirehoseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisFirehoseConfigProperty {
            private final java.lang.String firehoseArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.firehoseArn = software.amazon.jsii.Kernel.get(this, "firehoseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.firehoseArn = java.util.Objects.requireNonNull(builder.firehoseArn, "firehoseArn is required");
            }

            @Override
            public final java.lang.String getFirehoseArn() {
                return this.firehoseArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("firehoseArn", om.valueToTree(this.getFirehoseArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_connect.CfnInstanceStorageConfig.KinesisFirehoseConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisFirehoseConfigProperty.Jsii$Proxy that = (KinesisFirehoseConfigProperty.Jsii$Proxy) o;

                return this.firehoseArn.equals(that.firehoseArn);
            }

            @Override
            public final int hashCode() {
                int result = this.firehoseArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration information of a Kinesis data stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * KinesisStreamConfigProperty kinesisStreamConfigProperty = KinesisStreamConfigProperty.builder()
     *         .streamArn("streamArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnInstanceStorageConfig.KinesisStreamConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisStreamConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisStreamConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the data stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStreamArn();

        /**
         * @return a {@link Builder} of {@link KinesisStreamConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisStreamConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisStreamConfigProperty> {
            java.lang.String streamArn;

            /**
             * Sets the value of {@link KinesisStreamConfigProperty#getStreamArn}
             * @param streamArn The Amazon Resource Name (ARN) of the data stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamArn(java.lang.String streamArn) {
                this.streamArn = streamArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisStreamConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisStreamConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisStreamConfigProperty {
            private final java.lang.String streamArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.streamArn = software.amazon.jsii.Kernel.get(this, "streamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.streamArn = java.util.Objects.requireNonNull(builder.streamArn, "streamArn is required");
            }

            @Override
            public final java.lang.String getStreamArn() {
                return this.streamArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("streamArn", om.valueToTree(this.getStreamArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_connect.CfnInstanceStorageConfig.KinesisStreamConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisStreamConfigProperty.Jsii$Proxy that = (KinesisStreamConfigProperty.Jsii$Proxy) o;

                return this.streamArn.equals(that.streamArn);
            }

            @Override
            public final int hashCode() {
                int result = this.streamArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration information of a Kinesis video stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * KinesisVideoStreamConfigProperty kinesisVideoStreamConfigProperty = KinesisVideoStreamConfigProperty.builder()
     *         .prefix("prefix")
     *         .retentionPeriodHours(123)
     *         // the properties below are optional
     *         .encryptionConfig(EncryptionConfigProperty.builder()
     *                 .encryptionType("encryptionType")
     *                 .keyId("keyId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnInstanceStorageConfig.KinesisVideoStreamConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisVideoStreamConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisVideoStreamConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The prefix of the video stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrefix();

        /**
         * The number of hours data is retained in the stream.
         * <p>
         * Kinesis Video Streams retains the data in a data store that is associated with the stream.
         * <p>
         * The default value is 0, indicating that the stream does not persist data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getRetentionPeriodHours();

        /**
         * The encryption configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KinesisVideoStreamConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisVideoStreamConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisVideoStreamConfigProperty> {
            java.lang.String prefix;
            java.lang.Number retentionPeriodHours;
            java.lang.Object encryptionConfig;

            /**
             * Sets the value of {@link KinesisVideoStreamConfigProperty#getPrefix}
             * @param prefix The prefix of the video stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link KinesisVideoStreamConfigProperty#getRetentionPeriodHours}
             * @param retentionPeriodHours The number of hours data is retained in the stream. This parameter is required.
             *                             Kinesis Video Streams retains the data in a data store that is associated with the stream.
             *                             <p>
             *                             The default value is 0, indicating that the stream does not persist data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retentionPeriodHours(java.lang.Number retentionPeriodHours) {
                this.retentionPeriodHours = retentionPeriodHours;
                return this;
            }

            /**
             * Sets the value of {@link KinesisVideoStreamConfigProperty#getEncryptionConfig}
             * @param encryptionConfig The encryption configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfig(software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.EncryptionConfigProperty encryptionConfig) {
                this.encryptionConfig = encryptionConfig;
                return this;
            }

            /**
             * Sets the value of {@link KinesisVideoStreamConfigProperty#getEncryptionConfig}
             * @param encryptionConfig The encryption configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfig(software.amazon.awscdk.core.IResolvable encryptionConfig) {
                this.encryptionConfig = encryptionConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisVideoStreamConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisVideoStreamConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisVideoStreamConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisVideoStreamConfigProperty {
            private final java.lang.String prefix;
            private final java.lang.Number retentionPeriodHours;
            private final java.lang.Object encryptionConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retentionPeriodHours = software.amazon.jsii.Kernel.get(this, "retentionPeriodHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.encryptionConfig = software.amazon.jsii.Kernel.get(this, "encryptionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.prefix = java.util.Objects.requireNonNull(builder.prefix, "prefix is required");
                this.retentionPeriodHours = java.util.Objects.requireNonNull(builder.retentionPeriodHours, "retentionPeriodHours is required");
                this.encryptionConfig = builder.encryptionConfig;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Number getRetentionPeriodHours() {
                return this.retentionPeriodHours;
            }

            @Override
            public final java.lang.Object getEncryptionConfig() {
                return this.encryptionConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("prefix", om.valueToTree(this.getPrefix()));
                data.set("retentionPeriodHours", om.valueToTree(this.getRetentionPeriodHours()));
                if (this.getEncryptionConfig() != null) {
                    data.set("encryptionConfig", om.valueToTree(this.getEncryptionConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_connect.CfnInstanceStorageConfig.KinesisVideoStreamConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisVideoStreamConfigProperty.Jsii$Proxy that = (KinesisVideoStreamConfigProperty.Jsii$Proxy) o;

                if (!prefix.equals(that.prefix)) return false;
                if (!retentionPeriodHours.equals(that.retentionPeriodHours)) return false;
                return this.encryptionConfig != null ? this.encryptionConfig.equals(that.encryptionConfig) : that.encryptionConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.prefix.hashCode();
                result = 31 * result + (this.retentionPeriodHours.hashCode());
                result = 31 * result + (this.encryptionConfig != null ? this.encryptionConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the Amazon Simple Storage Service (Amazon S3) storage type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * S3ConfigProperty s3ConfigProperty = S3ConfigProperty.builder()
     *         .bucketName("bucketName")
     *         .bucketPrefix("bucketPrefix")
     *         // the properties below are optional
     *         .encryptionConfig(EncryptionConfigProperty.builder()
     *                 .encryptionType("encryptionType")
     *                 .keyId("keyId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_connect.CfnInstanceStorageConfig.S3ConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 bucket name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The S3 bucket prefix.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketPrefix();

        /**
         * The Amazon S3 encryption configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ConfigProperty> {
            java.lang.String bucketName;
            java.lang.String bucketPrefix;
            java.lang.Object encryptionConfig;

            /**
             * Sets the value of {@link S3ConfigProperty#getBucketName}
             * @param bucketName The S3 bucket name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigProperty#getBucketPrefix}
             * @param bucketPrefix The S3 bucket prefix. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigProperty#getEncryptionConfig}
             * @param encryptionConfig The Amazon S3 encryption configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfig(software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.EncryptionConfigProperty encryptionConfig) {
                this.encryptionConfig = encryptionConfig;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigProperty#getEncryptionConfig}
             * @param encryptionConfig The Amazon S3 encryption configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfig(software.amazon.awscdk.core.IResolvable encryptionConfig) {
                this.encryptionConfig = encryptionConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ConfigProperty {
            private final java.lang.String bucketName;
            private final java.lang.String bucketPrefix;
            private final java.lang.Object encryptionConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionConfig = software.amazon.jsii.Kernel.get(this, "encryptionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.bucketPrefix = java.util.Objects.requireNonNull(builder.bucketPrefix, "bucketPrefix is required");
                this.encryptionConfig = builder.encryptionConfig;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.Object getEncryptionConfig() {
                return this.encryptionConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                if (this.getEncryptionConfig() != null) {
                    data.set("encryptionConfig", om.valueToTree(this.getEncryptionConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_connect.CfnInstanceStorageConfig.S3ConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ConfigProperty.Jsii$Proxy that = (S3ConfigProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (!bucketPrefix.equals(that.bucketPrefix)) return false;
                return this.encryptionConfig != null ? this.encryptionConfig.equals(that.encryptionConfig) : that.encryptionConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.bucketPrefix.hashCode());
                result = 31 * result + (this.encryptionConfig != null ? this.encryptionConfig.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connect.CfnInstanceStorageConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connect.CfnInstanceStorageConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connect.CfnInstanceStorageConfigProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connect.CfnInstanceStorageConfigProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the instance.
         * <p>
         * @return {@code this}
         * @param instanceArn The Amazon Resource Name (ARN) of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(final java.lang.String instanceArn) {
            this.props.instanceArn(instanceArn);
            return this;
        }

        /**
         * A valid resource type.
         * <p>
         * Following are the valid resource types: <code>CHAT_TRANSCRIPTS</code> | <code>CALL_RECORDINGS</code> | <code>SCHEDULED_REPORTS</code> | <code>MEDIA_STREAMS</code> | <code>CONTACT_TRACE_RECORDS</code> | <code>AGENT_EVENTS</code>
         * <p>
         * @return {@code this}
         * @param resourceType A valid resource type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(final java.lang.String resourceType) {
            this.props.resourceType(resourceType);
            return this;
        }

        /**
         * A valid storage type.
         * <p>
         * @return {@code this}
         * @param storageType A valid storage type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(final java.lang.String storageType) {
            this.props.storageType(storageType);
            return this;
        }

        /**
         * The configuration of the Kinesis Firehose delivery stream.
         * <p>
         * @return {@code this}
         * @param kinesisFirehoseConfig The configuration of the Kinesis Firehose delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisFirehoseConfig(final software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.KinesisFirehoseConfigProperty kinesisFirehoseConfig) {
            this.props.kinesisFirehoseConfig(kinesisFirehoseConfig);
            return this;
        }
        /**
         * The configuration of the Kinesis Firehose delivery stream.
         * <p>
         * @return {@code this}
         * @param kinesisFirehoseConfig The configuration of the Kinesis Firehose delivery stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisFirehoseConfig(final software.amazon.awscdk.core.IResolvable kinesisFirehoseConfig) {
            this.props.kinesisFirehoseConfig(kinesisFirehoseConfig);
            return this;
        }

        /**
         * The configuration of the Kinesis data stream.
         * <p>
         * @return {@code this}
         * @param kinesisStreamConfig The configuration of the Kinesis data stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamConfig(final software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.KinesisStreamConfigProperty kinesisStreamConfig) {
            this.props.kinesisStreamConfig(kinesisStreamConfig);
            return this;
        }
        /**
         * The configuration of the Kinesis data stream.
         * <p>
         * @return {@code this}
         * @param kinesisStreamConfig The configuration of the Kinesis data stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamConfig(final software.amazon.awscdk.core.IResolvable kinesisStreamConfig) {
            this.props.kinesisStreamConfig(kinesisStreamConfig);
            return this;
        }

        /**
         * The configuration of the Kinesis video stream.
         * <p>
         * @return {@code this}
         * @param kinesisVideoStreamConfig The configuration of the Kinesis video stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisVideoStreamConfig(final software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.KinesisVideoStreamConfigProperty kinesisVideoStreamConfig) {
            this.props.kinesisVideoStreamConfig(kinesisVideoStreamConfig);
            return this;
        }
        /**
         * The configuration of the Kinesis video stream.
         * <p>
         * @return {@code this}
         * @param kinesisVideoStreamConfig The configuration of the Kinesis video stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisVideoStreamConfig(final software.amazon.awscdk.core.IResolvable kinesisVideoStreamConfig) {
            this.props.kinesisVideoStreamConfig(kinesisVideoStreamConfig);
            return this;
        }

        /**
         * The S3 bucket configuration.
         * <p>
         * @return {@code this}
         * @param s3Config The S3 bucket configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Config(final software.amazon.awscdk.services.connect.CfnInstanceStorageConfig.S3ConfigProperty s3Config) {
            this.props.s3Config(s3Config);
            return this;
        }
        /**
         * The S3 bucket configuration.
         * <p>
         * @return {@code this}
         * @param s3Config The S3 bucket configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Config(final software.amazon.awscdk.core.IResolvable s3Config) {
            this.props.s3Config(s3Config);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.connect.CfnInstanceStorageConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connect.CfnInstanceStorageConfig build() {
            return new software.amazon.awscdk.services.connect.CfnInstanceStorageConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
