package software.amazon.awscdk.services.config;

/**
 * (experimental) The maximum frequency at which the AWS Config rule runs evaluations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html
 * // https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html
 * ManagedRule.Builder.create(this, "AccessKeysRotated")
 *         .identifier(ManagedRuleIdentifiers.ACCESS_KEYS_ROTATED)
 *         .inputParameters(Map.of(
 *                 "maxAccessKeyAge", 60))
 *         // default is 24 hours
 *         .maximumExecutionFrequency(MaximumExecutionFrequency.TWELVE_HOURS)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:57.285Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_config.MaximumExecutionFrequency")
public enum MaximumExecutionFrequency {
    /**
     * (experimental) 1 hour.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ONE_HOUR,
    /**
     * (experimental) 3 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    THREE_HOURS,
    /**
     * (experimental) 6 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SIX_HOURS,
    /**
     * (experimental) 12 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TWELVE_HOURS,
    /**
     * (experimental) 24 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TWENTY_FOUR_HOURS,
}
