package software.amazon.awscdk.services.config;

/**
 * (experimental) Checks whether your CloudFormation stacks are sending event notifications to a SNS topic.
 * <p>
 * Optionally checks whether specified SNS topics are used.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // topics to which CloudFormation stacks may send event notifications
 * Topic topic1 = new Topic(this, "AllowedTopic1");
 * Topic topic2 = new Topic(this, "AllowedTopic2");
 * // non-compliant if CloudFormation stack does not send notifications to 'topic1' or 'topic2'
 * // non-compliant if CloudFormation stack does not send notifications to 'topic1' or 'topic2'
 * CloudFormationStackNotificationCheck.Builder.create(this, "NotificationCheck")
 *         .topics(List.of(topic1, topic2))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-notification-check.html">https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-notification-check.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:57.272Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_config.CloudFormationStackNotificationCheck")
public class CloudFormationStackNotificationCheck extends software.amazon.awscdk.services.config.ManagedRule {

    protected CloudFormationStackNotificationCheck(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationStackNotificationCheck(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CloudFormationStackNotificationCheck(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CloudFormationStackNotificationCheckProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CloudFormationStackNotificationCheck(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.config.CloudFormationStackNotificationCheck}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.config.CloudFormationStackNotificationCheck> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.config.CloudFormationStackNotificationCheckProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) A name for the AWS Config rule.
         * <p>
         * Default: - CloudFormation generated name
         * <p>
         * @return {@code this}
         * @param configRuleName A name for the AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder configRuleName(final java.lang.String configRuleName) {
            this.props().configRuleName(configRuleName);
            return this;
        }

        /**
         * (experimental) A description about this AWS Config rule.
         * <p>
         * Default: - No description
         * <p>
         * @return {@code this}
         * @param description A description about this AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * (experimental) Input parameter values that are passed to the AWS Config rule.
         * <p>
         * Default: - No input parameters
         * <p>
         * @return {@code this}
         * @param inputParameters Input parameter values that are passed to the AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inputParameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> inputParameters) {
            this.props().inputParameters(inputParameters);
            return this;
        }

        /**
         * (experimental) The maximum frequency at which the AWS Config rule runs evaluations.
         * <p>
         * Default: MaximumExecutionFrequency.TWENTY_FOUR_HOURS
         * <p>
         * @return {@code this}
         * @param maximumExecutionFrequency The maximum frequency at which the AWS Config rule runs evaluations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maximumExecutionFrequency(final software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency) {
            this.props().maximumExecutionFrequency(maximumExecutionFrequency);
            return this;
        }

        /**
         * (experimental) Defines which resources trigger an evaluation for an AWS Config rule.
         * <p>
         * Default: - evaluations for the rule are triggered when any resource in the recording group changes.
         * <p>
         * @return {@code this}
         * @param ruleScope Defines which resources trigger an evaluation for an AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ruleScope(final software.amazon.awscdk.services.config.RuleScope ruleScope) {
            this.props().ruleScope(ruleScope);
            return this;
        }

        /**
         * (experimental) A list of allowed topics.
         * <p>
         * At most 5 topics.
         * <p>
         * Default: - No topics.
         * <p>
         * @return {@code this}
         * @param topics A list of allowed topics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder topics(final java.util.List<? extends software.amazon.awscdk.services.sns.ITopic> topics) {
            this.props().topics(topics);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.config.CloudFormationStackNotificationCheck}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.config.CloudFormationStackNotificationCheck build() {
            return new software.amazon.awscdk.services.config.CloudFormationStackNotificationCheck(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.config.CloudFormationStackNotificationCheckProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.config.CloudFormationStackNotificationCheckProps.Builder();
            }
            return this.props;
        }
    }
}
