package software.amazon.awscdk.services.config;

/**
 * A CloudFormation `AWS::Config::ConfigRule`.
 * <p>
 * Adds or updates an AWS Config rule to evaluate if your AWS resources comply with your desired configurations. For information on how many AWS Config rules you can have per account, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"><em>Service Limits</em></a> in the <em>AWS Config Developer Guide</em> .
 * <p>
 * There are two types of rules: <em>AWS Config Managed Rules</em> and <em>AWS Config Custom Rules</em> . You can use the <code>ConfigRule</code> resource to create both AWS Config Managed Rules and AWS Config Custom Rules.
 * <p>
 * AWS Config Managed Rules are predefined, customizable rules created by AWS Config . For a list of managed rules, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of AWS Config Managed Rules</a> . If you are adding an AWS Config managed rule, you must specify the rule's identifier for the <code>SourceIdentifier</code> key.
 * <p>
 * AWS Config Custom Rules are rules that you create from scratch. There are two ways to create AWS Config custom rules: with Lambda functions ( <a href="https://docs.aws.amazon.com/config/latest/developerguide/gettingstarted-concepts.html#gettingstarted-concepts-function">AWS Lambda Developer Guide</a> ) and with Guard ( <a href="https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a> ), a policy-as-code language. AWS Config custom rules created with AWS Lambda are called <em>AWS Config Custom Lambda Rules</em> and AWS Config custom rules created with Guard are called <em>AWS Config Custom Policy Rules</em> .
 * <p>
 * If you are adding a new AWS Config Custom Lambda rule, you first need to create an AWS Lambda function that the rule invokes to evaluate your resources. When you use the <code>ConfigRule</code> resource to add a Custom Lambda rule to AWS Config , you must specify the Amazon Resource Name (ARN) that AWS Lambda assigns to the function. You specify the ARN in the <code>SourceIdentifier</code> key. This key is part of the <code>Source</code> object, which is part of the <code>ConfigRule</code> object.
 * <p>
 * For any new AWS Config rule that you add, specify the <code>ConfigRuleName</code> in the <code>ConfigRule</code> object. Do not specify the <code>ConfigRuleArn</code> or the <code>ConfigRuleId</code> . These values are generated by AWS Config for new rules.
 * <p>
 * If you are updating a rule that you added previously, you can specify the rule by <code>ConfigRuleName</code> , <code>ConfigRuleId</code> , or <code>ConfigRuleArn</code> in the <code>ConfigRule</code> data type that you use in this request.
 * <p>
 * For more information about developing and using AWS Config rules, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating Resources with AWS Config Rules</a> in the <em>AWS Config Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * Object inputParameters;
 * CfnConfigRule cfnConfigRule = CfnConfigRule.Builder.create(this, "MyCfnConfigRule")
 *         .source(SourceProperty.builder()
 *                 .owner("owner")
 *                 // the properties below are optional
 *                 .customPolicyDetails(CustomPolicyDetailsProperty.builder()
 *                         .enableDebugLogDelivery(false)
 *                         .policyRuntime("policyRuntime")
 *                         .policyText("policyText")
 *                         .build())
 *                 .sourceDetails(List.of(SourceDetailProperty.builder()
 *                         .eventSource("eventSource")
 *                         .messageType("messageType")
 *                         // the properties below are optional
 *                         .maximumExecutionFrequency("maximumExecutionFrequency")
 *                         .build()))
 *                 .sourceIdentifier("sourceIdentifier")
 *                 .build())
 *         // the properties below are optional
 *         .configRuleName("configRuleName")
 *         .description("description")
 *         .inputParameters(inputParameters)
 *         .maximumExecutionFrequency("maximumExecutionFrequency")
 *         .scope(ScopeProperty.builder()
 *                 .complianceResourceId("complianceResourceId")
 *                 .complianceResourceTypes(List.of("complianceResourceTypes"))
 *                 .tagKey("tagKey")
 *                 .tagValue("tagValue")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:57.191Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_config.CfnConfigRule")
public class CfnConfigRule extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnConfigRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.CfnConfigRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Config::ConfigRule`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.CfnConfigRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the AWS Config rule, such as `arn:aws:config:us-east-1:123456789012:config-rule/config-rule-a1bzhi` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The compliance status of an AWS Config rule, such as `COMPLIANT` or `NON_COMPLIANT` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrComplianceType() {
        return software.amazon.jsii.Kernel.get(this, "attrComplianceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS Config rule, such as `config-rule-a1bzhi` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigRuleId() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigRuleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A string, in JSON format, that is passed to the AWS Config rule Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInputParameters() {
        return software.amazon.jsii.Kernel.get(this, "inputParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A string, in JSON format, that is passed to the AWS Config rule Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputParameters(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "inputParameters", java.util.Objects.requireNonNull(value, "inputParameters is required"));
    }

    /**
     * Provides the rule owner ( `AWS` for managed rules, `CUSTOM_POLICY` for Custom Policy rules, and `CUSTOM_LAMBDA` for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSource() {
        return software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Provides the rule owner ( `AWS` for managed rules, `CUSTOM_POLICY` for Custom Policy rules, and `CUSTOM_LAMBDA` for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.CfnConfigRule.SourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "source", java.util.Objects.requireNonNull(value, "source is required"));
    }

    /**
     * Provides the rule owner ( `AWS` for managed rules, `CUSTOM_POLICY` for Custom Policy rules, and `CUSTOM_LAMBDA` for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "source", java.util.Objects.requireNonNull(value, "source is required"));
    }

    /**
     * A name for the AWS Config rule.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the rule name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConfigRuleName() {
        return software.amazon.jsii.Kernel.get(this, "configRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the AWS Config rule.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the rule name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigRuleName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "configRuleName", value);
    }

    /**
     * The description that you provide for the AWS Config rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description that you provide for the AWS Config rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The maximum frequency with which AWS Config runs evaluations for a rule.
     * <p>
     * You can specify a value for <code>MaximumExecutionFrequency</code> when:
     * <p>
     * <ul>
     * <li>You are using an AWS managed rule that is triggered at a periodic frequency.</li>
     * <li>Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html">ConfigSnapshotDeliveryProperties</a> .</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMaximumExecutionFrequency() {
        return software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The maximum frequency with which AWS Config runs evaluations for a rule.
     * <p>
     * You can specify a value for <code>MaximumExecutionFrequency</code> when:
     * <p>
     * <ul>
     * <li>You are using an AWS managed rule that is triggered at a periodic frequency.</li>
     * <li>Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html">ConfigSnapshotDeliveryProperties</a> .</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaximumExecutionFrequency(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "maximumExecutionFrequency", value);
    }

    /**
     * Defines which resources can trigger an evaluation for the rule.
     * <p>
     * The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
     * <p>
     * <blockquote>
     * <p>
     * The scope can be empty.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScope() {
        return software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Defines which resources can trigger an evaluation for the rule.
     * <p>
     * The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
     * <p>
     * <blockquote>
     * <p>
     * The scope can be empty.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScope(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnConfigRule.ScopeProperty value) {
        software.amazon.jsii.Kernel.set(this, "scope", value);
    }

    /**
     * Defines which resources can trigger an evaluation for the rule.
     * <p>
     * The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
     * <p>
     * <blockquote>
     * <p>
     * The scope can be empty.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScope(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scope", value);
    }
    /**
     * Provides the runtime system, policy definition, and whether debug logging enabled.
     * <p>
     * You can specify the following CustomPolicyDetails parameter values only for AWS Config Custom Policy rules.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * CustomPolicyDetailsProperty customPolicyDetailsProperty = CustomPolicyDetailsProperty.builder()
     *         .enableDebugLogDelivery(false)
     *         .policyRuntime("policyRuntime")
     *         .policyText("policyText")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_config.CfnConfigRule.CustomPolicyDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomPolicyDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomPolicyDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The boolean expression for enabling debug logging for your AWS Config Custom Policy rule.
         * <p>
         * The default value is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableDebugLogDelivery() {
            return null;
        }

        /**
         * The runtime system for your AWS Config Custom Policy rule.
         * <p>
         * Guard is a policy-as-code language that allows you to write policies that are enforced by AWS Config Custom Policy rules. For more information about Guard, see the <a href="https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPolicyRuntime() {
            return null;
        }

        /**
         * The policy definition containing the logic for your AWS Config Custom Policy rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPolicyText() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomPolicyDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomPolicyDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomPolicyDetailsProperty> {
            java.lang.Object enableDebugLogDelivery;
            java.lang.String policyRuntime;
            java.lang.String policyText;

            /**
             * Sets the value of {@link CustomPolicyDetailsProperty#getEnableDebugLogDelivery}
             * @param enableDebugLogDelivery The boolean expression for enabling debug logging for your AWS Config Custom Policy rule.
             *                               The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableDebugLogDelivery(java.lang.Boolean enableDebugLogDelivery) {
                this.enableDebugLogDelivery = enableDebugLogDelivery;
                return this;
            }

            /**
             * Sets the value of {@link CustomPolicyDetailsProperty#getEnableDebugLogDelivery}
             * @param enableDebugLogDelivery The boolean expression for enabling debug logging for your AWS Config Custom Policy rule.
             *                               The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableDebugLogDelivery(software.amazon.awscdk.core.IResolvable enableDebugLogDelivery) {
                this.enableDebugLogDelivery = enableDebugLogDelivery;
                return this;
            }

            /**
             * Sets the value of {@link CustomPolicyDetailsProperty#getPolicyRuntime}
             * @param policyRuntime The runtime system for your AWS Config Custom Policy rule.
             *                      Guard is a policy-as-code language that allows you to write policies that are enforced by AWS Config Custom Policy rules. For more information about Guard, see the <a href="https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyRuntime(java.lang.String policyRuntime) {
                this.policyRuntime = policyRuntime;
                return this;
            }

            /**
             * Sets the value of {@link CustomPolicyDetailsProperty#getPolicyText}
             * @param policyText The policy definition containing the logic for your AWS Config Custom Policy rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyText(java.lang.String policyText) {
                this.policyText = policyText;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomPolicyDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomPolicyDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomPolicyDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomPolicyDetailsProperty {
            private final java.lang.Object enableDebugLogDelivery;
            private final java.lang.String policyRuntime;
            private final java.lang.String policyText;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableDebugLogDelivery = software.amazon.jsii.Kernel.get(this, "enableDebugLogDelivery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.policyRuntime = software.amazon.jsii.Kernel.get(this, "policyRuntime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.policyText = software.amazon.jsii.Kernel.get(this, "policyText", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableDebugLogDelivery = builder.enableDebugLogDelivery;
                this.policyRuntime = builder.policyRuntime;
                this.policyText = builder.policyText;
            }

            @Override
            public final java.lang.Object getEnableDebugLogDelivery() {
                return this.enableDebugLogDelivery;
            }

            @Override
            public final java.lang.String getPolicyRuntime() {
                return this.policyRuntime;
            }

            @Override
            public final java.lang.String getPolicyText() {
                return this.policyText;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableDebugLogDelivery() != null) {
                    data.set("enableDebugLogDelivery", om.valueToTree(this.getEnableDebugLogDelivery()));
                }
                if (this.getPolicyRuntime() != null) {
                    data.set("policyRuntime", om.valueToTree(this.getPolicyRuntime()));
                }
                if (this.getPolicyText() != null) {
                    data.set("policyText", om.valueToTree(this.getPolicyText()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_config.CfnConfigRule.CustomPolicyDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomPolicyDetailsProperty.Jsii$Proxy that = (CustomPolicyDetailsProperty.Jsii$Proxy) o;

                if (this.enableDebugLogDelivery != null ? !this.enableDebugLogDelivery.equals(that.enableDebugLogDelivery) : that.enableDebugLogDelivery != null) return false;
                if (this.policyRuntime != null ? !this.policyRuntime.equals(that.policyRuntime) : that.policyRuntime != null) return false;
                return this.policyText != null ? this.policyText.equals(that.policyText) : that.policyText == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableDebugLogDelivery != null ? this.enableDebugLogDelivery.hashCode() : 0;
                result = 31 * result + (this.policyRuntime != null ? this.policyRuntime.hashCode() : 0);
                result = 31 * result + (this.policyText != null ? this.policyText.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines which resources trigger an evaluation for an AWS Config rule.
     * <p>
     * The scope can include one or more resource types, a combination of a tag key and value, or a combination of one resource type and one resource ID. Specify a scope to constrain which resources trigger an evaluation for a rule. Otherwise, evaluations for the rule are triggered when any resource in your recording group changes in configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * ScopeProperty scopeProperty = ScopeProperty.builder()
     *         .complianceResourceId("complianceResourceId")
     *         .complianceResourceTypes(List.of("complianceResourceTypes"))
     *         .tagKey("tagKey")
     *         .tagValue("tagValue")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_config.CfnConfigRule.ScopeProperty")
    @software.amazon.jsii.Jsii.Proxy(ScopeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScopeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the only AWS resource that you want to trigger an evaluation for the rule.
         * <p>
         * If you specify a resource ID, you must specify one resource type for <code>ComplianceResourceTypes</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComplianceResourceId() {
            return null;
        }

        /**
         * The resource types of only those AWS resources that you want to trigger an evaluation for the rule.
         * <p>
         * You can only specify one type if you also specify a resource ID for <code>ComplianceResourceId</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getComplianceResourceTypes() {
            return null;
        }

        /**
         * The tag key that is applied to only those AWS resources that you want to trigger an evaluation for the rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagKey() {
            return null;
        }

        /**
         * The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule.
         * <p>
         * If you specify a value for <code>TagValue</code> , you must also specify a value for <code>TagKey</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScopeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScopeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScopeProperty> {
            java.lang.String complianceResourceId;
            java.util.List<java.lang.String> complianceResourceTypes;
            java.lang.String tagKey;
            java.lang.String tagValue;

            /**
             * Sets the value of {@link ScopeProperty#getComplianceResourceId}
             * @param complianceResourceId The ID of the only AWS resource that you want to trigger an evaluation for the rule.
             *                             If you specify a resource ID, you must specify one resource type for <code>ComplianceResourceTypes</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceResourceId(java.lang.String complianceResourceId) {
                this.complianceResourceId = complianceResourceId;
                return this;
            }

            /**
             * Sets the value of {@link ScopeProperty#getComplianceResourceTypes}
             * @param complianceResourceTypes The resource types of only those AWS resources that you want to trigger an evaluation for the rule.
             *                                You can only specify one type if you also specify a resource ID for <code>ComplianceResourceId</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceResourceTypes(java.util.List<java.lang.String> complianceResourceTypes) {
                this.complianceResourceTypes = complianceResourceTypes;
                return this;
            }

            /**
             * Sets the value of {@link ScopeProperty#getTagKey}
             * @param tagKey The tag key that is applied to only those AWS resources that you want to trigger an evaluation for the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagKey(java.lang.String tagKey) {
                this.tagKey = tagKey;
                return this;
            }

            /**
             * Sets the value of {@link ScopeProperty#getTagValue}
             * @param tagValue The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule.
             *                 If you specify a value for <code>TagValue</code> , you must also specify a value for <code>TagKey</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagValue(java.lang.String tagValue) {
                this.tagValue = tagValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScopeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScopeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScopeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScopeProperty {
            private final java.lang.String complianceResourceId;
            private final java.util.List<java.lang.String> complianceResourceTypes;
            private final java.lang.String tagKey;
            private final java.lang.String tagValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.complianceResourceId = software.amazon.jsii.Kernel.get(this, "complianceResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.complianceResourceTypes = software.amazon.jsii.Kernel.get(this, "complianceResourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tagKey = software.amazon.jsii.Kernel.get(this, "tagKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagValue = software.amazon.jsii.Kernel.get(this, "tagValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.complianceResourceId = builder.complianceResourceId;
                this.complianceResourceTypes = builder.complianceResourceTypes;
                this.tagKey = builder.tagKey;
                this.tagValue = builder.tagValue;
            }

            @Override
            public final java.lang.String getComplianceResourceId() {
                return this.complianceResourceId;
            }

            @Override
            public final java.util.List<java.lang.String> getComplianceResourceTypes() {
                return this.complianceResourceTypes;
            }

            @Override
            public final java.lang.String getTagKey() {
                return this.tagKey;
            }

            @Override
            public final java.lang.String getTagValue() {
                return this.tagValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComplianceResourceId() != null) {
                    data.set("complianceResourceId", om.valueToTree(this.getComplianceResourceId()));
                }
                if (this.getComplianceResourceTypes() != null) {
                    data.set("complianceResourceTypes", om.valueToTree(this.getComplianceResourceTypes()));
                }
                if (this.getTagKey() != null) {
                    data.set("tagKey", om.valueToTree(this.getTagKey()));
                }
                if (this.getTagValue() != null) {
                    data.set("tagValue", om.valueToTree(this.getTagValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_config.CfnConfigRule.ScopeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScopeProperty.Jsii$Proxy that = (ScopeProperty.Jsii$Proxy) o;

                if (this.complianceResourceId != null ? !this.complianceResourceId.equals(that.complianceResourceId) : that.complianceResourceId != null) return false;
                if (this.complianceResourceTypes != null ? !this.complianceResourceTypes.equals(that.complianceResourceTypes) : that.complianceResourceTypes != null) return false;
                if (this.tagKey != null ? !this.tagKey.equals(that.tagKey) : that.tagKey != null) return false;
                return this.tagValue != null ? this.tagValue.equals(that.tagValue) : that.tagValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.complianceResourceId != null ? this.complianceResourceId.hashCode() : 0;
                result = 31 * result + (this.complianceResourceTypes != null ? this.complianceResourceTypes.hashCode() : 0);
                result = 31 * result + (this.tagKey != null ? this.tagKey.hashCode() : 0);
                result = 31 * result + (this.tagValue != null ? this.tagValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the source and the message types that trigger AWS Config to evaluate your AWS resources against a rule.
     * <p>
     * It also provides the frequency with which you want AWS Config to run evaluations for the rule if the trigger type is periodic. You can specify the parameter values for <code>SourceDetail</code> only for custom rules.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * SourceDetailProperty sourceDetailProperty = SourceDetailProperty.builder()
     *         .eventSource("eventSource")
     *         .messageType("messageType")
     *         // the properties below are optional
     *         .maximumExecutionFrequency("maximumExecutionFrequency")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_config.CfnConfigRule.SourceDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWS resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventSource();

        /**
         * The type of notification that triggers AWS Config to run an evaluation for a rule.
         * <p>
         * You can specify the following notification types:
         * <p>
         * <ul>
         * <li><code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.</li>
         * <li><code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</li>
         * <li><code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code> .</li>
         * <li><code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when AWS Config delivers a configuration snapshot.</li>
         * </ul>
         * <p>
         * If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for <code>ConfigurationItemChangeNotification</code> and one for <code>OversizedConfigurationItemChangeNotification</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMessageType();

        /**
         * The frequency at which you want AWS Config to run evaluations for a custom rule with a periodic trigger.
         * <p>
         * If you specify a value for <code>MaximumExecutionFrequency</code> , then <code>MessageType</code> must use the <code>ScheduledNotification</code> value.
         * <p>
         * <blockquote>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * <p>
         * Based on the valid value you choose, AWS Config runs evaluations once for each valid value. For example, if you choose <code>Three_Hours</code> , AWS Config runs evaluations once every three hours. In this case, <code>Three_Hours</code> is the frequency of this rule.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaximumExecutionFrequency() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceDetailProperty> {
            java.lang.String eventSource;
            java.lang.String messageType;
            java.lang.String maximumExecutionFrequency;

            /**
             * Sets the value of {@link SourceDetailProperty#getEventSource}
             * @param eventSource The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWS resources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventSource(java.lang.String eventSource) {
                this.eventSource = eventSource;
                return this;
            }

            /**
             * Sets the value of {@link SourceDetailProperty#getMessageType}
             * @param messageType The type of notification that triggers AWS Config to run an evaluation for a rule. This parameter is required.
             *                    You can specify the following notification types:
             *                    <p>
             *                    <ul>
             *                    <li><code>ConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.</li>
             *                    <li><code>OversizedConfigurationItemChangeNotification</code> - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.</li>
             *                    <li><code>ScheduledNotification</code> - Triggers a periodic evaluation at the frequency specified for <code>MaximumExecutionFrequency</code> .</li>
             *                    <li><code>ConfigurationSnapshotDeliveryCompleted</code> - Triggers a periodic evaluation when AWS Config delivers a configuration snapshot.</li>
             *                    </ul>
             *                    <p>
             *                    If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for <code>ConfigurationItemChangeNotification</code> and one for <code>OversizedConfigurationItemChangeNotification</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageType(java.lang.String messageType) {
                this.messageType = messageType;
                return this;
            }

            /**
             * Sets the value of {@link SourceDetailProperty#getMaximumExecutionFrequency}
             * @param maximumExecutionFrequency The frequency at which you want AWS Config to run evaluations for a custom rule with a periodic trigger.
             *                                  If you specify a value for <code>MaximumExecutionFrequency</code> , then <code>MessageType</code> must use the <code>ScheduledNotification</code> value.
             *                                  <p>
             *                                  <blockquote>
             *                                  <p>
             *                                  By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
             *                                  <p>
             *                                  Based on the valid value you choose, AWS Config runs evaluations once for each valid value. For example, if you choose <code>Three_Hours</code> , AWS Config runs evaluations once every three hours. In this case, <code>Three_Hours</code> is the frequency of this rule.
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumExecutionFrequency(java.lang.String maximumExecutionFrequency) {
                this.maximumExecutionFrequency = maximumExecutionFrequency;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceDetailProperty {
            private final java.lang.String eventSource;
            private final java.lang.String messageType;
            private final java.lang.String maximumExecutionFrequency;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventSource = software.amazon.jsii.Kernel.get(this, "eventSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.messageType = software.amazon.jsii.Kernel.get(this, "messageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maximumExecutionFrequency = software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventSource = java.util.Objects.requireNonNull(builder.eventSource, "eventSource is required");
                this.messageType = java.util.Objects.requireNonNull(builder.messageType, "messageType is required");
                this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
            }

            @Override
            public final java.lang.String getEventSource() {
                return this.eventSource;
            }

            @Override
            public final java.lang.String getMessageType() {
                return this.messageType;
            }

            @Override
            public final java.lang.String getMaximumExecutionFrequency() {
                return this.maximumExecutionFrequency;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventSource", om.valueToTree(this.getEventSource()));
                data.set("messageType", om.valueToTree(this.getMessageType()));
                if (this.getMaximumExecutionFrequency() != null) {
                    data.set("maximumExecutionFrequency", om.valueToTree(this.getMaximumExecutionFrequency()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_config.CfnConfigRule.SourceDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceDetailProperty.Jsii$Proxy that = (SourceDetailProperty.Jsii$Proxy) o;

                if (!eventSource.equals(that.eventSource)) return false;
                if (!messageType.equals(that.messageType)) return false;
                return this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.equals(that.maximumExecutionFrequency) : that.maximumExecutionFrequency == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventSource.hashCode();
                result = 31 * result + (this.messageType.hashCode());
                result = 31 * result + (this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the CustomPolicyDetails, the rule owner ( `AWS` for managed rules, `CUSTOM_POLICY` for Custom Policy rules, and `CUSTOM_LAMBDA` for Custom Lambda rules), the rule identifier, and the events that cause the evaluation of your AWS resources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * SourceProperty sourceProperty = SourceProperty.builder()
     *         .owner("owner")
     *         // the properties below are optional
     *         .customPolicyDetails(CustomPolicyDetailsProperty.builder()
     *                 .enableDebugLogDelivery(false)
     *                 .policyRuntime("policyRuntime")
     *                 .policyText("policyText")
     *                 .build())
     *         .sourceDetails(List.of(SourceDetailProperty.builder()
     *                 .eventSource("eventSource")
     *                 .messageType("messageType")
     *                 // the properties below are optional
     *                 .maximumExecutionFrequency("maximumExecutionFrequency")
     *                 .build()))
     *         .sourceIdentifier("sourceIdentifier")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_config.CfnConfigRule.SourceProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether AWS or the customer owns and manages the AWS Config rule.
         * <p>
         * AWS Config Managed Rules are predefined rules owned by AWS . For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">AWS Config Managed Rules</a> in the <em>AWS Config developer guide</em> .
         * <p>
         * AWS Config Custom Rules are rules that you can develop either with Guard ( <code>CUSTOM_POLICY</code> ) or AWS Lambda ( <code>CUSTOM_LAMBDA</code> ). For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">AWS Config Custom Rules</a> in the <em>AWS Config developer guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOwner();

        /**
         * Provides the runtime system, policy definition, and whether debug logging is enabled.
         * <p>
         * Required when owner is set to <code>CUSTOM_POLICY</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomPolicyDetails() {
            return null;
        }

        /**
         * Provides the source and the message types that cause AWS Config to evaluate your AWS resources against a rule.
         * <p>
         * It also provides the frequency with which you want AWS Config to run evaluations for the rule if the trigger type is periodic.
         * <p>
         * If the owner is set to <code>CUSTOM_POLICY</code> , the only acceptable values for the AWS Config rule trigger message type are <code>ConfigurationItemChangeNotification</code> and <code>OversizedConfigurationItemChangeNotification</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceDetails() {
            return null;
        }

        /**
         * For AWS Config Managed rules, a predefined identifier from a list.
         * <p>
         * For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of AWS Config Managed Rules</a> .
         * <p>
         * For AWS Config Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's AWS Lambda function, such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code> .
         * <p>
         * For AWS Config Custom Policy rules, this field will be ignored.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceProperty> {
            java.lang.String owner;
            java.lang.Object customPolicyDetails;
            java.lang.Object sourceDetails;
            java.lang.String sourceIdentifier;

            /**
             * Sets the value of {@link SourceProperty#getOwner}
             * @param owner Indicates whether AWS or the customer owns and manages the AWS Config rule. This parameter is required.
             *              AWS Config Managed Rules are predefined rules owned by AWS . For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">AWS Config Managed Rules</a> in the <em>AWS Config developer guide</em> .
             *              <p>
             *              AWS Config Custom Rules are rules that you can develop either with Guard ( <code>CUSTOM_POLICY</code> ) or AWS Lambda ( <code>CUSTOM_LAMBDA</code> ). For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">AWS Config Custom Rules</a> in the <em>AWS Config developer guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder owner(java.lang.String owner) {
                this.owner = owner;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getCustomPolicyDetails}
             * @param customPolicyDetails Provides the runtime system, policy definition, and whether debug logging is enabled.
             *                            Required when owner is set to <code>CUSTOM_POLICY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPolicyDetails(software.amazon.awscdk.services.config.CfnConfigRule.CustomPolicyDetailsProperty customPolicyDetails) {
                this.customPolicyDetails = customPolicyDetails;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getCustomPolicyDetails}
             * @param customPolicyDetails Provides the runtime system, policy definition, and whether debug logging is enabled.
             *                            Required when owner is set to <code>CUSTOM_POLICY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPolicyDetails(software.amazon.awscdk.core.IResolvable customPolicyDetails) {
                this.customPolicyDetails = customPolicyDetails;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceDetails}
             * @param sourceDetails Provides the source and the message types that cause AWS Config to evaluate your AWS resources against a rule.
             *                      It also provides the frequency with which you want AWS Config to run evaluations for the rule if the trigger type is periodic.
             *                      <p>
             *                      If the owner is set to <code>CUSTOM_POLICY</code> , the only acceptable values for the AWS Config rule trigger message type are <code>ConfigurationItemChangeNotification</code> and <code>OversizedConfigurationItemChangeNotification</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceDetails(software.amazon.awscdk.core.IResolvable sourceDetails) {
                this.sourceDetails = sourceDetails;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceDetails}
             * @param sourceDetails Provides the source and the message types that cause AWS Config to evaluate your AWS resources against a rule.
             *                      It also provides the frequency with which you want AWS Config to run evaluations for the rule if the trigger type is periodic.
             *                      <p>
             *                      If the owner is set to <code>CUSTOM_POLICY</code> , the only acceptable values for the AWS Config rule trigger message type are <code>ConfigurationItemChangeNotification</code> and <code>OversizedConfigurationItemChangeNotification</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceDetails(java.util.List<? extends java.lang.Object> sourceDetails) {
                this.sourceDetails = sourceDetails;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceIdentifier}
             * @param sourceIdentifier For AWS Config Managed rules, a predefined identifier from a list.
             *                         For example, <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of AWS Config Managed Rules</a> .
             *                         <p>
             *                         For AWS Config Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's AWS Lambda function, such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code> .
             *                         <p>
             *                         For AWS Config Custom Policy rules, this field will be ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceIdentifier(java.lang.String sourceIdentifier) {
                this.sourceIdentifier = sourceIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceProperty {
            private final java.lang.String owner;
            private final java.lang.Object customPolicyDetails;
            private final java.lang.Object sourceDetails;
            private final java.lang.String sourceIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customPolicyDetails = software.amazon.jsii.Kernel.get(this, "customPolicyDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceDetails = software.amazon.jsii.Kernel.get(this, "sourceDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceIdentifier = software.amazon.jsii.Kernel.get(this, "sourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.owner = java.util.Objects.requireNonNull(builder.owner, "owner is required");
                this.customPolicyDetails = builder.customPolicyDetails;
                this.sourceDetails = builder.sourceDetails;
                this.sourceIdentifier = builder.sourceIdentifier;
            }

            @Override
            public final java.lang.String getOwner() {
                return this.owner;
            }

            @Override
            public final java.lang.Object getCustomPolicyDetails() {
                return this.customPolicyDetails;
            }

            @Override
            public final java.lang.Object getSourceDetails() {
                return this.sourceDetails;
            }

            @Override
            public final java.lang.String getSourceIdentifier() {
                return this.sourceIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("owner", om.valueToTree(this.getOwner()));
                if (this.getCustomPolicyDetails() != null) {
                    data.set("customPolicyDetails", om.valueToTree(this.getCustomPolicyDetails()));
                }
                if (this.getSourceDetails() != null) {
                    data.set("sourceDetails", om.valueToTree(this.getSourceDetails()));
                }
                if (this.getSourceIdentifier() != null) {
                    data.set("sourceIdentifier", om.valueToTree(this.getSourceIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_config.CfnConfigRule.SourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceProperty.Jsii$Proxy that = (SourceProperty.Jsii$Proxy) o;

                if (!owner.equals(that.owner)) return false;
                if (this.customPolicyDetails != null ? !this.customPolicyDetails.equals(that.customPolicyDetails) : that.customPolicyDetails != null) return false;
                if (this.sourceDetails != null ? !this.sourceDetails.equals(that.sourceDetails) : that.sourceDetails != null) return false;
                return this.sourceIdentifier != null ? this.sourceIdentifier.equals(that.sourceIdentifier) : that.sourceIdentifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.owner.hashCode();
                result = 31 * result + (this.customPolicyDetails != null ? this.customPolicyDetails.hashCode() : 0);
                result = 31 * result + (this.sourceDetails != null ? this.sourceDetails.hashCode() : 0);
                result = 31 * result + (this.sourceIdentifier != null ? this.sourceIdentifier.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.config.CfnConfigRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.config.CfnConfigRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.config.CfnConfigRuleProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.config.CfnConfigRuleProps.Builder();
        }

        /**
         * Provides the rule owner ( `AWS` for managed rules, `CUSTOM_POLICY` for Custom Policy rules, and `CUSTOM_LAMBDA` for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
         * <p>
         * @return {@code this}
         * @param source Provides the rule owner ( `AWS` for managed rules, `CUSTOM_POLICY` for Custom Policy rules, and `CUSTOM_LAMBDA` for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.services.config.CfnConfigRule.SourceProperty source) {
            this.props.source(source);
            return this;
        }
        /**
         * Provides the rule owner ( `AWS` for managed rules, `CUSTOM_POLICY` for Custom Policy rules, and `CUSTOM_LAMBDA` for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
         * <p>
         * @return {@code this}
         * @param source Provides the rule owner ( `AWS` for managed rules, `CUSTOM_POLICY` for Custom Policy rules, and `CUSTOM_LAMBDA` for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.core.IResolvable source) {
            this.props.source(source);
            return this;
        }

        /**
         * A name for the AWS Config rule.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the rule name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * @return {@code this}
         * @param configRuleName A name for the AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configRuleName(final java.lang.String configRuleName) {
            this.props.configRuleName(configRuleName);
            return this;
        }

        /**
         * The description that you provide for the AWS Config rule.
         * <p>
         * @return {@code this}
         * @param description The description that you provide for the AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * A string, in JSON format, that is passed to the AWS Config rule Lambda function.
         * <p>
         * @return {@code this}
         * @param inputParameters A string, in JSON format, that is passed to the AWS Config rule Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputParameters(final java.lang.Object inputParameters) {
            this.props.inputParameters(inputParameters);
            return this;
        }

        /**
         * The maximum frequency with which AWS Config runs evaluations for a rule.
         * <p>
         * You can specify a value for <code>MaximumExecutionFrequency</code> when:
         * <p>
         * <ul>
         * <li>You are using an AWS managed rule that is triggered at a periodic frequency.</li>
         * <li>Your custom rule is triggered when AWS Config delivers the configuration snapshot. For more information, see <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html">ConfigSnapshotDeliveryProperties</a> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the <code>MaximumExecutionFrequency</code> parameter.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param maximumExecutionFrequency The maximum frequency with which AWS Config runs evaluations for a rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumExecutionFrequency(final java.lang.String maximumExecutionFrequency) {
            this.props.maximumExecutionFrequency(maximumExecutionFrequency);
            return this;
        }

        /**
         * Defines which resources can trigger an evaluation for the rule.
         * <p>
         * The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
         * <p>
         * <blockquote>
         * <p>
         * The scope can be empty.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param scope Defines which resources can trigger an evaluation for the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(final software.amazon.awscdk.services.config.CfnConfigRule.ScopeProperty scope) {
            this.props.scope(scope);
            return this;
        }
        /**
         * Defines which resources can trigger an evaluation for the rule.
         * <p>
         * The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
         * <p>
         * <blockquote>
         * <p>
         * The scope can be empty.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param scope Defines which resources can trigger an evaluation for the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(final software.amazon.awscdk.core.IResolvable scope) {
            this.props.scope(scope);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.config.CfnConfigRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.config.CfnConfigRule build() {
            return new software.amazon.awscdk.services.config.CfnConfigRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
