package software.amazon.awscdk.services.cognito.identitypool;

/**
 * (experimental) Defines a User Pool Authentication Provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IdentityPool identityPool;
 * UserPool userPool = new UserPool(this, "Pool");
 * identityPool.addUserPoolAuthentication(UserPoolAuthenticationProvider.Builder.create()
 *         .userPool(userPool)
 *         .disableServerSideTokenCheck(true)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:57.170Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito_identitypool.UserPoolAuthenticationProvider")
public class UserPoolAuthenticationProvider extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cognito.identitypool.IUserPoolAuthenticationProvider {

    protected UserPoolAuthenticationProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolAuthenticationProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public UserPoolAuthenticationProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.UserPoolAuthenticationProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The method called when a given User Pool Authentication Provider is added (for the first time) to an Identity Pool.
     * <p>
     * @param scope This parameter is required.
     * @param identityPool This parameter is required.
     * @param _options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.UserPoolAuthenticationProviderBindConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IIdentityPool identityPool, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.identitypool.UserPoolAuthenticationProviderBindOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.UserPoolAuthenticationProviderBindConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(identityPool, "identityPool is required"), _options });
    }

    /**
     * (experimental) The method called when a given User Pool Authentication Provider is added (for the first time) to an Identity Pool.
     * <p>
     * @param scope This parameter is required.
     * @param identityPool This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.UserPoolAuthenticationProviderBindConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IIdentityPool identityPool) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.UserPoolAuthenticationProviderBindConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(identityPool, "identityPool is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.cognito.identitypool.UserPoolAuthenticationProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.identitypool.UserPoolAuthenticationProvider> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cognito.identitypool.UserPoolAuthenticationProviderProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.cognito.identitypool.UserPoolAuthenticationProviderProps.Builder();
        }

        /**
         * (experimental) The User Pool of the Associated Identity Providers.
         * <p>
         * @return {@code this}
         * @param userPool The User Pool of the Associated Identity Providers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPool(final software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.props.userPool(userPool);
            return this;
        }

        /**
         * (experimental) Setting this to true turns off identity pool checks for this user pool to make sure the user has not been globally signed out or deleted before the identity pool provides an OIDC token or AWS credentials for the user.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html</a>
         * @param disableServerSideTokenCheck Setting this to true turns off identity pool checks for this user pool to make sure the user has not been globally signed out or deleted before the identity pool provides an OIDC token or AWS credentials for the user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder disableServerSideTokenCheck(final java.lang.Boolean disableServerSideTokenCheck) {
            this.props.disableServerSideTokenCheck(disableServerSideTokenCheck);
            return this;
        }

        /**
         * (experimental) The User Pool Client for the provided User Pool.
         * <p>
         * Default: - A default user pool client will be added to User Pool
         * <p>
         * @return {@code this}
         * @param userPoolClient The User Pool Client for the provided User Pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPoolClient(final software.amazon.awscdk.services.cognito.IUserPoolClient userPoolClient) {
            this.props.userPoolClient(userPoolClient);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.identitypool.UserPoolAuthenticationProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cognito.identitypool.UserPoolAuthenticationProvider build() {
            return new software.amazon.awscdk.services.cognito.identitypool.UserPoolAuthenticationProvider(
                this.props.build()
            );
        }
    }
}
