package software.amazon.awscdk.services.cognito.identitypool;

/**
 * (experimental) Keys for Login Providers - correspond to client id's of respective federation identity providers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl;
 * IdentityPool.Builder.create(this, "myidentitypool")
 *         .identityPoolName("myidentitypool")
 *         .roleMappings(List.of(IdentityPoolRoleMapping.builder()
 *                 .providerUrl(IdentityPoolProviderUrl.userPool("cognito-idp.my-idp-region.amazonaws.com/my-idp-region_abcdefghi:app_client_id"))
 *                 .useToken(true)
 *                 .build(), IdentityPoolRoleMapping.builder()
 *                 .providerUrl(IdentityPoolProviderUrl.custom("my-custom-provider.com"))
 *                 .useToken(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:57.159Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito_identitypool.IdentityPoolProviderUrl")
public class IdentityPoolProviderUrl extends software.amazon.jsii.JsiiObject {

    protected IdentityPoolProviderUrl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IdentityPoolProviderUrl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AMAZON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "AMAZON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class));
        APPLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "APPLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class));
        DIGITS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "DIGITS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class));
        FACEBOOK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "FACEBOOK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class));
        GOOGLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "GOOGLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class));
        TWITTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "TWITTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class));
    }

    /**
     * @param type type of Provider Url. This parameter is required.
     * @param value value of Provider Url. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public IdentityPoolProviderUrl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderType type, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(type, "type is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Custom Provider Url.
     * <p>
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl custom(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * (experimental) OpenId Provider Url.
     * <p>
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl openId(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "openId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * (experimental) Saml Provider Url.
     * <p>
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl saml(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "saml", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * (experimental) User Pool Provider Url.
     * <p>
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl userPool(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "userPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * (experimental) Amazon Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl AMAZON;

    /**
     * (experimental) Apple Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl APPLE;

    /**
     * (experimental) Digits Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl DIGITS;

    /**
     * (experimental) Facebook Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl FACEBOOK;

    /**
     * (experimental) Google Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl GOOGLE;

    /**
     * (experimental) Twitter Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl TWITTER;

    /**
     * (experimental) type of Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderType.class));
    }

    /**
     * (experimental) value of Provider Url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
