/**
 * <h1>AWS::CodeStar Construct Library</h1>
 * <p>
 * <h2>GitHub Repository</h2>
 * <p>
 * To create a new GitHub Repository and commit the assets from S3 bucket into the repository after it is created:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * 
 * 
 * GitHubRepository.Builder.create(this, "GitHubRepo")
 *         .owner("aws")
 *         .repositoryName("aws-cdk")
 *         .accessToken(SecretValue.secretsManager("my-github-token", SecretsManagerSecretOptions.builder()
 *                 .jsonField("token")
 *                 .build()))
 *         .contentsBucket(Bucket.fromBucketName(this, "Bucket", "bucket-name"))
 *         .contentsKey("import.zip")
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Update or Delete the GitHubRepository</h2>
 * <p>
 * At this moment, updates to the <code>GitHubRepository</code> are not supported and the repository will not be deleted upon the deletion of the CloudFormation stack. You will need to update or delete the GitHub repository manually.
 */
package software.amazon.awscdk.services.codestar;
