package software.amazon.awscdk.services.codestar;

/**
 * (experimental) Construction properties of {@link GitHubRepository}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * GitHubRepository.Builder.create(this, "GitHubRepo")
 *         .owner("aws")
 *         .repositoryName("aws-cdk")
 *         .accessToken(SecretValue.secretsManager("my-github-token", SecretsManagerSecretOptions.builder()
 *                 .jsonField("token")
 *                 .build()))
 *         .contentsBucket(Bucket.fromBucketName(this, "Bucket", "bucket-name"))
 *         .contentsKey("import.zip")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:56.775Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codestar.GitHubRepositoryProps")
@software.amazon.jsii.Jsii.Proxy(GitHubRepositoryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GitHubRepositoryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The GitHub user's personal access token for the GitHub repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.SecretValue getAccessToken();

    /**
     * (experimental) The name of the Amazon S3 bucket that contains the ZIP file with the content to be committed to the new repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getContentsBucket();

    /**
     * (experimental) The S3 object key or file name for the ZIP file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getContentsKey();

    /**
     * (experimental) The GitHub user name for the owner of the GitHub repository to be created.
     * <p>
     * If this
     * repository should be owned by a GitHub organization, provide its name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getOwner();

    /**
     * (experimental) The name of the repository you want to create in GitHub with AWS CloudFormation stack creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName();

    /**
     * (experimental) The object version of the ZIP file, if versioning is enabled for the Amazon S3 bucket.
     * <p>
     * Default: - not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentsS3Version() {
        return null;
    }

    /**
     * (experimental) A comment or description about the new repository.
     * <p>
     * This description is displayed in GitHub after the repository
     * is created.
     * <p>
     * Default: - no description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) Indicates whether to enable issues for the GitHub repository.
     * <p>
     * You can use GitHub issues to track information
     * and bugs for your repository.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableIssues() {
        return null;
    }

    /**
     * (experimental) Indicates whether the GitHub repository is a private repository.
     * <p>
     * If so, you choose who can see and commit to
     * this repository.
     * <p>
     * Default: RepositoryVisibility.PUBLIC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestar.RepositoryVisibility getVisibility() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GitHubRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GitHubRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<GitHubRepositoryProps> {
        software.amazon.awscdk.core.SecretValue accessToken;
        software.amazon.awscdk.services.s3.IBucket contentsBucket;
        java.lang.String contentsKey;
        java.lang.String owner;
        java.lang.String repositoryName;
        java.lang.String contentsS3Version;
        java.lang.String description;
        java.lang.Boolean enableIssues;
        software.amazon.awscdk.services.codestar.RepositoryVisibility visibility;

        /**
         * Sets the value of {@link GitHubRepositoryProps#getAccessToken}
         * @param accessToken The GitHub user's personal access token for the GitHub repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessToken(software.amazon.awscdk.core.SecretValue accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        /**
         * Sets the value of {@link GitHubRepositoryProps#getContentsBucket}
         * @param contentsBucket The name of the Amazon S3 bucket that contains the ZIP file with the content to be committed to the new repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentsBucket(software.amazon.awscdk.services.s3.IBucket contentsBucket) {
            this.contentsBucket = contentsBucket;
            return this;
        }

        /**
         * Sets the value of {@link GitHubRepositoryProps#getContentsKey}
         * @param contentsKey The S3 object key or file name for the ZIP file. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentsKey(java.lang.String contentsKey) {
            this.contentsKey = contentsKey;
            return this;
        }

        /**
         * Sets the value of {@link GitHubRepositoryProps#getOwner}
         * @param owner The GitHub user name for the owner of the GitHub repository to be created. This parameter is required.
         *              If this
         *              repository should be owned by a GitHub organization, provide its name
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder owner(java.lang.String owner) {
            this.owner = owner;
            return this;
        }

        /**
         * Sets the value of {@link GitHubRepositoryProps#getRepositoryName}
         * @param repositoryName The name of the repository you want to create in GitHub with AWS CloudFormation stack creation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link GitHubRepositoryProps#getContentsS3Version}
         * @param contentsS3Version The object version of the ZIP file, if versioning is enabled for the Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentsS3Version(java.lang.String contentsS3Version) {
            this.contentsS3Version = contentsS3Version;
            return this;
        }

        /**
         * Sets the value of {@link GitHubRepositoryProps#getDescription}
         * @param description A comment or description about the new repository.
         *                    This description is displayed in GitHub after the repository
         *                    is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link GitHubRepositoryProps#getEnableIssues}
         * @param enableIssues Indicates whether to enable issues for the GitHub repository.
         *                     You can use GitHub issues to track information
         *                     and bugs for your repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableIssues(java.lang.Boolean enableIssues) {
            this.enableIssues = enableIssues;
            return this;
        }

        /**
         * Sets the value of {@link GitHubRepositoryProps#getVisibility}
         * @param visibility Indicates whether the GitHub repository is a private repository.
         *                   If so, you choose who can see and commit to
         *                   this repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder visibility(software.amazon.awscdk.services.codestar.RepositoryVisibility visibility) {
            this.visibility = visibility;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GitHubRepositoryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public GitHubRepositoryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GitHubRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitHubRepositoryProps {
        private final software.amazon.awscdk.core.SecretValue accessToken;
        private final software.amazon.awscdk.services.s3.IBucket contentsBucket;
        private final java.lang.String contentsKey;
        private final java.lang.String owner;
        private final java.lang.String repositoryName;
        private final java.lang.String contentsS3Version;
        private final java.lang.String description;
        private final java.lang.Boolean enableIssues;
        private final software.amazon.awscdk.services.codestar.RepositoryVisibility visibility;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class));
            this.contentsBucket = software.amazon.jsii.Kernel.get(this, "contentsBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.contentsKey = software.amazon.jsii.Kernel.get(this, "contentsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentsS3Version = software.amazon.jsii.Kernel.get(this, "contentsS3Version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableIssues = software.amazon.jsii.Kernel.get(this, "enableIssues", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.visibility = software.amazon.jsii.Kernel.get(this, "visibility", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestar.RepositoryVisibility.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessToken = java.util.Objects.requireNonNull(builder.accessToken, "accessToken is required");
            this.contentsBucket = java.util.Objects.requireNonNull(builder.contentsBucket, "contentsBucket is required");
            this.contentsKey = java.util.Objects.requireNonNull(builder.contentsKey, "contentsKey is required");
            this.owner = java.util.Objects.requireNonNull(builder.owner, "owner is required");
            this.repositoryName = java.util.Objects.requireNonNull(builder.repositoryName, "repositoryName is required");
            this.contentsS3Version = builder.contentsS3Version;
            this.description = builder.description;
            this.enableIssues = builder.enableIssues;
            this.visibility = builder.visibility;
        }

        @Override
        public final software.amazon.awscdk.core.SecretValue getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getContentsBucket() {
            return this.contentsBucket;
        }

        @Override
        public final java.lang.String getContentsKey() {
            return this.contentsKey;
        }

        @Override
        public final java.lang.String getOwner() {
            return this.owner;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final java.lang.String getContentsS3Version() {
            return this.contentsS3Version;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Boolean getEnableIssues() {
            return this.enableIssues;
        }

        @Override
        public final software.amazon.awscdk.services.codestar.RepositoryVisibility getVisibility() {
            return this.visibility;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessToken", om.valueToTree(this.getAccessToken()));
            data.set("contentsBucket", om.valueToTree(this.getContentsBucket()));
            data.set("contentsKey", om.valueToTree(this.getContentsKey()));
            data.set("owner", om.valueToTree(this.getOwner()));
            data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            if (this.getContentsS3Version() != null) {
                data.set("contentsS3Version", om.valueToTree(this.getContentsS3Version()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnableIssues() != null) {
                data.set("enableIssues", om.valueToTree(this.getEnableIssues()));
            }
            if (this.getVisibility() != null) {
                data.set("visibility", om.valueToTree(this.getVisibility()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_codestar.GitHubRepositoryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GitHubRepositoryProps.Jsii$Proxy that = (GitHubRepositoryProps.Jsii$Proxy) o;

            if (!accessToken.equals(that.accessToken)) return false;
            if (!contentsBucket.equals(that.contentsBucket)) return false;
            if (!contentsKey.equals(that.contentsKey)) return false;
            if (!owner.equals(that.owner)) return false;
            if (!repositoryName.equals(that.repositoryName)) return false;
            if (this.contentsS3Version != null ? !this.contentsS3Version.equals(that.contentsS3Version) : that.contentsS3Version != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enableIssues != null ? !this.enableIssues.equals(that.enableIssues) : that.enableIssues != null) return false;
            return this.visibility != null ? this.visibility.equals(that.visibility) : that.visibility == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessToken.hashCode();
            result = 31 * result + (this.contentsBucket.hashCode());
            result = 31 * result + (this.contentsKey.hashCode());
            result = 31 * result + (this.owner.hashCode());
            result = 31 * result + (this.repositoryName.hashCode());
            result = 31 * result + (this.contentsS3Version != null ? this.contentsS3Version.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enableIssues != null ? this.enableIssues.hashCode() : 0);
            result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
            return result;
        }
    }
}
