package software.amazon.awscdk.services.codepipeline.actions;

/**
 * (experimental) A CodePipeline source action for the CodeStar Connections source, which allows connecting to GitHub and BitBucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Artifact sourceOutput = new Artifact();
 * CodeStarConnectionsSourceAction sourceAction = CodeStarConnectionsSourceAction.Builder.create()
 *         .actionName("BitBucket_Source")
 *         .owner("aws")
 *         .repo("aws-cdk")
 *         .output(sourceOutput)
 *         .connectionArn("arn:aws:codestar-connections:us-east-1:123456789012:connection/12345678-abcd-12ab-34cdef5678gh")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:56.672Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codepipeline_actions.CodeStarConnectionsSourceAction")
public class CodeStarConnectionsSourceAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected CodeStarConnectionsSourceAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodeStarConnectionsSourceAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CodeStarConnectionsSourceAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) This is a renamed version of the {@link IAction.bind} method.
     * <p>
     * @param _scope This parameter is required.
     * @param _stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage _stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_stage, "_stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) The variables emitted by this action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CodeStarSourceVariables getVariables() {
        return software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CodeStarSourceVariables.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceActionProps.Builder();
        }

        /**
         * (experimental) The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * (experimental) The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * (experimental) The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * (experimental) The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your {&#64;link IAction.bind}
         * method in the {&#64;link ActionBindOptions.role} property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (experimental) The ARN of the CodeStar Connection created in the AWS console that has permissions to access this GitHub or BitBucket repository.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * "arn:aws:codestar-connections:us-east-1:123456789012:connection/12345678-abcd-12ab-34cdef5678gh";
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/connections-create.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/connections-create.html</a>
         * @param connectionArn The ARN of the CodeStar Connection created in the AWS console that has permissions to access this GitHub or BitBucket repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionArn(final java.lang.String connectionArn) {
            this.props.connectionArn(connectionArn);
            return this;
        }

        /**
         * (experimental) The output artifact that this action produces.
         * <p>
         * Can be used as input for further pipeline actions.
         * <p>
         * @return {@code this}
         * @param output The output artifact that this action produces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder output(final software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.props.output(output);
            return this;
        }

        /**
         * (experimental) The owning user or organization of the repository.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * "aws";
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param owner The owning user or organization of the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder owner(final java.lang.String owner) {
            this.props.owner(owner);
            return this;
        }

        /**
         * (experimental) The name of the repository.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * "aws-cdk";
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param repo The name of the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repo(final java.lang.String repo) {
            this.props.repo(repo);
            return this;
        }

        /**
         * (experimental) The branch to build.
         * <p>
         * Default: 'master'
         * <p>
         * @return {@code this}
         * @param branch The branch to build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder branch(final java.lang.String branch) {
            this.props.branch(branch);
            return this;
        }

        /**
         * (experimental) Whether the output should be the contents of the repository (which is the default), or a link that allows CodeBuild to clone the repository before building.
         * <p>
         * <strong>Note</strong>: if this option is true,
         * then only CodeBuild actions can use the resulting {&#64;link output}.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config</a>
         * @param codeBuildCloneOutput Whether the output should be the contents of the repository (which is the default), or a link that allows CodeBuild to clone the repository before building. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeBuildCloneOutput(final java.lang.Boolean codeBuildCloneOutput) {
            this.props.codeBuildCloneOutput(codeBuildCloneOutput);
            return this;
        }

        /**
         * (experimental) Controls automatically starting your pipeline when a new commit is made on the configured repository and branch.
         * <p>
         * If unspecified,
         * the default value is true, and the field does not display by default.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html</a>
         * @param triggerOnPush Controls automatically starting your pipeline when a new commit is made on the configured repository and branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder triggerOnPush(final java.lang.Boolean triggerOnPush) {
            this.props.triggerOnPush(triggerOnPush);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.CodeStarConnectionsSourceAction(
                this.props.build()
            );
        }
    }
}
