package software.amazon.awscdk.services.codepipeline;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Pipeline pipeline = new Pipeline(this, "MyPipeline");
 * Artifact inputArtifact = new Artifact();
 * Pass startState = new Pass(this, "StartState");
 * StateMachine simpleStateMachine = StateMachine.Builder.create(this, "SimpleStateMachine")
 *         .definition(startState)
 *         .build();
 * StepFunctionInvokeAction stepFunctionAction = StepFunctionInvokeAction.Builder.create()
 *         .actionName("Invoke")
 *         .stateMachine(simpleStateMachine)
 *         .stateMachineInput(StateMachineInput.filePath(inputArtifact.atPath("assets/input.json")))
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("StepFunctions")
 *         .actions(List.of(stepFunctionAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:56.504Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codepipeline.StageOptions")
@software.amazon.jsii.Jsii.Proxy(StageOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface StageOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.StageProps {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.StagePlacement getPlacement() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<StageOptions> {
        software.amazon.awscdk.services.codepipeline.StagePlacement placement;
        java.lang.String stageName;
        java.util.List<software.amazon.awscdk.services.codepipeline.IAction> actions;
        java.lang.String transitionDisabledReason;
        java.lang.Boolean transitionToEnabled;

        /**
         * Sets the value of {@link StageOptions#getPlacement}
         * @param placement the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder placement(software.amazon.awscdk.services.codepipeline.StagePlacement placement) {
            this.placement = placement;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getStageName}
         * @param stageName The physical, human-readable name to assign to this Pipeline Stage. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getActions}
         * @param actions The list of Actions to create this Stage with.
         *                You can always add more Actions later by calling {&#64;link IStage#addAction}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder actions(java.util.List<? extends software.amazon.awscdk.services.codepipeline.IAction> actions) {
            this.actions = (java.util.List<software.amazon.awscdk.services.codepipeline.IAction>)actions;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getTransitionDisabledReason}
         * @param transitionDisabledReason The reason for disabling transition to this stage.
         *                                 Only applicable
         *                                 if <code>transitionToEnabled</code> is set to <code>false</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder transitionDisabledReason(java.lang.String transitionDisabledReason) {
            this.transitionDisabledReason = transitionDisabledReason;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getTransitionToEnabled}
         * @param transitionToEnabled Whether to enable transition to this stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder transitionToEnabled(java.lang.Boolean transitionToEnabled) {
            this.transitionToEnabled = transitionToEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StageOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public StageOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageOptions {
        private final software.amazon.awscdk.services.codepipeline.StagePlacement placement;
        private final java.lang.String stageName;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.IAction> actions;
        private final java.lang.String transitionDisabledReason;
        private final java.lang.Boolean transitionToEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.placement = software.amazon.jsii.Kernel.get(this, "placement", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.StagePlacement.class));
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IAction.class)));
            this.transitionDisabledReason = software.amazon.jsii.Kernel.get(this, "transitionDisabledReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitionToEnabled = software.amazon.jsii.Kernel.get(this, "transitionToEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.placement = builder.placement;
            this.stageName = java.util.Objects.requireNonNull(builder.stageName, "stageName is required");
            this.actions = (java.util.List<software.amazon.awscdk.services.codepipeline.IAction>)builder.actions;
            this.transitionDisabledReason = builder.transitionDisabledReason;
            this.transitionToEnabled = builder.transitionToEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.StagePlacement getPlacement() {
            return this.placement;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.IAction> getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.String getTransitionDisabledReason() {
            return this.transitionDisabledReason;
        }

        @Override
        public final java.lang.Boolean getTransitionToEnabled() {
            return this.transitionToEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPlacement() != null) {
                data.set("placement", om.valueToTree(this.getPlacement()));
            }
            data.set("stageName", om.valueToTree(this.getStageName()));
            if (this.getActions() != null) {
                data.set("actions", om.valueToTree(this.getActions()));
            }
            if (this.getTransitionDisabledReason() != null) {
                data.set("transitionDisabledReason", om.valueToTree(this.getTransitionDisabledReason()));
            }
            if (this.getTransitionToEnabled() != null) {
                data.set("transitionToEnabled", om.valueToTree(this.getTransitionToEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_codepipeline.StageOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StageOptions.Jsii$Proxy that = (StageOptions.Jsii$Proxy) o;

            if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) return false;
            if (!stageName.equals(that.stageName)) return false;
            if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
            if (this.transitionDisabledReason != null ? !this.transitionDisabledReason.equals(that.transitionDisabledReason) : that.transitionDisabledReason != null) return false;
            return this.transitionToEnabled != null ? this.transitionToEnabled.equals(that.transitionToEnabled) : that.transitionToEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.placement != null ? this.placement.hashCode() : 0;
            result = 31 * result + (this.stageName.hashCode());
            result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
            result = 31 * result + (this.transitionDisabledReason != null ? this.transitionDisabledReason.hashCode() : 0);
            result = 31 * result + (this.transitionToEnabled != null ? this.transitionToEnabled.hashCode() : 0);
            return result;
        }
    }
}
