package software.amazon.awscdk.services.codedeploy;

/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentConfig`.
 * <p>
 * The <code>AWS::CodeDeploy::DeploymentConfig</code> resource creates a set of deployment rules, deployment success conditions, and deployment failure conditions that AWS CodeDeploy uses during a deployment. The deployment configuration specifies, through the use of a <code>MinimumHealthyHosts</code> value, the number or percentage of instances that must remain available at any time during a deployment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codedeploy.*;
 * CfnDeploymentConfig cfnDeploymentConfig = CfnDeploymentConfig.Builder.create(this, "MyCfnDeploymentConfig")
 *         .computePlatform("computePlatform")
 *         .deploymentConfigName("deploymentConfigName")
 *         .minimumHealthyHosts(MinimumHealthyHostsProperty.builder()
 *                 .type("type")
 *                 .value(123)
 *                 .build())
 *         .trafficRoutingConfig(TrafficRoutingConfigProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .timeBasedCanary(TimeBasedCanaryProperty.builder()
 *                         .canaryInterval(123)
 *                         .canaryPercentage(123)
 *                         .build())
 *                 .timeBasedLinear(TimeBasedLinearProperty.builder()
 *                         .linearInterval(123)
 *                         .linearPercentage(123)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:56.256Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codedeploy.CfnDeploymentConfig")
public class CfnDeploymentConfig extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnDeploymentConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeploymentConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CodeDeploy::DeploymentConfig`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeploymentConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.CfnDeploymentConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::CodeDeploy::DeploymentConfig`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeploymentConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The destination platform type for the deployment ( `Lambda` , `Server` , or `ECS` ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getComputePlatform() {
        return software.amazon.jsii.Kernel.get(this, "computePlatform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The destination platform type for the deployment ( `Lambda` , `Server` , or `ECS` ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputePlatform(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "computePlatform", value);
    }

    /**
     * A name for the deployment configuration.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment configuration name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeploymentConfigName() {
        return software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the deployment configuration.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment configuration name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentConfigName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deploymentConfigName", value);
    }

    /**
     * The minimum number of healthy instances that should be available at any time during the deployment.
     * <p>
     * There are two parameters expected in the input: type and value.
     * <p>
     * The type parameter takes either of the following values:
     * <p>
     * <ul>
     * <li>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</li>
     * <li>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.</li>
     * </ul>
     * <p>
     * The value parameter takes an integer.
     * <p>
     * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
     * <p>
     * For more information about instance health, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">CodeDeploy Instance Health</a> in the AWS CodeDeploy User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMinimumHealthyHosts() {
        return software.amazon.jsii.Kernel.get(this, "minimumHealthyHosts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The minimum number of healthy instances that should be available at any time during the deployment.
     * <p>
     * There are two parameters expected in the input: type and value.
     * <p>
     * The type parameter takes either of the following values:
     * <p>
     * <ul>
     * <li>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</li>
     * <li>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.</li>
     * </ul>
     * <p>
     * The value parameter takes an integer.
     * <p>
     * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
     * <p>
     * For more information about instance health, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">CodeDeploy Instance Health</a> in the AWS CodeDeploy User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinimumHealthyHosts(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty value) {
        software.amazon.jsii.Kernel.set(this, "minimumHealthyHosts", value);
    }

    /**
     * The minimum number of healthy instances that should be available at any time during the deployment.
     * <p>
     * There are two parameters expected in the input: type and value.
     * <p>
     * The type parameter takes either of the following values:
     * <p>
     * <ul>
     * <li>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</li>
     * <li>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.</li>
     * </ul>
     * <p>
     * The value parameter takes an integer.
     * <p>
     * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
     * <p>
     * For more information about instance health, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">CodeDeploy Instance Health</a> in the AWS CodeDeploy User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinimumHealthyHosts(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "minimumHealthyHosts", value);
    }

    /**
     * The configuration that specifies how the deployment traffic is routed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTrafficRoutingConfig() {
        return software.amazon.jsii.Kernel.get(this, "trafficRoutingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration that specifies how the deployment traffic is routed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrafficRoutingConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "trafficRoutingConfig", value);
    }

    /**
     * The configuration that specifies how the deployment traffic is routed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrafficRoutingConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "trafficRoutingConfig", value);
    }
    /**
     * `MinimumHealthyHosts` is a property of the [DeploymentConfig](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html) resource that defines how many instances must remain healthy during an AWS CodeDeploy deployment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * MinimumHealthyHostsProperty minimumHealthyHostsProperty = MinimumHealthyHostsProperty.builder()
     *         .type("type")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty")
    @software.amazon.jsii.Jsii.Proxy(MinimumHealthyHostsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MinimumHealthyHostsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum healthy instance type:.
         * <p>
         * <ul>
         * <li>HOST_COUNT: The minimum number of healthy instance as an absolute value.</li>
         * <li>FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance in the deployment.</li>
         * </ul>
         * <p>
         * In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances at a time. The deployment is successful if six or more instances are deployed to successfully. Otherwise, the deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance at a time. The deployment is successful if four or more instance are deployed to successfully. Otherwise, the deployment fails.
         * <p>
         * <blockquote>
         * <p>
         * In a call to <code>GetDeploymentConfig</code> , CodeDeployDefault.OneAtATime returns a minimum healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances but one are kept in a healthy state during the deployment. Although this allows one instance at a time to be taken offline for a new deployment, it also means that if the deployment to the last instance fails, the overall deployment is still successful.
         * <p>
         * </blockquote>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com//codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance Health</a> in the <em>AWS CodeDeploy User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The minimum healthy instance value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link MinimumHealthyHostsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MinimumHealthyHostsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MinimumHealthyHostsProperty> {
            java.lang.String type;
            java.lang.Number value;

            /**
             * Sets the value of {@link MinimumHealthyHostsProperty#getType}
             * @param type The minimum healthy instance type:. This parameter is required.
             *             <ul>
             *             <li>HOST_COUNT: The minimum number of healthy instance as an absolute value.</li>
             *             <li>FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance in the deployment.</li>
             *             </ul>
             *             <p>
             *             In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances at a time. The deployment is successful if six or more instances are deployed to successfully. Otherwise, the deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance at a time. The deployment is successful if four or more instance are deployed to successfully. Otherwise, the deployment fails.
             *             <p>
             *             <blockquote>
             *             <p>
             *             In a call to <code>GetDeploymentConfig</code> , CodeDeployDefault.OneAtATime returns a minimum healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances but one are kept in a healthy state during the deployment. Although this allows one instance at a time to be taken offline for a new deployment, it also means that if the deployment to the last instance fails, the overall deployment is still successful.
             *             <p>
             *             </blockquote>
             *             <p>
             *             For more information, see <a href="https://docs.aws.amazon.com//codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance Health</a> in the <em>AWS CodeDeploy User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link MinimumHealthyHostsProperty#getValue}
             * @param value The minimum healthy instance value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MinimumHealthyHostsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MinimumHealthyHostsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MinimumHealthyHostsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MinimumHealthyHostsProperty {
            private final java.lang.String type;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MinimumHealthyHostsProperty.Jsii$Proxy that = (MinimumHealthyHostsProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * A configuration that shifts traffic from one version of a Lambda function or Amazon ECS task set to another in two increments.
     * <p>
     * The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * TimeBasedCanaryProperty timeBasedCanaryProperty = TimeBasedCanaryProperty.builder()
     *         .canaryInterval(123)
     *         .canaryPercentage(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codedeploy.CfnDeploymentConfig.TimeBasedCanaryProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeBasedCanaryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeBasedCanaryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of minutes between the first and second traffic shifts of a `TimeBasedCanary` deployment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getCanaryInterval();

        /**
         * The percentage of traffic to shift in the first increment of a `TimeBasedCanary` deployment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getCanaryPercentage();

        /**
         * @return a {@link Builder} of {@link TimeBasedCanaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeBasedCanaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeBasedCanaryProperty> {
            java.lang.Number canaryInterval;
            java.lang.Number canaryPercentage;

            /**
             * Sets the value of {@link TimeBasedCanaryProperty#getCanaryInterval}
             * @param canaryInterval The number of minutes between the first and second traffic shifts of a `TimeBasedCanary` deployment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canaryInterval(java.lang.Number canaryInterval) {
                this.canaryInterval = canaryInterval;
                return this;
            }

            /**
             * Sets the value of {@link TimeBasedCanaryProperty#getCanaryPercentage}
             * @param canaryPercentage The percentage of traffic to shift in the first increment of a `TimeBasedCanary` deployment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canaryPercentage(java.lang.Number canaryPercentage) {
                this.canaryPercentage = canaryPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeBasedCanaryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeBasedCanaryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeBasedCanaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeBasedCanaryProperty {
            private final java.lang.Number canaryInterval;
            private final java.lang.Number canaryPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.canaryInterval = software.amazon.jsii.Kernel.get(this, "canaryInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.canaryPercentage = software.amazon.jsii.Kernel.get(this, "canaryPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.canaryInterval = java.util.Objects.requireNonNull(builder.canaryInterval, "canaryInterval is required");
                this.canaryPercentage = java.util.Objects.requireNonNull(builder.canaryPercentage, "canaryPercentage is required");
            }

            @Override
            public final java.lang.Number getCanaryInterval() {
                return this.canaryInterval;
            }

            @Override
            public final java.lang.Number getCanaryPercentage() {
                return this.canaryPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("canaryInterval", om.valueToTree(this.getCanaryInterval()));
                data.set("canaryPercentage", om.valueToTree(this.getCanaryPercentage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_codedeploy.CfnDeploymentConfig.TimeBasedCanaryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeBasedCanaryProperty.Jsii$Proxy that = (TimeBasedCanaryProperty.Jsii$Proxy) o;

                if (!canaryInterval.equals(that.canaryInterval)) return false;
                return this.canaryPercentage.equals(that.canaryPercentage);
            }

            @Override
            public final int hashCode() {
                int result = this.canaryInterval.hashCode();
                result = 31 * result + (this.canaryPercentage.hashCode());
                return result;
            }
        }
    }
    /**
     * A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in equal increments, with an equal number of minutes between each increment.
     * <p>
     * The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * TimeBasedLinearProperty timeBasedLinearProperty = TimeBasedLinearProperty.builder()
     *         .linearInterval(123)
     *         .linearPercentage(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codedeploy.CfnDeploymentConfig.TimeBasedLinearProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeBasedLinearProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeBasedLinearProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of minutes between each incremental traffic shift of a `TimeBasedLinear` deployment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getLinearInterval();

        /**
         * The percentage of traffic that is shifted at the start of each increment of a `TimeBasedLinear` deployment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getLinearPercentage();

        /**
         * @return a {@link Builder} of {@link TimeBasedLinearProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeBasedLinearProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeBasedLinearProperty> {
            java.lang.Number linearInterval;
            java.lang.Number linearPercentage;

            /**
             * Sets the value of {@link TimeBasedLinearProperty#getLinearInterval}
             * @param linearInterval The number of minutes between each incremental traffic shift of a `TimeBasedLinear` deployment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linearInterval(java.lang.Number linearInterval) {
                this.linearInterval = linearInterval;
                return this;
            }

            /**
             * Sets the value of {@link TimeBasedLinearProperty#getLinearPercentage}
             * @param linearPercentage The percentage of traffic that is shifted at the start of each increment of a `TimeBasedLinear` deployment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linearPercentage(java.lang.Number linearPercentage) {
                this.linearPercentage = linearPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeBasedLinearProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeBasedLinearProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeBasedLinearProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeBasedLinearProperty {
            private final java.lang.Number linearInterval;
            private final java.lang.Number linearPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.linearInterval = software.amazon.jsii.Kernel.get(this, "linearInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.linearPercentage = software.amazon.jsii.Kernel.get(this, "linearPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.linearInterval = java.util.Objects.requireNonNull(builder.linearInterval, "linearInterval is required");
                this.linearPercentage = java.util.Objects.requireNonNull(builder.linearPercentage, "linearPercentage is required");
            }

            @Override
            public final java.lang.Number getLinearInterval() {
                return this.linearInterval;
            }

            @Override
            public final java.lang.Number getLinearPercentage() {
                return this.linearPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("linearInterval", om.valueToTree(this.getLinearInterval()));
                data.set("linearPercentage", om.valueToTree(this.getLinearPercentage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_codedeploy.CfnDeploymentConfig.TimeBasedLinearProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeBasedLinearProperty.Jsii$Proxy that = (TimeBasedLinearProperty.Jsii$Proxy) o;

                if (!linearInterval.equals(that.linearInterval)) return false;
                return this.linearPercentage.equals(that.linearPercentage);
            }

            @Override
            public final int hashCode() {
                int result = this.linearInterval.hashCode();
                result = 31 * result + (this.linearPercentage.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration that specifies how traffic is shifted from one version of a Lambda function to another version during an AWS Lambda deployment, or from one Amazon ECS task set to another during an Amazon ECS deployment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codedeploy.*;
     * TrafficRoutingConfigProperty trafficRoutingConfigProperty = TrafficRoutingConfigProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .timeBasedCanary(TimeBasedCanaryProperty.builder()
     *                 .canaryInterval(123)
     *                 .canaryPercentage(123)
     *                 .build())
     *         .timeBasedLinear(TimeBasedLinearProperty.builder()
     *                 .linearInterval(123)
     *                 .linearPercentage(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TrafficRoutingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrafficRoutingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of traffic shifting ( `TimeBasedCanary` or `TimeBasedLinear` ) used by a deployment configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two increments.
         * <p>
         * The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeBasedCanary() {
            return null;
        }

        /**
         * A configuration that shifts traffic from one version of a Lambda function or Amazon ECS task set to another in equal increments, with an equal number of minutes between each increment.
         * <p>
         * The original and target Lambda function versions or Amazon ECS task sets are specified in the deployment's AppSpec file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeBasedLinear() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TrafficRoutingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrafficRoutingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrafficRoutingConfigProperty> {
            java.lang.String type;
            java.lang.Object timeBasedCanary;
            java.lang.Object timeBasedLinear;

            /**
             * Sets the value of {@link TrafficRoutingConfigProperty#getType}
             * @param type The type of traffic shifting ( `TimeBasedCanary` or `TimeBasedLinear` ) used by a deployment configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link TrafficRoutingConfigProperty#getTimeBasedCanary}
             * @param timeBasedCanary A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two increments.
             *                        The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeBasedCanary(software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TimeBasedCanaryProperty timeBasedCanary) {
                this.timeBasedCanary = timeBasedCanary;
                return this;
            }

            /**
             * Sets the value of {@link TrafficRoutingConfigProperty#getTimeBasedCanary}
             * @param timeBasedCanary A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two increments.
             *                        The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeBasedCanary(software.amazon.awscdk.core.IResolvable timeBasedCanary) {
                this.timeBasedCanary = timeBasedCanary;
                return this;
            }

            /**
             * Sets the value of {@link TrafficRoutingConfigProperty#getTimeBasedLinear}
             * @param timeBasedLinear A configuration that shifts traffic from one version of a Lambda function or Amazon ECS task set to another in equal increments, with an equal number of minutes between each increment.
             *                        The original and target Lambda function versions or Amazon ECS task sets are specified in the deployment's AppSpec file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeBasedLinear(software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TimeBasedLinearProperty timeBasedLinear) {
                this.timeBasedLinear = timeBasedLinear;
                return this;
            }

            /**
             * Sets the value of {@link TrafficRoutingConfigProperty#getTimeBasedLinear}
             * @param timeBasedLinear A configuration that shifts traffic from one version of a Lambda function or Amazon ECS task set to another in equal increments, with an equal number of minutes between each increment.
             *                        The original and target Lambda function versions or Amazon ECS task sets are specified in the deployment's AppSpec file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeBasedLinear(software.amazon.awscdk.core.IResolvable timeBasedLinear) {
                this.timeBasedLinear = timeBasedLinear;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrafficRoutingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrafficRoutingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrafficRoutingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrafficRoutingConfigProperty {
            private final java.lang.String type;
            private final java.lang.Object timeBasedCanary;
            private final java.lang.Object timeBasedLinear;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeBasedCanary = software.amazon.jsii.Kernel.get(this, "timeBasedCanary", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeBasedLinear = software.amazon.jsii.Kernel.get(this, "timeBasedLinear", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.timeBasedCanary = builder.timeBasedCanary;
                this.timeBasedLinear = builder.timeBasedLinear;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getTimeBasedCanary() {
                return this.timeBasedCanary;
            }

            @Override
            public final java.lang.Object getTimeBasedLinear() {
                return this.timeBasedLinear;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getTimeBasedCanary() != null) {
                    data.set("timeBasedCanary", om.valueToTree(this.getTimeBasedCanary()));
                }
                if (this.getTimeBasedLinear() != null) {
                    data.set("timeBasedLinear", om.valueToTree(this.getTimeBasedLinear()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrafficRoutingConfigProperty.Jsii$Proxy that = (TrafficRoutingConfigProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.timeBasedCanary != null ? !this.timeBasedCanary.equals(that.timeBasedCanary) : that.timeBasedCanary != null) return false;
                return this.timeBasedLinear != null ? this.timeBasedLinear.equals(that.timeBasedLinear) : that.timeBasedLinear == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.timeBasedCanary != null ? this.timeBasedCanary.hashCode() : 0);
                result = 31 * result + (this.timeBasedLinear != null ? this.timeBasedLinear.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.codedeploy.CfnDeploymentConfigProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The destination platform type for the deployment ( `Lambda` , `Server` , or `ECS` ).
         * <p>
         * @return {@code this}
         * @param computePlatform The destination platform type for the deployment ( `Lambda` , `Server` , or `ECS` ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computePlatform(final java.lang.String computePlatform) {
            this.props().computePlatform(computePlatform);
            return this;
        }

        /**
         * A name for the deployment configuration.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment configuration name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param deploymentConfigName A name for the deployment configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(final java.lang.String deploymentConfigName) {
            this.props().deploymentConfigName(deploymentConfigName);
            return this;
        }

        /**
         * The minimum number of healthy instances that should be available at any time during the deployment.
         * <p>
         * There are two parameters expected in the input: type and value.
         * <p>
         * The type parameter takes either of the following values:
         * <p>
         * <ul>
         * <li>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</li>
         * <li>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.</li>
         * </ul>
         * <p>
         * The value parameter takes an integer.
         * <p>
         * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
         * <p>
         * For more information about instance health, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">CodeDeploy Instance Health</a> in the AWS CodeDeploy User Guide.
         * <p>
         * @return {@code this}
         * @param minimumHealthyHosts The minimum number of healthy instances that should be available at any time during the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumHealthyHosts(final software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty minimumHealthyHosts) {
            this.props().minimumHealthyHosts(minimumHealthyHosts);
            return this;
        }
        /**
         * The minimum number of healthy instances that should be available at any time during the deployment.
         * <p>
         * There are two parameters expected in the input: type and value.
         * <p>
         * The type parameter takes either of the following values:
         * <p>
         * <ul>
         * <li>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</li>
         * <li>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.</li>
         * </ul>
         * <p>
         * The value parameter takes an integer.
         * <p>
         * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
         * <p>
         * For more information about instance health, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">CodeDeploy Instance Health</a> in the AWS CodeDeploy User Guide.
         * <p>
         * @return {@code this}
         * @param minimumHealthyHosts The minimum number of healthy instances that should be available at any time during the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumHealthyHosts(final software.amazon.awscdk.core.IResolvable minimumHealthyHosts) {
            this.props().minimumHealthyHosts(minimumHealthyHosts);
            return this;
        }

        /**
         * The configuration that specifies how the deployment traffic is routed.
         * <p>
         * @return {@code this}
         * @param trafficRoutingConfig The configuration that specifies how the deployment traffic is routed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficRoutingConfig(final software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty trafficRoutingConfig) {
            this.props().trafficRoutingConfig(trafficRoutingConfig);
            return this;
        }
        /**
         * The configuration that specifies how the deployment traffic is routed.
         * <p>
         * @return {@code this}
         * @param trafficRoutingConfig The configuration that specifies how the deployment traffic is routed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficRoutingConfig(final software.amazon.awscdk.core.IResolvable trafficRoutingConfig) {
            this.props().trafficRoutingConfig(trafficRoutingConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig build() {
            return new software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.codedeploy.CfnDeploymentConfigProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.codedeploy.CfnDeploymentConfigProps.Builder();
            }
            return this.props;
        }
    }
}
