package software.amazon.awscdk.services.codebuild;

/**
 * (experimental) Build machine compute type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * SecurityGroup mySecurityGroup;
 * CodeBuildStep.Builder.create("Synth")
 *         // ...standard ShellStep props...
 *         .commands(List.of())
 *         .env(Map.of())
 *         // If you are using a CodeBuildStep explicitly, set the 'cdk.out' directory
 *         // to be the synth step's output.
 *         .primaryOutputDirectory("cdk.out")
 *         // Control the name of the project
 *         .projectName("MyProject")
 *         // Control parts of the BuildSpec other than the regular 'build' and 'install' commands
 *         .partialBuildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2")))
 *         // Control the build environment
 *         .buildEnvironment(BuildEnvironment.builder()
 *                 .computeType(ComputeType.LARGE)
 *                 .build())
 *         .timeout(Duration.minutes(90))
 *         // Control Elastic Network Interface creation
 *         .vpc(vpc)
 *         .subnetSelection(SubnetSelection.builder().subnetType(SubnetType.PRIVATE_WITH_NAT).build())
 *         .securityGroups(List.of(mySecurityGroup))
 *         // Additional policy statements for the execution role
 *         .rolePolicyStatements(List.of(
 *             PolicyStatement.Builder.create().build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:56.106Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codebuild.ComputeType")
public enum ComputeType {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SMALL,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MEDIUM,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LARGE,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    X2_LARGE,
}
