package software.amazon.awscdk.services.codebuild;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * SecurityGroup mySecurityGroup;
 * CodePipeline.Builder.create(this, "Pipeline")
 *         // Standard CodePipeline properties
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(CodePipelineSource.connection("my-org/my-app", "main", ConnectionSourceOptions.builder()
 *                         .connectionArn("arn:aws:codestar-connections:us-east-1:222222222222:connection/7d2469ff-514a-4e4f-9003-5ca4a43cdc41")
 *                         .build()))
 *                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
 *                 .build())
 *         // Defaults for all CodeBuild projects
 *         .codeBuildDefaults(CodeBuildOptions.builder()
 *                 // Prepend commands and configuration to all projects
 *                 .partialBuildSpec(BuildSpec.fromObject(Map.of(
 *                         "version", "0.2")))
 *                 // Control the build environment
 *                 .buildEnvironment(BuildEnvironment.builder()
 *                         .computeType(ComputeType.LARGE)
 *                         .build())
 *                 // Control Elastic Network Interface creation
 *                 .vpc(vpc)
 *                 .subnetSelection(SubnetSelection.builder().subnetType(SubnetType.PRIVATE_WITH_NAT).build())
 *                 .securityGroups(List.of(mySecurityGroup))
 *                 // Additional policy statements for the execution role
 *                 .rolePolicy(List.of(
 *                     PolicyStatement.Builder.create().build()))
 *                 .build())
 *         .synthCodeBuildDefaults(CodeBuildOptions.builder().build())
 *         .assetPublishingCodeBuildDefaults(CodeBuildOptions.builder().build())
 *         .selfMutationCodeBuildDefaults(CodeBuildOptions.builder().build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:56.017Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codebuild.BuildEnvironment")
@software.amazon.jsii.Jsii.Proxy(BuildEnvironment.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BuildEnvironment extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The image used for the builds.
     * <p>
     * Default: LinuxBuildImage.STANDARD_1_0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.IBuildImage getBuildImage() {
        return null;
    }

    /**
     * (experimental) The location of the PEM-encoded certificate for the build project.
     * <p>
     * Default: - No external certificate is added to the project
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildEnvironmentCertificate getCertificate() {
        return null;
    }

    /**
     * (experimental) The type of compute to use for this build.
     * <p>
     * See the {&#64;link ComputeType} enum for the possible values.
     * <p>
     * Default: taken from {@link #buildImage#defaultComputeType}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ComputeType getComputeType() {
        return null;
    }

    /**
     * (experimental) The environment variables that your builds can use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> getEnvironmentVariables() {
        return null;
    }

    /**
     * (experimental) Indicates how the project builds Docker images.
     * <p>
     * Specify true to enable
     * running the Docker daemon inside a Docker container. This value must be
     * set to true only if this build project will be used to build Docker
     * images, and the specified build environment image is not one provided by
     * AWS CodeBuild with Docker support. Otherwise, all associated builds that
     * attempt to interact with the Docker daemon will fail.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivileged() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BuildEnvironment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BuildEnvironment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BuildEnvironment> {
        software.amazon.awscdk.services.codebuild.IBuildImage buildImage;
        software.amazon.awscdk.services.codebuild.BuildEnvironmentCertificate certificate;
        software.amazon.awscdk.services.codebuild.ComputeType computeType;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables;
        java.lang.Boolean privileged;

        /**
         * Sets the value of {@link BuildEnvironment#getBuildImage}
         * @param buildImage The image used for the builds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildImage(software.amazon.awscdk.services.codebuild.IBuildImage buildImage) {
            this.buildImage = buildImage;
            return this;
        }

        /**
         * Sets the value of {@link BuildEnvironment#getCertificate}
         * @param certificate The location of the PEM-encoded certificate for the build project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder certificate(software.amazon.awscdk.services.codebuild.BuildEnvironmentCertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link BuildEnvironment#getComputeType}
         * @param computeType The type of compute to use for this build.
         *                    See the {&#64;link ComputeType} enum for the possible values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder computeType(software.amazon.awscdk.services.codebuild.ComputeType computeType) {
            this.computeType = computeType;
            return this;
        }

        /**
         * Sets the value of {@link BuildEnvironment#getEnvironmentVariables}
         * @param environmentVariables The environment variables that your builds can use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder environmentVariables(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables) {
            this.environmentVariables = (java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable>)environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link BuildEnvironment#getPrivileged}
         * @param privileged Indicates how the project builds Docker images.
         *                   Specify true to enable
         *                   running the Docker daemon inside a Docker container. This value must be
         *                   set to true only if this build project will be used to build Docker
         *                   images, and the specified build environment image is not one provided by
         *                   AWS CodeBuild with Docker support. Otherwise, all associated builds that
         *                   attempt to interact with the Docker daemon will fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder privileged(java.lang.Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BuildEnvironment}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BuildEnvironment build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BuildEnvironment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BuildEnvironment {
        private final software.amazon.awscdk.services.codebuild.IBuildImage buildImage;
        private final software.amazon.awscdk.services.codebuild.BuildEnvironmentCertificate certificate;
        private final software.amazon.awscdk.services.codebuild.ComputeType computeType;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables;
        private final java.lang.Boolean privileged;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.buildImage = software.amazon.jsii.Kernel.get(this, "buildImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildEnvironmentCertificate.class));
            this.computeType = software.amazon.jsii.Kernel.get(this, "computeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ComputeType.class));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable.class)));
            this.privileged = software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.buildImage = builder.buildImage;
            this.certificate = builder.certificate;
            this.computeType = builder.computeType;
            this.environmentVariables = (java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable>)builder.environmentVariables;
            this.privileged = builder.privileged;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.IBuildImage getBuildImage() {
            return this.buildImage;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildEnvironmentCertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.ComputeType getComputeType() {
            return this.computeType;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final java.lang.Boolean getPrivileged() {
            return this.privileged;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBuildImage() != null) {
                data.set("buildImage", om.valueToTree(this.getBuildImage()));
            }
            if (this.getCertificate() != null) {
                data.set("certificate", om.valueToTree(this.getCertificate()));
            }
            if (this.getComputeType() != null) {
                data.set("computeType", om.valueToTree(this.getComputeType()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getPrivileged() != null) {
                data.set("privileged", om.valueToTree(this.getPrivileged()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_codebuild.BuildEnvironment"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BuildEnvironment.Jsii$Proxy that = (BuildEnvironment.Jsii$Proxy) o;

            if (this.buildImage != null ? !this.buildImage.equals(that.buildImage) : that.buildImage != null) return false;
            if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
            if (this.computeType != null ? !this.computeType.equals(that.computeType) : that.computeType != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            return this.privileged != null ? this.privileged.equals(that.privileged) : that.privileged == null;
        }

        @Override
        public final int hashCode() {
            int result = this.buildImage != null ? this.buildImage.hashCode() : 0;
            result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
            result = 31 * result + (this.computeType != null ? this.computeType.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
            return result;
        }
    }
}
