package software.amazon.awscdk.services.codebuild;

/**
 * (experimental) The source credentials used when contacting the BitBucket API.
 * <p>
 * <strong>Note</strong>: CodeBuild only allows a single credential for BitBucket
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * BitBucketSourceCredentials.Builder.create(this, "CodeBuildBitBucketCreds")
 *         .username(SecretValue.secretsManager("my-bitbucket-creds", SecretsManagerSecretOptions.builder().jsonField("username").build()))
 *         .password(SecretValue.secretsManager("my-bitbucket-creds", SecretsManagerSecretOptions.builder().jsonField("password").build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:56.008Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codebuild.BitBucketSourceCredentials")
public class BitBucketSourceCredentials extends software.amazon.awscdk.core.Resource {

    protected BitBucketSourceCredentials(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BitBucketSourceCredentials(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public BitBucketSourceCredentials(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BitBucketSourceCredentialsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.codebuild.BitBucketSourceCredentials}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codebuild.BitBucketSourceCredentials> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codebuild.BitBucketSourceCredentialsProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codebuild.BitBucketSourceCredentialsProps.Builder();
        }

        /**
         * (experimental) Your BitBucket application password.
         * <p>
         * @return {@code this}
         * @param password Your BitBucket application password. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder password(final software.amazon.awscdk.core.SecretValue password) {
            this.props.password(password);
            return this;
        }

        /**
         * (experimental) Your BitBucket username.
         * <p>
         * @return {@code this}
         * @param username Your BitBucket username. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder username(final software.amazon.awscdk.core.SecretValue username) {
            this.props.username(username);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codebuild.BitBucketSourceCredentials}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.codebuild.BitBucketSourceCredentials build() {
            return new software.amazon.awscdk.services.codebuild.BitBucketSourceCredentials(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
