package software.amazon.awscdk.services.cloudwatch;

/**
 * (experimental) Properties for a MathExpression.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn;
 * MathExpression allProblems = MathExpression.Builder.create()
 *         .expression("errors + throttles")
 *         .usingMetrics(Map.of(
 *                 "errors", fn.metricErrors(),
 *                 "faults", fn.metricThrottles()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:55.895Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudwatch.MathExpressionProps")
@software.amazon.jsii.Jsii.Proxy(MathExpressionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface MathExpressionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.MathExpressionOptions {

    /**
     * (experimental) The expression defining the metric.
     * <p>
     * When an expression contains a SEARCH function, it cannot be used
     * within an Alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getExpression();

    /**
     * (experimental) The metrics used in the expression, in a map.
     * <p>
     * The key is the identifier that represents the given metric in the
     * expression, and the value is the actual Metric object.
     * <p>
     * Default: - Empty map.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> getUsingMetrics() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MathExpressionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MathExpressionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<MathExpressionProps> {
        java.lang.String expression;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics;
        java.lang.String color;
        java.lang.String label;
        software.amazon.awscdk.core.Duration period;
        java.lang.String searchAccount;
        java.lang.String searchRegion;

        /**
         * Sets the value of {@link MathExpressionProps#getExpression}
         * @param expression The expression defining the metric. This parameter is required.
         *                   When an expression contains a SEARCH function, it cannot be used
         *                   within an Alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder expression(java.lang.String expression) {
            this.expression = expression;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionProps#getUsingMetrics}
         * @param usingMetrics The metrics used in the expression, in a map.
         *                     The key is the identifier that represents the given metric in the
         *                     expression, and the value is the actual Metric object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder usingMetrics(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics) {
            this.usingMetrics = (java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric>)usingMetrics;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionProps#getColor}
         * @param color Color for this metric when added to a Graph in a Dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder color(java.lang.String color) {
            this.color = color;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionProps#getLabel}
         * @param label Label for this expression when added to a Graph in a Dashboard.
         *              If this expression evaluates to more than one time series (for
         *              example, through the use of <code>METRICS()</code> or <code>SEARCH()</code> expressions),
         *              each time series will appear in the graph using a combination of the
         *              expression label and the individual metric label. Specify the empty
         *              string (<code>''</code>) to suppress the expression label and only keep the
         *              metric label.
         *              <p>
         *              You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">dynamic labels</a>
         *              to show summary information about the displayed time series
         *              in the legend. For example, if you use:
         *              <p>
         *              <blockquote><pre>
         *              [max: ${MAX}] MyMetric
         *              </pre></blockquote>
         *              <p>
         *              As the metric label, the maximum value in the visible range will
         *              be shown next to the time series name in the graph's legend. If the
         *              math expression produces more than one time series, the maximum
         *              will be shown for each individual time series produce by this
         *              math expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder label(java.lang.String label) {
            this.label = label;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionProps#getPeriod}
         * @param period The period over which the expression's statistics are applied.
         *               This period overrides all periods in the metrics used in this
         *               math expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder period(software.amazon.awscdk.core.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionProps#getSearchAccount}
         * @param searchAccount Account to evaluate search expressions within.
         *                      Specifying a searchAccount has no effect to the account used
         *                      for metrics within the expression (passed via usingMetrics).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder searchAccount(java.lang.String searchAccount) {
            this.searchAccount = searchAccount;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionProps#getSearchRegion}
         * @param searchRegion Region to evaluate search expressions within.
         *                     Specifying a searchRegion has no effect to the region used
         *                     for metrics within the expression (passed via usingMetrics).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder searchRegion(java.lang.String searchRegion) {
            this.searchRegion = searchRegion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MathExpressionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public MathExpressionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MathExpressionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MathExpressionProps {
        private final java.lang.String expression;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics;
        private final java.lang.String color;
        private final java.lang.String label;
        private final software.amazon.awscdk.core.Duration period;
        private final java.lang.String searchAccount;
        private final java.lang.String searchRegion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.usingMetrics = software.amazon.jsii.Kernel.get(this, "usingMetrics", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class)));
            this.color = software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.searchAccount = software.amazon.jsii.Kernel.get(this, "searchAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.searchRegion = software.amazon.jsii.Kernel.get(this, "searchRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
            this.usingMetrics = (java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric>)builder.usingMetrics;
            this.color = builder.color;
            this.label = builder.label;
            this.period = builder.period;
            this.searchAccount = builder.searchAccount;
            this.searchRegion = builder.searchRegion;
        }

        @Override
        public final java.lang.String getExpression() {
            return this.expression;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> getUsingMetrics() {
            return this.usingMetrics;
        }

        @Override
        public final java.lang.String getColor() {
            return this.color;
        }

        @Override
        public final java.lang.String getLabel() {
            return this.label;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.String getSearchAccount() {
            return this.searchAccount;
        }

        @Override
        public final java.lang.String getSearchRegion() {
            return this.searchRegion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("expression", om.valueToTree(this.getExpression()));
            if (this.getUsingMetrics() != null) {
                data.set("usingMetrics", om.valueToTree(this.getUsingMetrics()));
            }
            if (this.getColor() != null) {
                data.set("color", om.valueToTree(this.getColor()));
            }
            if (this.getLabel() != null) {
                data.set("label", om.valueToTree(this.getLabel()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getSearchAccount() != null) {
                data.set("searchAccount", om.valueToTree(this.getSearchAccount()));
            }
            if (this.getSearchRegion() != null) {
                data.set("searchRegion", om.valueToTree(this.getSearchRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_cloudwatch.MathExpressionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MathExpressionProps.Jsii$Proxy that = (MathExpressionProps.Jsii$Proxy) o;

            if (!expression.equals(that.expression)) return false;
            if (this.usingMetrics != null ? !this.usingMetrics.equals(that.usingMetrics) : that.usingMetrics != null) return false;
            if (this.color != null ? !this.color.equals(that.color) : that.color != null) return false;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.searchAccount != null ? !this.searchAccount.equals(that.searchAccount) : that.searchAccount != null) return false;
            return this.searchRegion != null ? this.searchRegion.equals(that.searchRegion) : that.searchRegion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.expression.hashCode();
            result = 31 * result + (this.usingMetrics != null ? this.usingMetrics.hashCode() : 0);
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.searchAccount != null ? this.searchAccount.hashCode() : 0);
            result = 31 * result + (this.searchRegion != null ? this.searchRegion.hashCode() : 0);
            return result;
        }
    }
}
