package software.amazon.awscdk.services.cloudwatch;

/**
 * (experimental) Comparison operator for evaluating alarms.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * HostedZone myHostedZone;
 * Certificate certificate = Certificate.Builder.create(this, "Certificate")
 *         .domainName("hello.example.com")
 *         .validation(CertificateValidation.fromDns(myHostedZone))
 *         .build();
 * certificate.metricDaysToExpiry().createAlarm(this, "Alarm", CreateAlarmOptions.builder()
 *         .comparisonOperator(ComparisonOperator.LESS_THAN_THRESHOLD)
 *         .evaluationPeriods(1)
 *         .threshold(45)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:55.854Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudwatch.ComparisonOperator")
public enum ComparisonOperator {
    /**
     * (experimental) Specified statistic is greater than or equal to the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
    /**
     * (experimental) Specified statistic is strictly greater than the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GREATER_THAN_THRESHOLD,
    /**
     * (experimental) Specified statistic is strictly less than the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LESS_THAN_THRESHOLD,
    /**
     * (experimental) Specified statistic is less than or equal to the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LESS_THAN_OR_EQUAL_TO_THRESHOLD,
    /**
     * (experimental) Specified statistic is lower than or greater than the anomaly model band.
     * <p>
     * Used only for alarms based on anomaly detection models
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD,
    /**
     * (experimental) Specified statistic is greater than the anomaly model band.
     * <p>
     * Used only for alarms based on anomaly detection models
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GREATER_THAN_UPPER_THRESHOLD,
    /**
     * (experimental) Specified statistic is lower than the anomaly model band.
     * <p>
     * Used only for alarms based on anomaly detection models
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LESS_THAN_LOWER_THRESHOLD,
}
