package software.amazon.awscdk.services.cloudwatch;

/**
 * (experimental) An alarm on a CloudWatch metric.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Alias alias;
 * // or add alarms to an existing group
 * Alias blueGreenAlias;
 * Alarm alarm = Alarm.Builder.create(this, "Errors")
 *         .comparisonOperator(ComparisonOperator.GREATER_THAN_THRESHOLD)
 *         .threshold(1)
 *         .evaluationPeriods(1)
 *         .metric(alias.metricErrors())
 *         .build();
 * LambdaDeploymentGroup deploymentGroup = LambdaDeploymentGroup.Builder.create(this, "BlueGreenDeployment")
 *         .alias(alias)
 *         .deploymentConfig(LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE)
 *         .alarms(List.of(alarm))
 *         .build();
 * deploymentGroup.addAlarm(Alarm.Builder.create(this, "BlueGreenErrors")
 *         .comparisonOperator(ComparisonOperator.GREATER_THAN_THRESHOLD)
 *         .threshold(1)
 *         .evaluationPeriods(1)
 *         .metric(blueGreenAlias.metricErrors())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:55.767Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudwatch.Alarm")
public class Alarm extends software.amazon.awscdk.services.cloudwatch.AlarmBase {

    protected Alarm(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Alarm(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Alarm(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.AlarmProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing CloudWatch alarm provided an ARN.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param alarmArn Alarm ARN (i.e. arn:aws:cloudwatch:<region>:<account-id>:alarm:Foo). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm fromAlarmArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String alarmArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Alarm.class, "fromAlarmArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IAlarm.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(alarmArn, "alarmArn is required") });
    }

    /**
     * (experimental) Trigger this action if the alarm fires.
     * <p>
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     * <p>
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addAlarmAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarmAction... actions) {
        software.amazon.jsii.Kernel.call(this, "addAlarmAction", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(actions).toArray(Object[]::new));
    }

    /**
     * (experimental) Turn this alarm into a horizontal annotation.
     * <p>
     * This is useful if you want to represent an Alarm in a non-AlarmWidget.
     * An <code>AlarmWidget</code> can directly show an alarm, but it can only show a
     * single alarm and no other metrics. Instead, you can convert the alarm to
     * a HorizontalAnnotation and add it as an annotation to another graph.
     * <p>
     * This might be useful if:
     * <p>
     * <ul>
     * <li>You want to show multiple alarms inside a single graph, for example if
     * you have both a "small margin/long period" alarm as well as a
     * "large margin/short period" alarm.</li>
     * <li>You want to show an Alarm line in a graph with multiple metrics in it.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation toAnnotation() {
        return software.amazon.jsii.Kernel.call(this, "toAnnotation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation.class));
    }

    /**
     * (experimental) ARN of this alarm.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAlarmArn() {
        return software.amazon.jsii.Kernel.get(this, "alarmArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Name of this alarm.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAlarmName() {
        return software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The metric object this alarm was based on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric getMetric() {
        return software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.Alarm}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.Alarm> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudwatch.AlarmProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudwatch.AlarmProps.Builder();
        }

        /**
         * (experimental) The number of periods over which data is compared to the specified threshold.
         * <p>
         * @return {@code this}
         * @param evaluationPeriods The number of periods over which data is compared to the specified threshold. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder evaluationPeriods(final java.lang.Number evaluationPeriods) {
            this.props.evaluationPeriods(evaluationPeriods);
            return this;
        }

        /**
         * (experimental) The value against which the specified statistic is compared.
         * <p>
         * @return {@code this}
         * @param threshold The value against which the specified statistic is compared. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder threshold(final java.lang.Number threshold) {
            this.props.threshold(threshold);
            return this;
        }

        /**
         * (experimental) Whether the actions for this alarm are enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param actionsEnabled Whether the actions for this alarm are enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionsEnabled(final java.lang.Boolean actionsEnabled) {
            this.props.actionsEnabled(actionsEnabled);
            return this;
        }

        /**
         * (experimental) Description for the alarm.
         * <p>
         * Default: No description
         * <p>
         * @return {@code this}
         * @param alarmDescription Description for the alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder alarmDescription(final java.lang.String alarmDescription) {
            this.props.alarmDescription(alarmDescription);
            return this;
        }

        /**
         * (experimental) Name of the alarm.
         * <p>
         * Default: Automatically generated name
         * <p>
         * @return {@code this}
         * @param alarmName Name of the alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder alarmName(final java.lang.String alarmName) {
            this.props.alarmName(alarmName);
            return this;
        }

        /**
         * (experimental) Comparison to use to check if metric is breaching.
         * <p>
         * Default: GreaterThanOrEqualToThreshold
         * <p>
         * @return {@code this}
         * @param comparisonOperator Comparison to use to check if metric is breaching. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder comparisonOperator(final software.amazon.awscdk.services.cloudwatch.ComparisonOperator comparisonOperator) {
            this.props.comparisonOperator(comparisonOperator);
            return this;
        }

        /**
         * (experimental) The number of datapoints that must be breaching to trigger the alarm.
         * <p>
         * This is used only if you are setting an "M
         * out of N" alarm. In that case, this value is the M. For more information, see Evaluating an Alarm in the Amazon
         * CloudWatch User Guide.
         * <p>
         * Default: ``evaluationPeriods``
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation</a>
         * @param datapointsToAlarm The number of datapoints that must be breaching to trigger the alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder datapointsToAlarm(final java.lang.Number datapointsToAlarm) {
            this.props.datapointsToAlarm(datapointsToAlarm);
            return this;
        }

        /**
         * (experimental) Specifies whether to evaluate the data and potentially change the alarm state if there are too few data points to be statistically significant.
         * <p>
         * Used only for alarms that are based on percentiles.
         * <p>
         * Default: - Not configured.
         * <p>
         * @return {@code this}
         * @param evaluateLowSampleCountPercentile Specifies whether to evaluate the data and potentially change the alarm state if there are too few data points to be statistically significant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder evaluateLowSampleCountPercentile(final java.lang.String evaluateLowSampleCountPercentile) {
            this.props.evaluateLowSampleCountPercentile(evaluateLowSampleCountPercentile);
            return this;
        }

        /**
         * (deprecated) The period over which the specified statistic is applied.
         * <p>
         * Cannot be used with <code>MathExpression</code> objects.
         * <p>
         * Default: - The period from the metric
         * <p>
         * @return {@code this}
         * @deprecated Use `metric.with({ period: ... })` to encode the period into the Metric object
         * @param period The period over which the specified statistic is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder period(final software.amazon.awscdk.core.Duration period) {
            this.props.period(period);
            return this;
        }

        /**
         * (deprecated) What function to use for aggregating.
         * <p>
         * Can be one of the following:
         * <p>
         * <ul>
         * <li>"Minimum" | "min"</li>
         * <li>"Maximum" | "max"</li>
         * <li>"Average" | "avg"</li>
         * <li>"Sum" | "sum"</li>
         * <li>"SampleCount | "n"</li>
         * <li>"pNN.NN"</li>
         * </ul>
         * <p>
         * Cannot be used with <code>MathExpression</code> objects.
         * <p>
         * Default: - The statistic from the metric
         * <p>
         * @return {@code this}
         * @deprecated Use `metric.with({ statistic: ... })` to encode the period into the Metric object
         * @param statistic What function to use for aggregating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder statistic(final java.lang.String statistic) {
            this.props.statistic(statistic);
            return this;
        }

        /**
         * (experimental) Sets how this alarm is to handle missing data points.
         * <p>
         * Default: TreatMissingData.Missing
         * <p>
         * @return {@code this}
         * @param treatMissingData Sets how this alarm is to handle missing data points. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder treatMissingData(final software.amazon.awscdk.services.cloudwatch.TreatMissingData treatMissingData) {
            this.props.treatMissingData(treatMissingData);
            return this;
        }

        /**
         * (experimental) The metric to add the alarm on.
         * <p>
         * Metric objects can be obtained from most resources, or you can construct
         * custom Metric objects by instantiating one.
         * <p>
         * @return {@code this}
         * @param metric The metric to add the alarm on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metric(final software.amazon.awscdk.services.cloudwatch.IMetric metric) {
            this.props.metric(metric);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.Alarm}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cloudwatch.Alarm build() {
            return new software.amazon.awscdk.services.cloudwatch.Alarm(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
