package software.amazon.awscdk.services.cloudfront.origins;

/**
 * (experimental) An Origin for an HTTP server or S3 bucket configured for website hosting.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket myBucket = new Bucket(this, "myBucket");
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(OriginGroup.Builder.create()
 *                         .primaryOrigin(new S3Origin(myBucket))
 *                         .fallbackOrigin(new HttpOrigin("www.example.com"))
 *                         // optional, defaults to: 500, 502, 503 and 504
 *                         .fallbackStatusCodes(List.of(404))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:55.672Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudfront_origins.HttpOrigin")
public class HttpOrigin extends software.amazon.awscdk.services.cloudfront.OriginBase {

    protected HttpOrigin(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpOrigin(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param domainName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpOrigin(final @org.jetbrains.annotations.NotNull java.lang.String domainName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.origins.HttpOriginProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(domainName, "domainName is required"), props });
    }

    /**
     * @param domainName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpOrigin(final @org.jetbrains.annotations.NotNull java.lang.String domainName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(domainName, "domainName is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomOriginConfigProperty renderCustomOriginConfig() {
        return software.amazon.jsii.Kernel.call(this, "renderCustomOriginConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomOriginConfigProperty.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.cloudfront.origins.HttpOrigin}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.origins.HttpOrigin> {
        /**
         * @return a new instance of {@link Builder}.
         * @param domainName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final java.lang.String domainName) {
            return new Builder(domainName);
        }

        private final java.lang.String domainName;
        private software.amazon.awscdk.services.cloudfront.origins.HttpOriginProps.Builder props;

        private Builder(final java.lang.String domainName) {
            this.domainName = domainName;
        }

        /**
         * (experimental) The number of times that CloudFront attempts to connect to the origin;
         * <p>
         * valid values are 1, 2, or 3 attempts.
         * <p>
         * Default: 3
         * <p>
         * @return {@code this}
         * @param connectionAttempts The number of times that CloudFront attempts to connect to the origin;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionAttempts(final java.lang.Number connectionAttempts) {
            this.props().connectionAttempts(connectionAttempts);
            return this;
        }

        /**
         * (experimental) The number of seconds that CloudFront waits when trying to establish a connection to the origin.
         * <p>
         * Valid values are 1-10 seconds, inclusive.
         * <p>
         * Default: Duration.seconds(10)
         * <p>
         * @return {@code this}
         * @param connectionTimeout The number of seconds that CloudFront waits when trying to establish a connection to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionTimeout(final software.amazon.awscdk.core.Duration connectionTimeout) {
            this.props().connectionTimeout(connectionTimeout);
            return this;
        }

        /**
         * (experimental) A list of HTTP header names and values that CloudFront adds to requests it sends to the origin.
         * <p>
         * Default: {}
         * <p>
         * @return {@code this}
         * @param customHeaders A list of HTTP header names and values that CloudFront adds to requests it sends to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customHeaders(final java.util.Map<java.lang.String, java.lang.String> customHeaders) {
            this.props().customHeaders(customHeaders);
            return this;
        }

        /**
         * (experimental) When you enable Origin Shield in the AWS Region that has the lowest latency to your origin, you can get better network performance.
         * <p>
         * Default: - origin shield not enabled
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html</a>
         * @param originShieldRegion When you enable Origin Shield in the AWS Region that has the lowest latency to your origin, you can get better network performance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originShieldRegion(final java.lang.String originShieldRegion) {
            this.props().originShieldRegion(originShieldRegion);
            return this;
        }

        /**
         * (experimental) An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         * <p>
         * Must begin, but not end, with '/' (e.g., '/production/images').
         * <p>
         * Default: '/'
         * <p>
         * @return {@code this}
         * @param originPath An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originPath(final java.lang.String originPath) {
            this.props().originPath(originPath);
            return this;
        }

        /**
         * (experimental) The HTTP port that CloudFront uses to connect to the origin.
         * <p>
         * Default: 80
         * <p>
         * @return {@code this}
         * @param httpPort The HTTP port that CloudFront uses to connect to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpPort(final java.lang.Number httpPort) {
            this.props().httpPort(httpPort);
            return this;
        }

        /**
         * (experimental) The HTTPS port that CloudFront uses to connect to the origin.
         * <p>
         * Default: 443
         * <p>
         * @return {@code this}
         * @param httpsPort The HTTPS port that CloudFront uses to connect to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpsPort(final java.lang.Number httpsPort) {
            this.props().httpsPort(httpsPort);
            return this;
        }

        /**
         * (experimental) Specifies how long, in seconds, CloudFront persists its connection to the origin.
         * <p>
         * The valid range is from 1 to 180 seconds, inclusive.
         * <p>
         * Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
         * has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
         * <p>
         * Default: Duration.seconds(5)
         * <p>
         * @return {@code this}
         * @param keepaliveTimeout Specifies how long, in seconds, CloudFront persists its connection to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder keepaliveTimeout(final software.amazon.awscdk.core.Duration keepaliveTimeout) {
            this.props().keepaliveTimeout(keepaliveTimeout);
            return this;
        }

        /**
         * (experimental) The SSL versions to use when interacting with the origin.
         * <p>
         * Default: OriginSslPolicy.TLS_V1_2
         * <p>
         * @return {@code this}
         * @param originSslProtocols The SSL versions to use when interacting with the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originSslProtocols(final java.util.List<? extends software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols) {
            this.props().originSslProtocols(originSslProtocols);
            return this;
        }

        /**
         * (experimental) Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin.
         * <p>
         * Default: OriginProtocolPolicy.HTTPS_ONLY
         * <p>
         * @return {@code this}
         * @param protocolPolicy Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder protocolPolicy(final software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy) {
            this.props().protocolPolicy(protocolPolicy);
            return this;
        }

        /**
         * (experimental) Specifies how long, in seconds, CloudFront waits for a response from the origin, also known as the origin response timeout.
         * <p>
         * The valid range is from 1 to 180 seconds, inclusive.
         * <p>
         * Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
         * has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
         * <p>
         * Default: Duration.seconds(30)
         * <p>
         * @return {@code this}
         * @param readTimeout Specifies how long, in seconds, CloudFront waits for a response from the origin, also known as the origin response timeout. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder readTimeout(final software.amazon.awscdk.core.Duration readTimeout) {
            this.props().readTimeout(readTimeout);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudfront.origins.HttpOrigin}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cloudfront.origins.HttpOrigin build() {
            return new software.amazon.awscdk.services.cloudfront.origins.HttpOrigin(
                this.domainName,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudfront.origins.HttpOriginProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudfront.origins.HttpOriginProps.Builder();
            }
            return this.props;
        }
    }
}
