package software.amazon.awscdk.services.cloudfront;

/**
 * (experimental) Represents the function's source code.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket s3Bucket;
 * // Add a cloudfront Function to a Distribution
 * Function cfFunction = Function.Builder.create(this, "Function")
 *         .code(FunctionCode.fromInline("function handler(event) { return event.request }"))
 *         .build();
 * Distribution.Builder.create(this, "distro")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new S3Origin(s3Bucket))
 *                 .functionAssociations(List.of(FunctionAssociation.builder()
 *                         .function(cfFunction)
 *                         .eventType(FunctionEventType.VIEWER_REQUEST)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:55.566Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudfront.FunctionCode")
public abstract class FunctionCode extends software.amazon.jsii.JsiiObject {

    protected FunctionCode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FunctionCode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected FunctionCode() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Code from external file for function.
     * <p>
     * @return code object with contents from file.
     * @param options the options for the external file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.FunctionCode fromFile(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.FileCodeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.FunctionCode.class, "fromFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.FunctionCode.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Inline code for function.
     * <p>
     * @return code object with inline code.
     * @param code The actual function code. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.FunctionCode fromInline(final @org.jetbrains.annotations.NotNull java.lang.String code) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.FunctionCode.class, "fromInline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.FunctionCode.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * (experimental) renders the function code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String render();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.cloudfront.FunctionCode {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) renders the function code.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String render() {
            return software.amazon.jsii.Kernel.call(this, "render", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
