package software.amazon.awscdk.services.batch;

/**
 * (experimental) The log driver to use for the container.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * JobDefinition.Builder.create(this, "job-def")
 *         .container(JobDefinitionContainer.builder()
 *                 .image(EcrImage.fromRegistry("docker/whalesay"))
 *                 .logConfiguration(LogConfiguration.builder()
 *                         .logDriver(LogDriver.AWSLOGS)
 *                         .options(Map.of("awslogs-region", "us-east-1"))
 *                         .secretOptions(List.of(ExposedSecret.fromParametersStore("xyz", StringParameter.fromStringParameterName(this, "parameter", "xyz"))))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.954Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_batch.LogDriver")
public enum LogDriver {
    /**
     * (experimental) Specifies the Amazon CloudWatch Logs logging driver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    AWSLOGS,
    /**
     * (experimental) Specifies the Fluentd logging driver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FLUENTD,
    /**
     * (experimental) Specifies the Graylog Extended Format (GELF) logging driver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GELF,
    /**
     * (experimental) Specifies the journald logging driver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    JOURNALD,
    /**
     * (experimental) Specifies the logentries logging driver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LOGENTRIES,
    /**
     * (experimental) Specifies the JSON file logging driver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    JSON_FILE,
    /**
     * (experimental) Specifies the Splunk logging driver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SPLUNK,
    /**
     * (experimental) Specifies the syslog logging driver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SYSLOG,
}
