package software.amazon.awscdk.services.batch;

/**
 * (experimental) Properties for mapping a compute environment to a job queue.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * ComputeEnvironment computeEnvironment;
 * JobQueueComputeEnvironment jobQueueComputeEnvironment = JobQueueComputeEnvironment.builder()
 *         .computeEnvironment(computeEnvironment)
 *         .order(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.949Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_batch.JobQueueComputeEnvironment")
@software.amazon.jsii.Jsii.Proxy(JobQueueComputeEnvironment.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface JobQueueComputeEnvironment extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The batch compute environment to use for processing submitted jobs to this queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IComputeEnvironment getComputeEnvironment();

    /**
     * (experimental) The order in which this compute environment will be selected for dynamic allocation of resources to process submitted jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getOrder();

    /**
     * @return a {@link Builder} of {@link JobQueueComputeEnvironment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobQueueComputeEnvironment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<JobQueueComputeEnvironment> {
        software.amazon.awscdk.services.batch.IComputeEnvironment computeEnvironment;
        java.lang.Number order;

        /**
         * Sets the value of {@link JobQueueComputeEnvironment#getComputeEnvironment}
         * @param computeEnvironment The batch compute environment to use for processing submitted jobs to this queue. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder computeEnvironment(software.amazon.awscdk.services.batch.IComputeEnvironment computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link JobQueueComputeEnvironment#getOrder}
         * @param order The order in which this compute environment will be selected for dynamic allocation of resources to process submitted jobs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder order(java.lang.Number order) {
            this.order = order;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobQueueComputeEnvironment}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public JobQueueComputeEnvironment build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JobQueueComputeEnvironment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobQueueComputeEnvironment {
        private final software.amazon.awscdk.services.batch.IComputeEnvironment computeEnvironment;
        private final java.lang.Number order;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computeEnvironment = software.amazon.jsii.Kernel.get(this, "computeEnvironment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IComputeEnvironment.class));
            this.order = software.amazon.jsii.Kernel.get(this, "order", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computeEnvironment = java.util.Objects.requireNonNull(builder.computeEnvironment, "computeEnvironment is required");
            this.order = java.util.Objects.requireNonNull(builder.order, "order is required");
        }

        @Override
        public final software.amazon.awscdk.services.batch.IComputeEnvironment getComputeEnvironment() {
            return this.computeEnvironment;
        }

        @Override
        public final java.lang.Number getOrder() {
            return this.order;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("computeEnvironment", om.valueToTree(this.getComputeEnvironment()));
            data.set("order", om.valueToTree(this.getOrder()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_batch.JobQueueComputeEnvironment"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobQueueComputeEnvironment.Jsii$Proxy that = (JobQueueComputeEnvironment.Jsii$Proxy) o;

            if (!computeEnvironment.equals(that.computeEnvironment)) return false;
            return this.order.equals(that.order);
        }

        @Override
        public final int hashCode() {
            int result = this.computeEnvironment.hashCode();
            result = 31 * result + (this.order.hashCode());
            return result;
        }
    }
}
