package software.amazon.awscdk.services.batch;

/**
 * (experimental) Property to specify if the compute environment uses On-Demand, SpotFleet, Fargate, or Fargate Spot compute resources.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc = new Vpc(this, "VPC");
 * ComputeEnvironment spotEnvironment = ComputeEnvironment.Builder.create(this, "MySpotEnvironment")
 *         .computeResources(ComputeResources.builder()
 *                 .type(ComputeResourceType.SPOT)
 *                 .bidPercentage(75) // Bids for resources at 75% of the on-demand price
 *                 .vpc(vpc)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.936Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_batch.ComputeResourceType")
public enum ComputeResourceType {
    /**
     * (experimental) Resources will be EC2 On-Demand resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ON_DEMAND,
    /**
     * (experimental) Resources will be EC2 SpotFleet resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SPOT,
    /**
     * (experimental) Resources will be Fargate resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FARGATE,
    /**
     * (experimental) Resources will be Fargate Spot resources.
     * <p>
     * Fargate Spot uses spare capacity in the AWS cloud to run your fault-tolerant,
     * time-flexible jobs at up to a 70% discount. If AWS needs the resources back,
     * jobs running on Fargate Spot will be interrupted with two minutes of notification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FARGATE_SPOT,
}
