package software.amazon.awscdk.services.backup;

/**
 * (experimental) Properties for a BackupPlan.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * BackupPlan plan = BackupPlan.Builder.create(this, "Plan")
 *         .windowsVss(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.699Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_backup.BackupPlanProps")
@software.amazon.jsii.Jsii.Proxy(BackupPlanProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BackupPlanProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The display name of the backup plan.
     * <p>
     * Default: - A CDK generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBackupPlanName() {
        return null;
    }

    /**
     * (experimental) Rules for the backup plan.
     * <p>
     * Use <code>addRule()</code> to add rules after
     * instantiation.
     * <p>
     * Default: - use `addRule()` to add rules
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.backup.BackupPlanRule> getBackupPlanRules() {
        return null;
    }

    /**
     * (experimental) The backup vault where backups are stored.
     * <p>
     * Default: - use the vault defined at the rule level. If not defined a new
     * common vault for the plan will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.IBackupVault getBackupVault() {
        return null;
    }

    /**
     * (experimental) Enable Windows VSS backup.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html">https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWindowsVss() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BackupPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BackupPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BackupPlanProps> {
        java.lang.String backupPlanName;
        java.util.List<software.amazon.awscdk.services.backup.BackupPlanRule> backupPlanRules;
        software.amazon.awscdk.services.backup.IBackupVault backupVault;
        java.lang.Boolean windowsVss;

        /**
         * Sets the value of {@link BackupPlanProps#getBackupPlanName}
         * @param backupPlanName The display name of the backup plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder backupPlanName(java.lang.String backupPlanName) {
            this.backupPlanName = backupPlanName;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanProps#getBackupPlanRules}
         * @param backupPlanRules Rules for the backup plan.
         *                        Use <code>addRule()</code> to add rules after
         *                        instantiation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder backupPlanRules(java.util.List<? extends software.amazon.awscdk.services.backup.BackupPlanRule> backupPlanRules) {
            this.backupPlanRules = (java.util.List<software.amazon.awscdk.services.backup.BackupPlanRule>)backupPlanRules;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanProps#getBackupVault}
         * @param backupVault The backup vault where backups are stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder backupVault(software.amazon.awscdk.services.backup.IBackupVault backupVault) {
            this.backupVault = backupVault;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanProps#getWindowsVss}
         * @param windowsVss Enable Windows VSS backup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder windowsVss(java.lang.Boolean windowsVss) {
            this.windowsVss = windowsVss;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BackupPlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BackupPlanProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BackupPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupPlanProps {
        private final java.lang.String backupPlanName;
        private final java.util.List<software.amazon.awscdk.services.backup.BackupPlanRule> backupPlanRules;
        private final software.amazon.awscdk.services.backup.IBackupVault backupVault;
        private final java.lang.Boolean windowsVss;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backupPlanName = software.amazon.jsii.Kernel.get(this, "backupPlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.backupPlanRules = software.amazon.jsii.Kernel.get(this, "backupPlanRules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlanRule.class)));
            this.backupVault = software.amazon.jsii.Kernel.get(this, "backupVault", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.IBackupVault.class));
            this.windowsVss = software.amazon.jsii.Kernel.get(this, "windowsVss", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backupPlanName = builder.backupPlanName;
            this.backupPlanRules = (java.util.List<software.amazon.awscdk.services.backup.BackupPlanRule>)builder.backupPlanRules;
            this.backupVault = builder.backupVault;
            this.windowsVss = builder.windowsVss;
        }

        @Override
        public final java.lang.String getBackupPlanName() {
            return this.backupPlanName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.backup.BackupPlanRule> getBackupPlanRules() {
            return this.backupPlanRules;
        }

        @Override
        public final software.amazon.awscdk.services.backup.IBackupVault getBackupVault() {
            return this.backupVault;
        }

        @Override
        public final java.lang.Boolean getWindowsVss() {
            return this.windowsVss;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBackupPlanName() != null) {
                data.set("backupPlanName", om.valueToTree(this.getBackupPlanName()));
            }
            if (this.getBackupPlanRules() != null) {
                data.set("backupPlanRules", om.valueToTree(this.getBackupPlanRules()));
            }
            if (this.getBackupVault() != null) {
                data.set("backupVault", om.valueToTree(this.getBackupVault()));
            }
            if (this.getWindowsVss() != null) {
                data.set("windowsVss", om.valueToTree(this.getWindowsVss()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_backup.BackupPlanProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BackupPlanProps.Jsii$Proxy that = (BackupPlanProps.Jsii$Proxy) o;

            if (this.backupPlanName != null ? !this.backupPlanName.equals(that.backupPlanName) : that.backupPlanName != null) return false;
            if (this.backupPlanRules != null ? !this.backupPlanRules.equals(that.backupPlanRules) : that.backupPlanRules != null) return false;
            if (this.backupVault != null ? !this.backupVault.equals(that.backupVault) : that.backupVault != null) return false;
            return this.windowsVss != null ? this.windowsVss.equals(that.windowsVss) : that.windowsVss == null;
        }

        @Override
        public final int hashCode() {
            int result = this.backupPlanName != null ? this.backupPlanName.hashCode() : 0;
            result = 31 * result + (this.backupPlanRules != null ? this.backupPlanRules.hashCode() : 0);
            result = 31 * result + (this.backupVault != null ? this.backupVault.hashCode() : 0);
            result = 31 * result + (this.windowsVss != null ? this.windowsVss.hashCode() : 0);
            return result;
        }
    }
}
