package software.amazon.awscdk.services.autoscaling;

/**
 * (experimental) LaunchTemplateOverrides is a subproperty of LaunchTemplate that describes an override for a launch template.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.services.ec2.*;
 * InstanceType instanceType;
 * LaunchTemplate launchTemplate;
 * LaunchTemplateOverrides launchTemplateOverrides = LaunchTemplateOverrides.builder()
 *         .instanceType(instanceType)
 *         // the properties below are optional
 *         .launchTemplate(launchTemplate)
 *         .weightedCapacity(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.592Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_autoscaling.LaunchTemplateOverrides")
@software.amazon.jsii.Jsii.Proxy(LaunchTemplateOverrides.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LaunchTemplateOverrides extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The instance type, such as m3.xlarge. You must use an instance type that is supported in your requested Region and Availability Zones.
     * <p>
     * Default: - Do not override instance type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * (experimental) Provides the launch template to be used when launching the instance type.
     * <p>
     * For example, some instance types might
     * require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template
     * that's defined for your mixed instances policy.
     * <p>
     * Default: - Do not override launch template
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ILaunchTemplate getLaunchTemplate() {
        return null;
    }

    /**
     * (experimental) The number of capacity units provided by the specified instance type in terms of virtual CPUs, memory, storage, throughput, or other relative performance characteristic.
     * <p>
     * When a Spot or On-Demand Instance is provisioned, the
     * capacity units count toward the desired capacity. Amazon EC2 Auto Scaling provisions instances until the desired
     * capacity is totally fulfilled, even if this results in an overage. Value must be in the range of 1 to 999.
     * <p>
     * For example, If there are 2 units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only provision
     * an instance with a WeightedCapacity of 5 units, the instance is provisioned, and the desired capacity is exceeded
     * by 3 units.
     * <p>
     * Default: - Do not provide weight
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getWeightedCapacity() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LaunchTemplateOverrides}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LaunchTemplateOverrides}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateOverrides> {
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        software.amazon.awscdk.services.ec2.ILaunchTemplate launchTemplate;
        java.lang.Number weightedCapacity;

        /**
         * Sets the value of {@link LaunchTemplateOverrides#getInstanceType}
         * @param instanceType The instance type, such as m3.xlarge. You must use an instance type that is supported in your requested Region and Availability Zones. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateOverrides#getLaunchTemplate}
         * @param launchTemplate Provides the launch template to be used when launching the instance type.
         *                       For example, some instance types might
         *                       require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template
         *                       that's defined for your mixed instances policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder launchTemplate(software.amazon.awscdk.services.ec2.ILaunchTemplate launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateOverrides#getWeightedCapacity}
         * @param weightedCapacity The number of capacity units provided by the specified instance type in terms of virtual CPUs, memory, storage, throughput, or other relative performance characteristic.
         *                         When a Spot or On-Demand Instance is provisioned, the
         *                         capacity units count toward the desired capacity. Amazon EC2 Auto Scaling provisions instances until the desired
         *                         capacity is totally fulfilled, even if this results in an overage. Value must be in the range of 1 to 999.
         *                         <p>
         *                         For example, If there are 2 units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only provision
         *                         an instance with a WeightedCapacity of 5 units, the instance is provisioned, and the desired capacity is exceeded
         *                         by 3 units.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder weightedCapacity(java.lang.Number weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LaunchTemplateOverrides}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public LaunchTemplateOverrides build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LaunchTemplateOverrides}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateOverrides {
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.ec2.ILaunchTemplate launchTemplate;
        private final java.lang.Number weightedCapacity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.launchTemplate = software.amazon.jsii.Kernel.get(this, "launchTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ILaunchTemplate.class));
            this.weightedCapacity = software.amazon.jsii.Kernel.get(this, "weightedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.launchTemplate = builder.launchTemplate;
            this.weightedCapacity = builder.weightedCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ILaunchTemplate getLaunchTemplate() {
            return this.launchTemplate;
        }

        @Override
        public final java.lang.Number getWeightedCapacity() {
            return this.weightedCapacity;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getLaunchTemplate() != null) {
                data.set("launchTemplate", om.valueToTree(this.getLaunchTemplate()));
            }
            if (this.getWeightedCapacity() != null) {
                data.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_autoscaling.LaunchTemplateOverrides"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LaunchTemplateOverrides.Jsii$Proxy that = (LaunchTemplateOverrides.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (this.launchTemplate != null ? !this.launchTemplate.equals(that.launchTemplate) : that.launchTemplate != null) return false;
            return this.weightedCapacity != null ? this.weightedCapacity.equals(that.weightedCapacity) : that.weightedCapacity == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.launchTemplate != null ? this.launchTemplate.hashCode() : 0);
            result = 31 * result + (this.weightedCapacity != null ? this.weightedCapacity.hashCode() : 0);
            return result;
        }
    }
}
