package software.amazon.awscdk.services.appsync;

/**
 * (experimental) Object Types are types declared by you.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * MappingTemplate dummyRequest;
 * MappingTemplate dummyResponse;
 * ObjectType info = ObjectType.Builder.create("Info")
 *         .definition(Map.of(
 *                 "node", ResolvableField.Builder.create()
 *                         .returnType(GraphqlType.string())
 *                         .args(Map.of(
 *                                 "id", GraphqlType.string()))
 *                         .dataSource(api.addNoneDataSource("none"))
 *                         .requestMappingTemplate(dummyRequest)
 *                         .responseMappingTemplate(dummyResponse)
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:54.248Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.ObjectType")
public class ObjectType extends software.amazon.awscdk.services.appsync.InterfaceType implements software.amazon.awscdk.services.appsync.IIntermediateType {

    protected ObjectType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ObjectType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param name This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ObjectType(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ObjectTypeOptions props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Add a field to this Object Type.
     * <p>
     * Object Types must have both fieldName and field options.
     * <p>
     * @param options the options to add a field. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addField(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AddFieldOptions options) {
        software.amazon.jsii.Kernel.call(this, "addField", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Generate the resolvers linked to this Object Type.
     * <p>
     * @param api This parameter is required.
     * @param fieldName This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Resolver generateResolver(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi api, final @org.jetbrains.annotations.NotNull java.lang.String fieldName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.ResolvableFieldOptions options) {
        return software.amazon.jsii.Kernel.call(this, "generateResolver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Resolver.class), new Object[] { java.util.Objects.requireNonNull(api, "api is required"), java.util.Objects.requireNonNull(fieldName, "fieldName is required"), options });
    }

    /**
     * (experimental) Generate the resolvers linked to this Object Type.
     * <p>
     * @param api This parameter is required.
     * @param fieldName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Resolver generateResolver(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi api, final @org.jetbrains.annotations.NotNull java.lang.String fieldName) {
        return software.amazon.jsii.Kernel.call(this, "generateResolver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Resolver.class), new Object[] { java.util.Objects.requireNonNull(api, "api is required"), java.util.Objects.requireNonNull(fieldName, "fieldName is required") });
    }

    /**
     * (experimental) Generate the string of this object type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The Interface Types this Object Type implements.
     * <p>
     * Default: - no interface types
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.InterfaceType> getInterfaceTypes() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.appsync.InterfaceType>)(software.amazon.jsii.Kernel.get(this, "interfaceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.InterfaceType.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (experimental) The resolvers linked to this data source.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.Resolver> getResolvers() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.appsync.Resolver>)(software.amazon.jsii.Kernel.get(this, "resolvers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Resolver.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (experimental) The resolvers linked to this data source.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setResolvers(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.Resolver> value) {
        software.amazon.jsii.Kernel.set(this, "resolvers", value);
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.appsync.ObjectType}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.ObjectType> {
        /**
         * @return a new instance of {@link Builder}.
         * @param name This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final java.lang.String name) {
            return new Builder(name);
        }

        private final java.lang.String name;
        private final software.amazon.awscdk.services.appsync.ObjectTypeOptions.Builder props;

        private Builder(final java.lang.String name) {
            this.name = name;
            this.props = new software.amazon.awscdk.services.appsync.ObjectTypeOptions.Builder();
        }

        /**
         * (experimental) the attributes of this type.
         * <p>
         * @return {@code this}
         * @param definition the attributes of this type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder definition(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.appsync.IField> definition) {
            this.props.definition(definition);
            return this;
        }

        /**
         * (experimental) the directives for this object type.
         * <p>
         * Default: - no directives
         * <p>
         * @return {@code this}
         * @param directives the directives for this object type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder directives(final java.util.List<? extends software.amazon.awscdk.services.appsync.Directive> directives) {
            this.props.directives(directives);
            return this;
        }

        /**
         * (experimental) The Interface Types this Object Type implements.
         * <p>
         * Default: - no interface types
         * <p>
         * @return {@code this}
         * @param interfaceTypes The Interface Types this Object Type implements. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder interfaceTypes(final java.util.List<? extends software.amazon.awscdk.services.appsync.InterfaceType> interfaceTypes) {
            this.props.interfaceTypes(interfaceTypes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appsync.ObjectType}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.appsync.ObjectType build() {
            return new software.amazon.awscdk.services.appsync.ObjectType(
                this.name,
                this.props.build()
            );
        }
    }
}
