package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Result of binding `Source` into a `Service`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apprunner.*;
 * import software.amazon.awscdk.services.ecr.*;
 * GitHubConnection gitHubConnection;
 * Repository repository;
 * Runtime runtime;
 * SourceConfig sourceConfig = SourceConfig.builder()
 *         .codeRepository(CodeRepositoryProps.builder()
 *                 .codeConfiguration(CodeConfiguration.builder()
 *                         .configurationSource(ConfigurationSourceType.REPOSITORY)
 *                         // the properties below are optional
 *                         .configurationValues(CodeConfigurationValues.builder()
 *                                 .runtime(runtime)
 *                                 // the properties below are optional
 *                                 .buildCommand("buildCommand")
 *                                 .environment(Map.of(
 *                                         "environmentKey", "environment"))
 *                                 .port("port")
 *                                 .startCommand("startCommand")
 *                                 .build())
 *                         .build())
 *                 .connection(gitHubConnection)
 *                 .repositoryUrl("repositoryUrl")
 *                 .sourceCodeVersion(SourceCodeVersion.builder()
 *                         .type("type")
 *                         .value("value")
 *                         .build())
 *                 .build())
 *         .ecrRepository(repository)
 *         .imageRepository(ImageRepository.builder()
 *                 .imageIdentifier("imageIdentifier")
 *                 .imageRepositoryType(ImageRepositoryType.ECR_PUBLIC)
 *                 // the properties below are optional
 *                 .imageConfiguration(ImageConfiguration.builder()
 *                         .environment(Map.of(
 *                                 "environmentKey", "environment"))
 *                         .port(123)
 *                         .startCommand("startCommand")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.916Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.SourceConfig")
@software.amazon.jsii.Jsii.Proxy(SourceConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SourceConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The code repository configuration (mutually exclusive  with `imageRepository`).
     * <p>
     * Default: - no code repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.CodeRepositoryProps getCodeRepository() {
        return null;
    }

    /**
     * (experimental) The ECR repository (required to grant the pull privileges for the iam role).
     * <p>
     * Default: - no ECR repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.IRepository getEcrRepository() {
        return null;
    }

    /**
     * (experimental) The image repository configuration (mutually exclusive  with `codeRepository`).
     * <p>
     * Default: - no image repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.ImageRepository getImageRepository() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SourceConfig> {
        software.amazon.awscdk.services.apprunner.CodeRepositoryProps codeRepository;
        software.amazon.awscdk.services.ecr.IRepository ecrRepository;
        software.amazon.awscdk.services.apprunner.ImageRepository imageRepository;

        /**
         * Sets the value of {@link SourceConfig#getCodeRepository}
         * @param codeRepository The code repository configuration (mutually exclusive  with `imageRepository`).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeRepository(software.amazon.awscdk.services.apprunner.CodeRepositoryProps codeRepository) {
            this.codeRepository = codeRepository;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfig#getEcrRepository}
         * @param ecrRepository The ECR repository (required to grant the pull privileges for the iam role).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ecrRepository(software.amazon.awscdk.services.ecr.IRepository ecrRepository) {
            this.ecrRepository = ecrRepository;
            return this;
        }

        /**
         * Sets the value of {@link SourceConfig#getImageRepository}
         * @param imageRepository The image repository configuration (mutually exclusive  with `codeRepository`).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder imageRepository(software.amazon.awscdk.services.apprunner.ImageRepository imageRepository) {
            this.imageRepository = imageRepository;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SourceConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SourceConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConfig {
        private final software.amazon.awscdk.services.apprunner.CodeRepositoryProps codeRepository;
        private final software.amazon.awscdk.services.ecr.IRepository ecrRepository;
        private final software.amazon.awscdk.services.apprunner.ImageRepository imageRepository;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.codeRepository = software.amazon.jsii.Kernel.get(this, "codeRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.CodeRepositoryProps.class));
            this.ecrRepository = software.amazon.jsii.Kernel.get(this, "ecrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class));
            this.imageRepository = software.amazon.jsii.Kernel.get(this, "imageRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.ImageRepository.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.codeRepository = builder.codeRepository;
            this.ecrRepository = builder.ecrRepository;
            this.imageRepository = builder.imageRepository;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.CodeRepositoryProps getCodeRepository() {
            return this.codeRepository;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.IRepository getEcrRepository() {
            return this.ecrRepository;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.ImageRepository getImageRepository() {
            return this.imageRepository;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCodeRepository() != null) {
                data.set("codeRepository", om.valueToTree(this.getCodeRepository()));
            }
            if (this.getEcrRepository() != null) {
                data.set("ecrRepository", om.valueToTree(this.getEcrRepository()));
            }
            if (this.getImageRepository() != null) {
                data.set("imageRepository", om.valueToTree(this.getImageRepository()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apprunner.SourceConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SourceConfig.Jsii$Proxy that = (SourceConfig.Jsii$Proxy) o;

            if (this.codeRepository != null ? !this.codeRepository.equals(that.codeRepository) : that.codeRepository != null) return false;
            if (this.ecrRepository != null ? !this.ecrRepository.equals(that.ecrRepository) : that.ecrRepository != null) return false;
            return this.imageRepository != null ? this.imageRepository.equals(that.imageRepository) : that.imageRepository == null;
        }

        @Override
        public final int hashCode() {
            int result = this.codeRepository != null ? this.codeRepository.hashCode() : 0;
            result = 31 * result + (this.ecrRepository != null ? this.ecrRepository.hashCode() : 0);
            result = 31 * result + (this.imageRepository != null ? this.imageRepository.hashCode() : 0);
            return result;
        }
    }
}
