package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Properties of the AppRunner Service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * DockerImageAsset imageAsset = DockerImageAsset.Builder.create(this, "ImageAssets")
 *         .directory(join(__dirname, "./docker.assets"))
 *         .build();
 * Service.Builder.create(this, "Service")
 *         .source(Source.fromAsset(AssetProps.builder()
 *                 .imageConfiguration(ImageConfiguration.builder().port(8000).build())
 *                 .asset(imageAsset)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.912Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.ServiceProps")
@software.amazon.jsii.Jsii.Proxy(ServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ServiceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The source of the repository for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.Source getSource();

    /**
     * (experimental) The IAM role that grants the App Runner service access to a source repository.
     * <p>
     * It's required for ECR image repositories (but not for ECR Public repositories).
     * <p>
     * The role must be assumable by the 'build.apprunner.amazonaws.com' service principal.
     * <p>
     * Default: - generate a new access role.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apprunner/latest/dg/security_iam_service-with-iam.html#security_iam_service-with-iam-roles-service.access">https://docs.aws.amazon.com/apprunner/latest/dg/security_iam_service-with-iam.html#security_iam_service-with-iam-roles-service.access</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getAccessRole() {
        return null;
    }

    /**
     * (experimental) The number of CPU units reserved for each instance of your App Runner service.
     * <p>
     * Default: Cpu.ONE_VCPU
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.Cpu getCpu() {
        return null;
    }

    /**
     * (experimental) The IAM role that provides permissions to your App Runner service.
     * <p>
     * These are permissions that your code needs when it calls any AWS APIs.
     * <p>
     * The role must be assumable by the 'tasks.apprunner.amazonaws.com' service principal.
     * <p>
     * Default: - no instance role attached.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apprunner/latest/dg/security_iam_service-with-iam.html#security_iam_service-with-iam-roles-service.instance">https://docs.aws.amazon.com/apprunner/latest/dg/security_iam_service-with-iam.html#security_iam_service-with-iam-roles-service.instance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getInstanceRole() {
        return null;
    }

    /**
     * (experimental) The amount of memory reserved for each instance of your App Runner service.
     * <p>
     * Default: Memory.TWO_GB
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.Memory getMemory() {
        return null;
    }

    /**
     * (experimental) Name of the service.
     * <p>
     * Default: - auto-generated if undefined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return null;
    }

    /**
     * (experimental) Settings for an App Runner VPC connector to associate with the service.
     * <p>
     * Default: - no VPC connector, uses the DEFAULT egress type instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.IVpcConnector getVpcConnector() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceProps> {
        software.amazon.awscdk.services.apprunner.Source source;
        software.amazon.awscdk.services.iam.IRole accessRole;
        software.amazon.awscdk.services.apprunner.Cpu cpu;
        software.amazon.awscdk.services.iam.IRole instanceRole;
        software.amazon.awscdk.services.apprunner.Memory memory;
        java.lang.String serviceName;
        software.amazon.awscdk.services.apprunner.IVpcConnector vpcConnector;

        /**
         * Sets the value of {@link ServiceProps#getSource}
         * @param source The source of the repository for the service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder source(software.amazon.awscdk.services.apprunner.Source source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getAccessRole}
         * @param accessRole The IAM role that grants the App Runner service access to a source repository.
         *                   It's required for ECR image repositories (but not for ECR Public repositories).
         *                   <p>
         *                   The role must be assumable by the 'build.apprunner.amazonaws.com' service principal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessRole(software.amazon.awscdk.services.iam.IRole accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getCpu}
         * @param cpu The number of CPU units reserved for each instance of your App Runner service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cpu(software.amazon.awscdk.services.apprunner.Cpu cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getInstanceRole}
         * @param instanceRole The IAM role that provides permissions to your App Runner service.
         *                     These are permissions that your code needs when it calls any AWS APIs.
         *                     <p>
         *                     The role must be assumable by the 'tasks.apprunner.amazonaws.com' service principal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceRole(software.amazon.awscdk.services.iam.IRole instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getMemory}
         * @param memory The amount of memory reserved for each instance of your App Runner service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memory(software.amazon.awscdk.services.apprunner.Memory memory) {
            this.memory = memory;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getServiceName}
         * @param serviceName Name of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProps#getVpcConnector}
         * @param vpcConnector Settings for an App Runner VPC connector to associate with the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcConnector(software.amazon.awscdk.services.apprunner.IVpcConnector vpcConnector) {
            this.vpcConnector = vpcConnector;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ServiceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceProps {
        private final software.amazon.awscdk.services.apprunner.Source source;
        private final software.amazon.awscdk.services.iam.IRole accessRole;
        private final software.amazon.awscdk.services.apprunner.Cpu cpu;
        private final software.amazon.awscdk.services.iam.IRole instanceRole;
        private final software.amazon.awscdk.services.apprunner.Memory memory;
        private final java.lang.String serviceName;
        private final software.amazon.awscdk.services.apprunner.IVpcConnector vpcConnector;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.Source.class));
            this.accessRole = software.amazon.jsii.Kernel.get(this, "accessRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.Cpu.class));
            this.instanceRole = software.amazon.jsii.Kernel.get(this, "instanceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.Memory.class));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcConnector = software.amazon.jsii.Kernel.get(this, "vpcConnector", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.IVpcConnector.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.accessRole = builder.accessRole;
            this.cpu = builder.cpu;
            this.instanceRole = builder.instanceRole;
            this.memory = builder.memory;
            this.serviceName = builder.serviceName;
            this.vpcConnector = builder.vpcConnector;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.Source getSource() {
            return this.source;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getAccessRole() {
            return this.accessRole;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.Cpu getCpu() {
            return this.cpu;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getInstanceRole() {
            return this.instanceRole;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.Memory getMemory() {
            return this.memory;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.IVpcConnector getVpcConnector() {
            return this.vpcConnector;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("source", om.valueToTree(this.getSource()));
            if (this.getAccessRole() != null) {
                data.set("accessRole", om.valueToTree(this.getAccessRole()));
            }
            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getInstanceRole() != null) {
                data.set("instanceRole", om.valueToTree(this.getInstanceRole()));
            }
            if (this.getMemory() != null) {
                data.set("memory", om.valueToTree(this.getMemory()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }
            if (this.getVpcConnector() != null) {
                data.set("vpcConnector", om.valueToTree(this.getVpcConnector()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apprunner.ServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceProps.Jsii$Proxy that = (ServiceProps.Jsii$Proxy) o;

            if (!source.equals(that.source)) return false;
            if (this.accessRole != null ? !this.accessRole.equals(that.accessRole) : that.accessRole != null) return false;
            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.instanceRole != null ? !this.instanceRole.equals(that.instanceRole) : that.instanceRole != null) return false;
            if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
            return this.vpcConnector != null ? this.vpcConnector.equals(that.vpcConnector) : that.vpcConnector == null;
        }

        @Override
        public final int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + (this.accessRole != null ? this.accessRole.hashCode() : 0);
            result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
            result = 31 * result + (this.instanceRole != null ? this.instanceRole.hashCode() : 0);
            result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.vpcConnector != null ? this.vpcConnector.hashCode() : 0);
            return result;
        }
    }
}
