package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) The App Runner Service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * DockerImageAsset imageAsset = DockerImageAsset.Builder.create(this, "ImageAssets")
 *         .directory(join(__dirname, "./docker.assets"))
 *         .build();
 * Service.Builder.create(this, "Service")
 *         .source(Source.fromAsset(AssetProps.builder()
 *                 .imageConfiguration(ImageConfiguration.builder().port(8000).build())
 *                 .asset(imageAsset)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.909Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.Service")
public class Service extends software.amazon.awscdk.core.Resource {

    protected Service(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Service(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Service(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.ServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import from service attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.IService fromServiceAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.ServiceAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apprunner.Service.class, "fromServiceAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.IService.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Import from service name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param serviceName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.IService fromServiceName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String serviceName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apprunner.Service.class, "fromServiceName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.IService.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(serviceName, "serviceName is required") });
    }

    /**
     * (experimental) The ARN of the Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceArn() {
        return software.amazon.jsii.Kernel.get(this, "serviceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ID of the Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceId() {
        return software.amazon.jsii.Kernel.get(this, "serviceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceName() {
        return software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The status of the Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceStatus() {
        return software.amazon.jsii.Kernel.get(this, "serviceStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The URL of the Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceUrl() {
        return software.amazon.jsii.Kernel.get(this, "serviceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apprunner.Service}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apprunner.Service> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apprunner.ServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apprunner.ServiceProps.Builder();
        }

        /**
         * (experimental) The source of the repository for the service.
         * <p>
         * @return {@code this}
         * @param source The source of the repository for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder source(final software.amazon.awscdk.services.apprunner.Source source) {
            this.props.source(source);
            return this;
        }

        /**
         * (experimental) The IAM role that grants the App Runner service access to a source repository.
         * <p>
         * It's required for ECR image repositories (but not for ECR Public repositories).
         * <p>
         * The role must be assumable by the 'build.apprunner.amazonaws.com' service principal.
         * <p>
         * Default: - generate a new access role.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apprunner/latest/dg/security_iam_service-with-iam.html#security_iam_service-with-iam-roles-service.access">https://docs.aws.amazon.com/apprunner/latest/dg/security_iam_service-with-iam.html#security_iam_service-with-iam-roles-service.access</a>
         * @param accessRole The IAM role that grants the App Runner service access to a source repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessRole(final software.amazon.awscdk.services.iam.IRole accessRole) {
            this.props.accessRole(accessRole);
            return this;
        }

        /**
         * (experimental) The number of CPU units reserved for each instance of your App Runner service.
         * <p>
         * Default: Cpu.ONE_VCPU
         * <p>
         * @return {@code this}
         * @param cpu The number of CPU units reserved for each instance of your App Runner service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cpu(final software.amazon.awscdk.services.apprunner.Cpu cpu) {
            this.props.cpu(cpu);
            return this;
        }

        /**
         * (experimental) The IAM role that provides permissions to your App Runner service.
         * <p>
         * These are permissions that your code needs when it calls any AWS APIs.
         * <p>
         * The role must be assumable by the 'tasks.apprunner.amazonaws.com' service principal.
         * <p>
         * Default: - no instance role attached.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apprunner/latest/dg/security_iam_service-with-iam.html#security_iam_service-with-iam-roles-service.instance">https://docs.aws.amazon.com/apprunner/latest/dg/security_iam_service-with-iam.html#security_iam_service-with-iam-roles-service.instance</a>
         * @param instanceRole The IAM role that provides permissions to your App Runner service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceRole(final software.amazon.awscdk.services.iam.IRole instanceRole) {
            this.props.instanceRole(instanceRole);
            return this;
        }

        /**
         * (experimental) The amount of memory reserved for each instance of your App Runner service.
         * <p>
         * Default: Memory.TWO_GB
         * <p>
         * @return {@code this}
         * @param memory The amount of memory reserved for each instance of your App Runner service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memory(final software.amazon.awscdk.services.apprunner.Memory memory) {
            this.props.memory(memory);
            return this;
        }

        /**
         * (experimental) Name of the service.
         * <p>
         * Default: - auto-generated if undefined.
         * <p>
         * @return {@code this}
         * @param serviceName Name of the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        /**
         * (experimental) Settings for an App Runner VPC connector to associate with the service.
         * <p>
         * Default: - no VPC connector, uses the DEFAULT egress type instead
         * <p>
         * @return {@code this}
         * @param vpcConnector Settings for an App Runner VPC connector to associate with the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcConnector(final software.amazon.awscdk.services.apprunner.IVpcConnector vpcConnector) {
            this.props.vpcConnector(vpcConnector);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apprunner.Service}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apprunner.Service build() {
            return new software.amazon.awscdk.services.apprunner.Service(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
