package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) The code runtimes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Service.Builder.create(this, "Service")
 *         .source(Source.fromGitHub(GithubRepositoryProps.builder()
 *                 .repositoryUrl("https://github.com/aws-containers/hello-app-runner")
 *                 .branch("main")
 *                 .configurationSource(ConfigurationSourceType.API)
 *                 .codeConfigurationValues(CodeConfigurationValues.builder()
 *                         .runtime(Runtime.PYTHON_3)
 *                         .port("8000")
 *                         .startCommand("python app.py")
 *                         .buildCommand("yum install -y pycairo &amp;&amp; pip install -r requirements.txt")
 *                         .build())
 *                 .connection(GitHubConnection.fromConnectionArn("CONNECTION_ARN"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.908Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.Runtime")
public class Runtime extends software.amazon.jsii.JsiiObject {

    protected Runtime(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Runtime(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        NODEJS_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apprunner.Runtime.class, "NODEJS_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.Runtime.class));
        PYTHON_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apprunner.Runtime.class, "PYTHON_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.Runtime.class));
    }

    /**
     * (experimental) Other runtimes.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.</a>
     * @param name runtime name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.Runtime of(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apprunner.Runtime.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.Runtime.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) NodeJS 12.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.apprunner.Runtime NODEJS_12;

    /**
     * (experimental) Python 3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.apprunner.Runtime PYTHON_3;

    /**
     * (experimental) The runtime name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
