package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Properties of the image repository for `Source.fromEcrPublic()`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Service.Builder.create(this, "Service")
 *         .source(Source.fromEcrPublic(EcrPublicProps.builder()
 *                 .imageConfiguration(ImageConfiguration.builder().port(8000).build())
 *                 .imageIdentifier("public.ecr.aws/aws-containers/hello-app-runner:latest")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.895Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.EcrPublicProps")
@software.amazon.jsii.Jsii.Proxy(EcrPublicProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface EcrPublicProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The ECR Public image URI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getImageIdentifier();

    /**
     * (experimental) The image configuration for the image from ECR Public.
     * <p>
     * Default: - no image configuration will be passed. The default `port` will be 8080.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.ImageConfiguration getImageConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcrPublicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcrPublicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<EcrPublicProps> {
        java.lang.String imageIdentifier;
        software.amazon.awscdk.services.apprunner.ImageConfiguration imageConfiguration;

        /**
         * Sets the value of {@link EcrPublicProps#getImageIdentifier}
         * @param imageIdentifier The ECR Public image URI. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder imageIdentifier(java.lang.String imageIdentifier) {
            this.imageIdentifier = imageIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link EcrPublicProps#getImageConfiguration}
         * @param imageConfiguration The image configuration for the image from ECR Public.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder imageConfiguration(software.amazon.awscdk.services.apprunner.ImageConfiguration imageConfiguration) {
            this.imageConfiguration = imageConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcrPublicProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public EcrPublicProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcrPublicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcrPublicProps {
        private final java.lang.String imageIdentifier;
        private final software.amazon.awscdk.services.apprunner.ImageConfiguration imageConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.imageIdentifier = software.amazon.jsii.Kernel.get(this, "imageIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageConfiguration = software.amazon.jsii.Kernel.get(this, "imageConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.ImageConfiguration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.imageIdentifier = java.util.Objects.requireNonNull(builder.imageIdentifier, "imageIdentifier is required");
            this.imageConfiguration = builder.imageConfiguration;
        }

        @Override
        public final java.lang.String getImageIdentifier() {
            return this.imageIdentifier;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.ImageConfiguration getImageConfiguration() {
            return this.imageConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("imageIdentifier", om.valueToTree(this.getImageIdentifier()));
            if (this.getImageConfiguration() != null) {
                data.set("imageConfiguration", om.valueToTree(this.getImageConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apprunner.EcrPublicProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcrPublicProps.Jsii$Proxy that = (EcrPublicProps.Jsii$Proxy) o;

            if (!imageIdentifier.equals(that.imageIdentifier)) return false;
            return this.imageConfiguration != null ? this.imageConfiguration.equals(that.imageConfiguration) : that.imageConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.imageIdentifier.hashCode();
            result = 31 * result + (this.imageConfiguration != null ? this.imageConfiguration.hashCode() : 0);
            return result;
        }
    }
}
