package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Properties of the image repository for `Source.fromEcr()`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Service.Builder.create(this, "Service")
 *         .source(Source.fromEcr(EcrProps.builder()
 *                 .imageConfiguration(ImageConfiguration.builder().port(80).build())
 *                 .repository(Repository.fromRepositoryName(this, "NginxRepository", "nginx"))
 *                 .tagOrDigest("latest")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.894Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.EcrProps")
@software.amazon.jsii.Jsii.Proxy(EcrProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface EcrProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Represents the ECR repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository getRepository();

    /**
     * (experimental) The image configuration for the image from ECR.
     * <p>
     * Default: - no image configuration will be passed. The default `port` will be 8080.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.ImageConfiguration getImageConfiguration() {
        return null;
    }

    /**
     * (deprecated) Image tag.
     * <p>
     * Default: - 'latest'
     * <p>
     * @deprecated use `tagOrDigest`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getTag() {
        return null;
    }

    /**
     * (experimental) Image tag or digest (digests must start with `sha256:`).
     * <p>
     * Default: - 'latest'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getTagOrDigest() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcrProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcrProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<EcrProps> {
        software.amazon.awscdk.services.ecr.IRepository repository;
        software.amazon.awscdk.services.apprunner.ImageConfiguration imageConfiguration;
        java.lang.String tag;
        java.lang.String tagOrDigest;

        /**
         * Sets the value of {@link EcrProps#getRepository}
         * @param repository Represents the ECR repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repository(software.amazon.awscdk.services.ecr.IRepository repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Sets the value of {@link EcrProps#getImageConfiguration}
         * @param imageConfiguration The image configuration for the image from ECR.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder imageConfiguration(software.amazon.awscdk.services.apprunner.ImageConfiguration imageConfiguration) {
            this.imageConfiguration = imageConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link EcrProps#getTag}
         * @param tag Image tag.
         * @return {@code this}
         * @deprecated use `tagOrDigest`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder tag(java.lang.String tag) {
            this.tag = tag;
            return this;
        }

        /**
         * Sets the value of {@link EcrProps#getTagOrDigest}
         * @param tagOrDigest Image tag or digest (digests must start with `sha256:`).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tagOrDigest(java.lang.String tagOrDigest) {
            this.tagOrDigest = tagOrDigest;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcrProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public EcrProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcrProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcrProps {
        private final software.amazon.awscdk.services.ecr.IRepository repository;
        private final software.amazon.awscdk.services.apprunner.ImageConfiguration imageConfiguration;
        private final java.lang.String tag;
        private final java.lang.String tagOrDigest;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class));
            this.imageConfiguration = software.amazon.jsii.Kernel.get(this, "imageConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.ImageConfiguration.class));
            this.tag = software.amazon.jsii.Kernel.get(this, "tag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tagOrDigest = software.amazon.jsii.Kernel.get(this, "tagOrDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.repository = java.util.Objects.requireNonNull(builder.repository, "repository is required");
            this.imageConfiguration = builder.imageConfiguration;
            this.tag = builder.tag;
            this.tagOrDigest = builder.tagOrDigest;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.IRepository getRepository() {
            return this.repository;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.ImageConfiguration getImageConfiguration() {
            return this.imageConfiguration;
        }

        @Override
        public final java.lang.String getTag() {
            return this.tag;
        }

        @Override
        public final java.lang.String getTagOrDigest() {
            return this.tagOrDigest;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("repository", om.valueToTree(this.getRepository()));
            if (this.getImageConfiguration() != null) {
                data.set("imageConfiguration", om.valueToTree(this.getImageConfiguration()));
            }
            if (this.getTag() != null) {
                data.set("tag", om.valueToTree(this.getTag()));
            }
            if (this.getTagOrDigest() != null) {
                data.set("tagOrDigest", om.valueToTree(this.getTagOrDigest()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apprunner.EcrProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcrProps.Jsii$Proxy that = (EcrProps.Jsii$Proxy) o;

            if (!repository.equals(that.repository)) return false;
            if (this.imageConfiguration != null ? !this.imageConfiguration.equals(that.imageConfiguration) : that.imageConfiguration != null) return false;
            if (this.tag != null ? !this.tag.equals(that.tag) : that.tag != null) return false;
            return this.tagOrDigest != null ? this.tagOrDigest.equals(that.tagOrDigest) : that.tagOrDigest == null;
        }

        @Override
        public final int hashCode() {
            int result = this.repository.hashCode();
            result = 31 * result + (this.imageConfiguration != null ? this.imageConfiguration.hashCode() : 0);
            result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
            result = 31 * result + (this.tagOrDigest != null ? this.tagOrDigest.hashCode() : 0);
            return result;
        }
    }
}
