package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) Defines listener for a VirtualNode.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * Vpc vpc = new Vpc(this, "vpc");
 * PrivateDnsNamespace namespace = PrivateDnsNamespace.Builder.create(this, "test-namespace")
 *         .vpc(vpc)
 *         .name("domain.local")
 *         .build();
 * Service service = namespace.createService("Svc");
 * VirtualNode node = mesh.addVirtualNode("virtual-node", VirtualNodeBaseProps.builder()
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(8081)
 *                 .healthCheck(HealthCheck.http(HttpHealthCheckOptions.builder()
 *                         .healthyThreshold(3)
 *                         .interval(Duration.seconds(5)) // minimum
 *                         .path("/health-check-path")
 *                         .timeout(Duration.seconds(2)) // minimum
 *                         .unhealthyThreshold(2)
 *                         .build()))
 *                 .build())))
 *         .accessLog(AccessLog.fromFilePath("/dev/stdout"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.792Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appmesh.VirtualNodeListener")
public abstract class VirtualNodeListener extends software.amazon.jsii.JsiiObject {

    protected VirtualNodeListener(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VirtualNodeListener(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected VirtualNodeListener() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Returns an GRPC Listener for a VirtualNode.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener grpc(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.GrpcVirtualNodeListenerOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "grpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class), new Object[] { props });
    }

    /**
     * (experimental) Returns an GRPC Listener for a VirtualNode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener grpc() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "grpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class));
    }

    /**
     * (experimental) Returns an HTTP Listener for a VirtualNode.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener http(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.HttpVirtualNodeListenerOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "http", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class), new Object[] { props });
    }

    /**
     * (experimental) Returns an HTTP Listener for a VirtualNode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener http() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "http", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class));
    }

    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualNode.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener http2(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.Http2VirtualNodeListenerOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "http2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class), new Object[] { props });
    }

    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualNode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener http2() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "http2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class));
    }

    /**
     * (experimental) Returns an TCP Listener for a VirtualNode.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener tcp(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.TcpVirtualNodeListenerOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "tcp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class), new Object[] { props });
    }

    /**
     * (experimental) Returns an TCP Listener for a VirtualNode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener tcp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "tcp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class));
    }

    /**
     * (experimental) Binds the current object when adding Listener to a VirtualNode.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListenerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.VirtualNodeListener {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Binds the current object when adding Listener to a VirtualNode.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListenerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListenerConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
