package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) Basic configuration properties for a GatewayRoute.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualGateway gateway;
 * VirtualService virtualService;
 * gateway.addGatewayRoute("gateway-route-grpc", GatewayRouteBaseProps.builder()
 *         .routeSpec(GatewayRouteSpec.grpc(GrpcGatewayRouteSpecOptions.builder()
 *                 .routeTarget(virtualService)
 *                 .match(GrpcGatewayRouteMatch.builder()
 *                         .hostname(GatewayRouteHostnameMatch.exactly("example.com"))
 *                         // This disables the default rewrite to virtual service name and retain original request.
 *                         .rewriteRequestHostname(false)
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:53.641Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appmesh.GatewayRouteBaseProps")
@software.amazon.jsii.Jsii.Proxy(GatewayRouteBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GatewayRouteBaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) What protocol the route uses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteSpec getRouteSpec();

    /**
     * (experimental) The name of the GatewayRoute.
     * <p>
     * Default: - an automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getGatewayRouteName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GatewayRouteBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GatewayRouteBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<GatewayRouteBaseProps> {
        software.amazon.awscdk.services.appmesh.GatewayRouteSpec routeSpec;
        java.lang.String gatewayRouteName;

        /**
         * Sets the value of {@link GatewayRouteBaseProps#getRouteSpec}
         * @param routeSpec What protocol the route uses. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder routeSpec(software.amazon.awscdk.services.appmesh.GatewayRouteSpec routeSpec) {
            this.routeSpec = routeSpec;
            return this;
        }

        /**
         * Sets the value of {@link GatewayRouteBaseProps#getGatewayRouteName}
         * @param gatewayRouteName The name of the GatewayRoute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gatewayRouteName(java.lang.String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GatewayRouteBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public GatewayRouteBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GatewayRouteBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayRouteBaseProps {
        private final software.amazon.awscdk.services.appmesh.GatewayRouteSpec routeSpec;
        private final java.lang.String gatewayRouteName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.routeSpec = software.amazon.jsii.Kernel.get(this, "routeSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GatewayRouteSpec.class));
            this.gatewayRouteName = software.amazon.jsii.Kernel.get(this, "gatewayRouteName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routeSpec = java.util.Objects.requireNonNull(builder.routeSpec, "routeSpec is required");
            this.gatewayRouteName = builder.gatewayRouteName;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.GatewayRouteSpec getRouteSpec() {
            return this.routeSpec;
        }

        @Override
        public final java.lang.String getGatewayRouteName() {
            return this.gatewayRouteName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("routeSpec", om.valueToTree(this.getRouteSpec()));
            if (this.getGatewayRouteName() != null) {
                data.set("gatewayRouteName", om.valueToTree(this.getGatewayRouteName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_appmesh.GatewayRouteBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GatewayRouteBaseProps.Jsii$Proxy that = (GatewayRouteBaseProps.Jsii$Proxy) o;

            if (!routeSpec.equals(that.routeSpec)) return false;
            return this.gatewayRouteName != null ? this.gatewayRouteName.equals(that.gatewayRouteName) : that.gatewayRouteName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.routeSpec.hashCode();
            result = 31 * result + (this.gatewayRouteName != null ? this.gatewayRouteName.hashCode() : 0);
            return result;
        }
    }
}
