package software.amazon.awscdk.services.apigatewayv2;

/**
 * (experimental) Options used to add route to the API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.WebSocketLambdaIntegration;
 * Function messageHandler;
 * WebSocketApi webSocketApi = new WebSocketApi(this, "mywsapi");
 * WebSocketStage.Builder.create(this, "mystage")
 *         .webSocketApi(webSocketApi)
 *         .stageName("dev")
 *         .autoDeploy(true)
 *         .build();
 * webSocketApi.addRoute("sendmessage", WebSocketRouteOptions.builder()
 *         .integration(new WebSocketLambdaIntegration("SendMessageIntegration", messageHandler))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:52.822Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apigatewayv2.WebSocketRouteOptions")
@software.amazon.jsii.Jsii.Proxy(WebSocketRouteOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface WebSocketRouteOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The integration to be configured on this route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration getIntegration();

    /**
     * (experimental) The authorize to this route.
     * <p>
     * You can only set authorizer to a $connect route.
     * <p>
     * Default: - No Authorizer
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer getAuthorizer() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WebSocketRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketRouteOptions> {
        software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration integration;
        software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer authorizer;

        /**
         * Sets the value of {@link WebSocketRouteOptions#getIntegration}
         * @param integration The integration to be configured on this route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integration(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration integration) {
            this.integration = integration;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteOptions#getAuthorizer}
         * @param authorizer The authorize to this route.
         *                   You can only set authorizer to a $connect route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorizer(software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketRouteOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public WebSocketRouteOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketRouteOptions {
        private final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration integration;
        private final software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer authorizer;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.integration = software.amazon.jsii.Kernel.get(this, "integration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration.class));
            this.authorizer = software.amazon.jsii.Kernel.get(this, "authorizer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.integration = java.util.Objects.requireNonNull(builder.integration, "integration is required");
            this.authorizer = builder.authorizer;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration getIntegration() {
            return this.integration;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer getAuthorizer() {
            return this.authorizer;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("integration", om.valueToTree(this.getIntegration()));
            if (this.getAuthorizer() != null) {
                data.set("authorizer", om.valueToTree(this.getAuthorizer()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apigatewayv2.WebSocketRouteOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketRouteOptions.Jsii$Proxy that = (WebSocketRouteOptions.Jsii$Proxy) o;

            if (!integration.equals(that.integration)) return false;
            return this.authorizer != null ? this.authorizer.equals(that.authorizer) : that.authorizer == null;
        }

        @Override
        public final int hashCode() {
            int result = this.integration.hashCode();
            result = 31 * result + (this.authorizer != null ? this.authorizer.hashCode() : 0);
            return result;
        }
    }
}
