package software.amazon.awscdk.services.amplifyuibuilder;

/**
 * A CloudFormation `AWS::AmplifyUIBuilder::Form`.
 * <p>
 * Contains the configuration settings for a <code>Form</code> user interface (UI) element for an Amplify app. A form is a component you can add to your project by specifying a data source as the default configuration for the form.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amplifyuibuilder.*;
 * CfnForm cfnForm = CfnForm.Builder.create(this, "MyCfnForm")
 *         .dataType(FormDataTypeConfigProperty.builder()
 *                 .dataSourceType("dataSourceType")
 *                 .dataTypeName("dataTypeName")
 *                 .build())
 *         .fields(Map.of(
 *                 "fieldsKey", FieldConfigProperty.builder()
 *                         .excluded(false)
 *                         .inputType(FieldInputConfigProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .defaultChecked(false)
 *                                 .defaultCountryCode("defaultCountryCode")
 *                                 .defaultValue("defaultValue")
 *                                 .descriptiveText("descriptiveText")
 *                                 .maxValue(123)
 *                                 .minValue(123)
 *                                 .name("name")
 *                                 .placeholder("placeholder")
 *                                 .readOnly(false)
 *                                 .required(false)
 *                                 .step(123)
 *                                 .value("value")
 *                                 .valueMappings(ValueMappingsProperty.builder()
 *                                         .values(List.of(ValueMappingProperty.builder()
 *                                                 .value(FormInputValuePropertyProperty.builder()
 *                                                         .value("value")
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .displayValue(FormInputValuePropertyProperty.builder()
 *                                                         .value("value")
 *                                                         .build())
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .label("label")
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .validations(List.of(FieldValidationConfigurationProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .numValues(List.of(123))
 *                                 .strValues(List.of("strValues"))
 *                                 .validationMessage("validationMessage")
 *                                 .build()))
 *                         .build()))
 *         .formActionType("formActionType")
 *         .name("name")
 *         .schemaVersion("schemaVersion")
 *         .sectionalElements(Map.of(
 *                 "sectionalElementsKey", SectionalElementProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .level(123)
 *                         .orientation("orientation")
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .text("text")
 *                         .build()))
 *         .style(FormStyleProperty.builder()
 *                 .horizontalGap(FormStyleConfigProperty.builder()
 *                         .tokenReference("tokenReference")
 *                         .value("value")
 *                         .build())
 *                 .outerPadding(FormStyleConfigProperty.builder()
 *                         .tokenReference("tokenReference")
 *                         .value("value")
 *                         .build())
 *                 .verticalGap(FormStyleConfigProperty.builder()
 *                         .tokenReference("tokenReference")
 *                         .value("value")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .appId("appId")
 *         .cta(FormCTAProperty.builder()
 *                 .cancel(FormButtonProperty.builder()
 *                         .children("children")
 *                         .excluded(false)
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .build())
 *                 .clear(FormButtonProperty.builder()
 *                         .children("children")
 *                         .excluded(false)
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .build())
 *                 .position("position")
 *                 .submit(FormButtonProperty.builder()
 *                         .children("children")
 *                         .excluded(false)
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .environmentName("environmentName")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.989Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm")
public class CfnForm extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnForm(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnForm(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AmplifyUIBuilder::Form`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnForm(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplifyuibuilder.CfnFormProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * One or more key-value pairs to use when tagging the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The type of data source to use to create the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDataType() {
        return software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The type of data source to use to create the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormDataTypeConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataType", java.util.Objects.requireNonNull(value, "dataType is required"));
    }

    /**
     * The type of data source to use to create the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataType", java.util.Objects.requireNonNull(value, "dataType is required"));
    }

    /**
     * Stores the information about the form's fields.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFields() {
        return software.amazon.jsii.Kernel.get(this, "fields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Stores the information about the form's fields.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFields(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fields", java.util.Objects.requireNonNull(value, "fields is required"));
    }

    /**
     * Stores the information about the form's fields.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFields(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FieldConfigProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FieldConfigProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "fields", java.util.Objects.requireNonNull(value, "fields is required"));
    }

    /**
     * The operation to perform on the specified form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFormActionType() {
        return software.amazon.jsii.Kernel.get(this, "formActionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The operation to perform on the specified form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFormActionType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "formActionType", java.util.Objects.requireNonNull(value, "formActionType is required"));
    }

    /**
     * The name of the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The schema version of the form when it was imported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSchemaVersion() {
        return software.amazon.jsii.Kernel.get(this, "schemaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The schema version of the form when it was imported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchemaVersion(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "schemaVersion", java.util.Objects.requireNonNull(value, "schemaVersion is required"));
    }

    /**
     * Stores the visual helper elements for the form that are not associated with any data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSectionalElements() {
        return software.amazon.jsii.Kernel.get(this, "sectionalElements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Stores the visual helper elements for the form that are not associated with any data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSectionalElements(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sectionalElements", java.util.Objects.requireNonNull(value, "sectionalElements is required"));
    }

    /**
     * Stores the visual helper elements for the form that are not associated with any data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSectionalElements(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.amplifyuibuilder.CfnForm.SectionalElementProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.services.amplifyuibuilder.CfnForm.SectionalElementProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "sectionalElements", java.util.Objects.requireNonNull(value, "sectionalElements is required"));
    }

    /**
     * Stores the configuration for the form's style.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getStyle() {
        return software.amazon.jsii.Kernel.get(this, "style", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Stores the configuration for the form's style.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStyle(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormStyleProperty value) {
        software.amazon.jsii.Kernel.set(this, "style", java.util.Objects.requireNonNull(value, "style is required"));
    }

    /**
     * Stores the configuration for the form's style.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStyle(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "style", java.util.Objects.requireNonNull(value, "style is required"));
    }

    /**
     * The unique ID of the Amplify app associated with the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAppId() {
        return software.amazon.jsii.Kernel.get(this, "appId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID of the Amplify app associated with the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "appId", value);
    }

    /**
     * Stores the call to action configuration for the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCta() {
        return software.amazon.jsii.Kernel.get(this, "cta", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Stores the call to action configuration for the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCta(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormCTAProperty value) {
        software.amazon.jsii.Kernel.set(this, "cta", value);
    }

    /**
     * Stores the call to action configuration for the form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCta(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cta", value);
    }

    /**
     * The name of the backend environment that is a part of the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentName() {
        return software.amazon.jsii.Kernel.get(this, "environmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the backend environment that is a part of the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "environmentName", value);
    }
    /**
     * Describes the configuration information for a field in a table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * FieldConfigProperty fieldConfigProperty = FieldConfigProperty.builder()
     *         .excluded(false)
     *         .inputType(FieldInputConfigProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .defaultChecked(false)
     *                 .defaultCountryCode("defaultCountryCode")
     *                 .defaultValue("defaultValue")
     *                 .descriptiveText("descriptiveText")
     *                 .maxValue(123)
     *                 .minValue(123)
     *                 .name("name")
     *                 .placeholder("placeholder")
     *                 .readOnly(false)
     *                 .required(false)
     *                 .step(123)
     *                 .value("value")
     *                 .valueMappings(ValueMappingsProperty.builder()
     *                         .values(List.of(ValueMappingProperty.builder()
     *                                 .value(FormInputValuePropertyProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .displayValue(FormInputValuePropertyProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .label("label")
     *         .position(FieldPositionProperty.builder()
     *                 .below("below")
     *                 .fixed("fixed")
     *                 .rightOf("rightOf")
     *                 .build())
     *         .validations(List.of(FieldValidationConfigurationProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .numValues(List.of(123))
     *                 .strValues(List.of("strValues"))
     *                 .validationMessage("validationMessage")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm.FieldConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether to hide a field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcluded() {
            return null;
        }

        /**
         * Describes the configuration for the default input value to display for a field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputType() {
            return null;
        }

        /**
         * The label for the field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
            return null;
        }

        /**
         * Specifies the field position.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPosition() {
            return null;
        }

        /**
         * The validations to perform on the value in the field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValidations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FieldConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldConfigProperty> {
            java.lang.Object excluded;
            java.lang.Object inputType;
            java.lang.String label;
            java.lang.Object position;
            java.lang.Object validations;

            /**
             * Sets the value of {@link FieldConfigProperty#getExcluded}
             * @param excluded Specifies whether to hide a field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excluded(java.lang.Boolean excluded) {
                this.excluded = excluded;
                return this;
            }

            /**
             * Sets the value of {@link FieldConfigProperty#getExcluded}
             * @param excluded Specifies whether to hide a field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excluded(software.amazon.awscdk.core.IResolvable excluded) {
                this.excluded = excluded;
                return this;
            }

            /**
             * Sets the value of {@link FieldConfigProperty#getInputType}
             * @param inputType Describes the configuration for the default input value to display for a field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputType(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FieldInputConfigProperty inputType) {
                this.inputType = inputType;
                return this;
            }

            /**
             * Sets the value of {@link FieldConfigProperty#getInputType}
             * @param inputType Describes the configuration for the default input value to display for a field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputType(software.amazon.awscdk.core.IResolvable inputType) {
                this.inputType = inputType;
                return this;
            }

            /**
             * Sets the value of {@link FieldConfigProperty#getLabel}
             * @param label The label for the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder label(java.lang.String label) {
                this.label = label;
                return this;
            }

            /**
             * Sets the value of {@link FieldConfigProperty#getPosition}
             * @param position Specifies the field position.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder position(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FieldPositionProperty position) {
                this.position = position;
                return this;
            }

            /**
             * Sets the value of {@link FieldConfigProperty#getPosition}
             * @param position Specifies the field position.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder position(software.amazon.awscdk.core.IResolvable position) {
                this.position = position;
                return this;
            }

            /**
             * Sets the value of {@link FieldConfigProperty#getValidations}
             * @param validations The validations to perform on the value in the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validations(software.amazon.awscdk.core.IResolvable validations) {
                this.validations = validations;
                return this;
            }

            /**
             * Sets the value of {@link FieldConfigProperty#getValidations}
             * @param validations The validations to perform on the value in the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validations(java.util.List<? extends java.lang.Object> validations) {
                this.validations = validations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldConfigProperty {
            private final java.lang.Object excluded;
            private final java.lang.Object inputType;
            private final java.lang.String label;
            private final java.lang.Object position;
            private final java.lang.Object validations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.excluded = software.amazon.jsii.Kernel.get(this, "excluded", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputType = software.amazon.jsii.Kernel.get(this, "inputType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.position = software.amazon.jsii.Kernel.get(this, "position", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.validations = software.amazon.jsii.Kernel.get(this, "validations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.excluded = builder.excluded;
                this.inputType = builder.inputType;
                this.label = builder.label;
                this.position = builder.position;
                this.validations = builder.validations;
            }

            @Override
            public final java.lang.Object getExcluded() {
                return this.excluded;
            }

            @Override
            public final java.lang.Object getInputType() {
                return this.inputType;
            }

            @Override
            public final java.lang.String getLabel() {
                return this.label;
            }

            @Override
            public final java.lang.Object getPosition() {
                return this.position;
            }

            @Override
            public final java.lang.Object getValidations() {
                return this.validations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExcluded() != null) {
                    data.set("excluded", om.valueToTree(this.getExcluded()));
                }
                if (this.getInputType() != null) {
                    data.set("inputType", om.valueToTree(this.getInputType()));
                }
                if (this.getLabel() != null) {
                    data.set("label", om.valueToTree(this.getLabel()));
                }
                if (this.getPosition() != null) {
                    data.set("position", om.valueToTree(this.getPosition()));
                }
                if (this.getValidations() != null) {
                    data.set("validations", om.valueToTree(this.getValidations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnForm.FieldConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldConfigProperty.Jsii$Proxy that = (FieldConfigProperty.Jsii$Proxy) o;

                if (this.excluded != null ? !this.excluded.equals(that.excluded) : that.excluded != null) return false;
                if (this.inputType != null ? !this.inputType.equals(that.inputType) : that.inputType != null) return false;
                if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
                if (this.position != null ? !this.position.equals(that.position) : that.position != null) return false;
                return this.validations != null ? this.validations.equals(that.validations) : that.validations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.excluded != null ? this.excluded.hashCode() : 0;
                result = 31 * result + (this.inputType != null ? this.inputType.hashCode() : 0);
                result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
                result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
                result = 31 * result + (this.validations != null ? this.validations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the configuration for the default input values to display for a field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * FieldInputConfigProperty fieldInputConfigProperty = FieldInputConfigProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .defaultChecked(false)
     *         .defaultCountryCode("defaultCountryCode")
     *         .defaultValue("defaultValue")
     *         .descriptiveText("descriptiveText")
     *         .maxValue(123)
     *         .minValue(123)
     *         .name("name")
     *         .placeholder("placeholder")
     *         .readOnly(false)
     *         .required(false)
     *         .step(123)
     *         .value("value")
     *         .valueMappings(ValueMappingsProperty.builder()
     *                 .values(List.of(ValueMappingProperty.builder()
     *                         .value(FormInputValuePropertyProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         // the properties below are optional
     *                         .displayValue(FormInputValuePropertyProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm.FieldInputConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldInputConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldInputConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The input type for the field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Specifies whether a field has a default value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultChecked() {
            return null;
        }

        /**
         * The default country code for a phone number.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultCountryCode() {
            return null;
        }

        /**
         * The default value for the field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultValue() {
            return null;
        }

        /**
         * The text to display to describe the field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescriptiveText() {
            return null;
        }

        /**
         * The maximum value to display for the field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxValue() {
            return null;
        }

        /**
         * The minimum value to display for the field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinValue() {
            return null;
        }

        /**
         * The name of the field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The text to display as a placeholder for the field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPlaceholder() {
            return null;
        }

        /**
         * Specifies a read only field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnly() {
            return null;
        }

        /**
         * Specifies a field that requires input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequired() {
            return null;
        }

        /**
         * The stepping increment for a numeric value in a field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStep() {
            return null;
        }

        /**
         * The value for the field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * The information to use to customize the input fields with data at runtime.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValueMappings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FieldInputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldInputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldInputConfigProperty> {
            java.lang.String type;
            java.lang.Object defaultChecked;
            java.lang.String defaultCountryCode;
            java.lang.String defaultValue;
            java.lang.String descriptiveText;
            java.lang.Number maxValue;
            java.lang.Number minValue;
            java.lang.String name;
            java.lang.String placeholder;
            java.lang.Object readOnly;
            java.lang.Object required;
            java.lang.Number step;
            java.lang.String value;
            java.lang.Object valueMappings;

            /**
             * Sets the value of {@link FieldInputConfigProperty#getType}
             * @param type The input type for the field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getDefaultChecked}
             * @param defaultChecked Specifies whether a field has a default value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultChecked(java.lang.Boolean defaultChecked) {
                this.defaultChecked = defaultChecked;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getDefaultChecked}
             * @param defaultChecked Specifies whether a field has a default value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultChecked(software.amazon.awscdk.core.IResolvable defaultChecked) {
                this.defaultChecked = defaultChecked;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getDefaultCountryCode}
             * @param defaultCountryCode The default country code for a phone number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultCountryCode(java.lang.String defaultCountryCode) {
                this.defaultCountryCode = defaultCountryCode;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getDefaultValue}
             * @param defaultValue The default value for the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getDescriptiveText}
             * @param descriptiveText The text to display to describe the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder descriptiveText(java.lang.String descriptiveText) {
                this.descriptiveText = descriptiveText;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getMaxValue}
             * @param maxValue The maximum value to display for the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxValue(java.lang.Number maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getMinValue}
             * @param minValue The minimum value to display for the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minValue(java.lang.Number minValue) {
                this.minValue = minValue;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getName}
             * @param name The name of the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getPlaceholder}
             * @param placeholder The text to display as a placeholder for the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placeholder(java.lang.String placeholder) {
                this.placeholder = placeholder;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getReadOnly}
             * @param readOnly Specifies a read only field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(java.lang.Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getReadOnly}
             * @param readOnly Specifies a read only field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(software.amazon.awscdk.core.IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getRequired}
             * @param required Specifies a field that requires input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(java.lang.Boolean required) {
                this.required = required;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getRequired}
             * @param required Specifies a field that requires input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(software.amazon.awscdk.core.IResolvable required) {
                this.required = required;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getStep}
             * @param step The stepping increment for a numeric value in a field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder step(java.lang.Number step) {
                this.step = step;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getValue}
             * @param value The value for the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getValueMappings}
             * @param valueMappings The information to use to customize the input fields with data at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueMappings(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.ValueMappingsProperty valueMappings) {
                this.valueMappings = valueMappings;
                return this;
            }

            /**
             * Sets the value of {@link FieldInputConfigProperty#getValueMappings}
             * @param valueMappings The information to use to customize the input fields with data at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueMappings(software.amazon.awscdk.core.IResolvable valueMappings) {
                this.valueMappings = valueMappings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldInputConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldInputConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldInputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldInputConfigProperty {
            private final java.lang.String type;
            private final java.lang.Object defaultChecked;
            private final java.lang.String defaultCountryCode;
            private final java.lang.String defaultValue;
            private final java.lang.String descriptiveText;
            private final java.lang.Number maxValue;
            private final java.lang.Number minValue;
            private final java.lang.String name;
            private final java.lang.String placeholder;
            private final java.lang.Object readOnly;
            private final java.lang.Object required;
            private final java.lang.Number step;
            private final java.lang.String value;
            private final java.lang.Object valueMappings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultChecked = software.amazon.jsii.Kernel.get(this, "defaultChecked", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultCountryCode = software.amazon.jsii.Kernel.get(this, "defaultCountryCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.descriptiveText = software.amazon.jsii.Kernel.get(this, "descriptiveText", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxValue = software.amazon.jsii.Kernel.get(this, "maxValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minValue = software.amazon.jsii.Kernel.get(this, "minValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.placeholder = software.amazon.jsii.Kernel.get(this, "placeholder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.required = software.amazon.jsii.Kernel.get(this, "required", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.step = software.amazon.jsii.Kernel.get(this, "step", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueMappings = software.amazon.jsii.Kernel.get(this, "valueMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.defaultChecked = builder.defaultChecked;
                this.defaultCountryCode = builder.defaultCountryCode;
                this.defaultValue = builder.defaultValue;
                this.descriptiveText = builder.descriptiveText;
                this.maxValue = builder.maxValue;
                this.minValue = builder.minValue;
                this.name = builder.name;
                this.placeholder = builder.placeholder;
                this.readOnly = builder.readOnly;
                this.required = builder.required;
                this.step = builder.step;
                this.value = builder.value;
                this.valueMappings = builder.valueMappings;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getDefaultChecked() {
                return this.defaultChecked;
            }

            @Override
            public final java.lang.String getDefaultCountryCode() {
                return this.defaultCountryCode;
            }

            @Override
            public final java.lang.String getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            public final java.lang.String getDescriptiveText() {
                return this.descriptiveText;
            }

            @Override
            public final java.lang.Number getMaxValue() {
                return this.maxValue;
            }

            @Override
            public final java.lang.Number getMinValue() {
                return this.minValue;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getPlaceholder() {
                return this.placeholder;
            }

            @Override
            public final java.lang.Object getReadOnly() {
                return this.readOnly;
            }

            @Override
            public final java.lang.Object getRequired() {
                return this.required;
            }

            @Override
            public final java.lang.Number getStep() {
                return this.step;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            public final java.lang.Object getValueMappings() {
                return this.valueMappings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getDefaultChecked() != null) {
                    data.set("defaultChecked", om.valueToTree(this.getDefaultChecked()));
                }
                if (this.getDefaultCountryCode() != null) {
                    data.set("defaultCountryCode", om.valueToTree(this.getDefaultCountryCode()));
                }
                if (this.getDefaultValue() != null) {
                    data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
                }
                if (this.getDescriptiveText() != null) {
                    data.set("descriptiveText", om.valueToTree(this.getDescriptiveText()));
                }
                if (this.getMaxValue() != null) {
                    data.set("maxValue", om.valueToTree(this.getMaxValue()));
                }
                if (this.getMinValue() != null) {
                    data.set("minValue", om.valueToTree(this.getMinValue()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getPlaceholder() != null) {
                    data.set("placeholder", om.valueToTree(this.getPlaceholder()));
                }
                if (this.getReadOnly() != null) {
                    data.set("readOnly", om.valueToTree(this.getReadOnly()));
                }
                if (this.getRequired() != null) {
                    data.set("required", om.valueToTree(this.getRequired()));
                }
                if (this.getStep() != null) {
                    data.set("step", om.valueToTree(this.getStep()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }
                if (this.getValueMappings() != null) {
                    data.set("valueMappings", om.valueToTree(this.getValueMappings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnForm.FieldInputConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldInputConfigProperty.Jsii$Proxy that = (FieldInputConfigProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.defaultChecked != null ? !this.defaultChecked.equals(that.defaultChecked) : that.defaultChecked != null) return false;
                if (this.defaultCountryCode != null ? !this.defaultCountryCode.equals(that.defaultCountryCode) : that.defaultCountryCode != null) return false;
                if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
                if (this.descriptiveText != null ? !this.descriptiveText.equals(that.descriptiveText) : that.descriptiveText != null) return false;
                if (this.maxValue != null ? !this.maxValue.equals(that.maxValue) : that.maxValue != null) return false;
                if (this.minValue != null ? !this.minValue.equals(that.minValue) : that.minValue != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.placeholder != null ? !this.placeholder.equals(that.placeholder) : that.placeholder != null) return false;
                if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
                if (this.required != null ? !this.required.equals(that.required) : that.required != null) return false;
                if (this.step != null ? !this.step.equals(that.step) : that.step != null) return false;
                if (this.value != null ? !this.value.equals(that.value) : that.value != null) return false;
                return this.valueMappings != null ? this.valueMappings.equals(that.valueMappings) : that.valueMappings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.defaultChecked != null ? this.defaultChecked.hashCode() : 0);
                result = 31 * result + (this.defaultCountryCode != null ? this.defaultCountryCode.hashCode() : 0);
                result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                result = 31 * result + (this.descriptiveText != null ? this.descriptiveText.hashCode() : 0);
                result = 31 * result + (this.maxValue != null ? this.maxValue.hashCode() : 0);
                result = 31 * result + (this.minValue != null ? this.minValue.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.placeholder != null ? this.placeholder.hashCode() : 0);
                result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
                result = 31 * result + (this.required != null ? this.required.hashCode() : 0);
                result = 31 * result + (this.step != null ? this.step.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                result = 31 * result + (this.valueMappings != null ? this.valueMappings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the field position.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * FieldPositionProperty fieldPositionProperty = FieldPositionProperty.builder()
     *         .below("below")
     *         .fixed("fixed")
     *         .rightOf("rightOf")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm.FieldPositionProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldPositionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldPositionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The field position is below the field specified by the string.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBelow() {
            return null;
        }

        /**
         * The field position is fixed and doesn't change in relation to other fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFixed() {
            return null;
        }

        /**
         * The field position is to the right of the field specified by the string.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRightOf() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FieldPositionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldPositionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldPositionProperty> {
            java.lang.String below;
            java.lang.String fixed;
            java.lang.String rightOf;

            /**
             * Sets the value of {@link FieldPositionProperty#getBelow}
             * @param below The field position is below the field specified by the string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder below(java.lang.String below) {
                this.below = below;
                return this;
            }

            /**
             * Sets the value of {@link FieldPositionProperty#getFixed}
             * @param fixed The field position is fixed and doesn't change in relation to other fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixed(java.lang.String fixed) {
                this.fixed = fixed;
                return this;
            }

            /**
             * Sets the value of {@link FieldPositionProperty#getRightOf}
             * @param rightOf The field position is to the right of the field specified by the string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightOf(java.lang.String rightOf) {
                this.rightOf = rightOf;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldPositionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldPositionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldPositionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldPositionProperty {
            private final java.lang.String below;
            private final java.lang.String fixed;
            private final java.lang.String rightOf;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.below = software.amazon.jsii.Kernel.get(this, "below", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fixed = software.amazon.jsii.Kernel.get(this, "fixed", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rightOf = software.amazon.jsii.Kernel.get(this, "rightOf", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.below = builder.below;
                this.fixed = builder.fixed;
                this.rightOf = builder.rightOf;
            }

            @Override
            public final java.lang.String getBelow() {
                return this.below;
            }

            @Override
            public final java.lang.String getFixed() {
                return this.fixed;
            }

            @Override
            public final java.lang.String getRightOf() {
                return this.rightOf;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBelow() != null) {
                    data.set("below", om.valueToTree(this.getBelow()));
                }
                if (this.getFixed() != null) {
                    data.set("fixed", om.valueToTree(this.getFixed()));
                }
                if (this.getRightOf() != null) {
                    data.set("rightOf", om.valueToTree(this.getRightOf()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnForm.FieldPositionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldPositionProperty.Jsii$Proxy that = (FieldPositionProperty.Jsii$Proxy) o;

                if (this.below != null ? !this.below.equals(that.below) : that.below != null) return false;
                if (this.fixed != null ? !this.fixed.equals(that.fixed) : that.fixed != null) return false;
                return this.rightOf != null ? this.rightOf.equals(that.rightOf) : that.rightOf == null;
            }

            @Override
            public final int hashCode() {
                int result = this.below != null ? this.below.hashCode() : 0;
                result = 31 * result + (this.fixed != null ? this.fixed.hashCode() : 0);
                result = 31 * result + (this.rightOf != null ? this.rightOf.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the validation configuration for a field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * FieldValidationConfigurationProperty fieldValidationConfigurationProperty = FieldValidationConfigurationProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .numValues(List.of(123))
     *         .strValues(List.of("strValues"))
     *         .validationMessage("validationMessage")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm.FieldValidationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldValidationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldValidationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The validation to perform on an object type.
         * <p>
         * ``
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The validation to perform on a number value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNumValues() {
            return null;
        }

        /**
         * The validation to perform on a string value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStrValues() {
            return null;
        }

        /**
         * The validation message to display.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValidationMessage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FieldValidationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldValidationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldValidationConfigurationProperty> {
            java.lang.String type;
            java.lang.Object numValues;
            java.util.List<java.lang.String> strValues;
            java.lang.String validationMessage;

            /**
             * Sets the value of {@link FieldValidationConfigurationProperty#getType}
             * @param type The validation to perform on an object type. This parameter is required.
             *             ``
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link FieldValidationConfigurationProperty#getNumValues}
             * @param numValues The validation to perform on a number value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numValues(software.amazon.awscdk.core.IResolvable numValues) {
                this.numValues = numValues;
                return this;
            }

            /**
             * Sets the value of {@link FieldValidationConfigurationProperty#getNumValues}
             * @param numValues The validation to perform on a number value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numValues(java.util.List<? extends java.lang.Number> numValues) {
                this.numValues = numValues;
                return this;
            }

            /**
             * Sets the value of {@link FieldValidationConfigurationProperty#getStrValues}
             * @param strValues The validation to perform on a string value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strValues(java.util.List<java.lang.String> strValues) {
                this.strValues = strValues;
                return this;
            }

            /**
             * Sets the value of {@link FieldValidationConfigurationProperty#getValidationMessage}
             * @param validationMessage The validation message to display.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationMessage(java.lang.String validationMessage) {
                this.validationMessage = validationMessage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldValidationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldValidationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldValidationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldValidationConfigurationProperty {
            private final java.lang.String type;
            private final java.lang.Object numValues;
            private final java.util.List<java.lang.String> strValues;
            private final java.lang.String validationMessage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.numValues = software.amazon.jsii.Kernel.get(this, "numValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.strValues = software.amazon.jsii.Kernel.get(this, "strValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.validationMessage = software.amazon.jsii.Kernel.get(this, "validationMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.numValues = builder.numValues;
                this.strValues = builder.strValues;
                this.validationMessage = builder.validationMessage;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getNumValues() {
                return this.numValues;
            }

            @Override
            public final java.util.List<java.lang.String> getStrValues() {
                return this.strValues;
            }

            @Override
            public final java.lang.String getValidationMessage() {
                return this.validationMessage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getNumValues() != null) {
                    data.set("numValues", om.valueToTree(this.getNumValues()));
                }
                if (this.getStrValues() != null) {
                    data.set("strValues", om.valueToTree(this.getStrValues()));
                }
                if (this.getValidationMessage() != null) {
                    data.set("validationMessage", om.valueToTree(this.getValidationMessage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnForm.FieldValidationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldValidationConfigurationProperty.Jsii$Proxy that = (FieldValidationConfigurationProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.numValues != null ? !this.numValues.equals(that.numValues) : that.numValues != null) return false;
                if (this.strValues != null ? !this.strValues.equals(that.strValues) : that.strValues != null) return false;
                return this.validationMessage != null ? this.validationMessage.equals(that.validationMessage) : that.validationMessage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.numValues != null ? this.numValues.hashCode() : 0);
                result = 31 * result + (this.strValues != null ? this.strValues.hashCode() : 0);
                result = 31 * result + (this.validationMessage != null ? this.validationMessage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the configuration for a button UI element that is a part of a form.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * FormButtonProperty formButtonProperty = FormButtonProperty.builder()
     *         .children("children")
     *         .excluded(false)
     *         .position(FieldPositionProperty.builder()
     *                 .below("below")
     *                 .fixed("fixed")
     *                 .rightOf("rightOf")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm.FormButtonProperty")
    @software.amazon.jsii.Jsii.Proxy(FormButtonProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FormButtonProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the button's properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getChildren() {
            return null;
        }

        /**
         * Specifies whether the button is visible on the form.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcluded() {
            return null;
        }

        /**
         * The position of the button.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPosition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FormButtonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FormButtonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FormButtonProperty> {
            java.lang.String children;
            java.lang.Object excluded;
            java.lang.Object position;

            /**
             * Sets the value of {@link FormButtonProperty#getChildren}
             * @param children Describes the button's properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder children(java.lang.String children) {
                this.children = children;
                return this;
            }

            /**
             * Sets the value of {@link FormButtonProperty#getExcluded}
             * @param excluded Specifies whether the button is visible on the form.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excluded(java.lang.Boolean excluded) {
                this.excluded = excluded;
                return this;
            }

            /**
             * Sets the value of {@link FormButtonProperty#getExcluded}
             * @param excluded Specifies whether the button is visible on the form.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excluded(software.amazon.awscdk.core.IResolvable excluded) {
                this.excluded = excluded;
                return this;
            }

            /**
             * Sets the value of {@link FormButtonProperty#getPosition}
             * @param position The position of the button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder position(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FieldPositionProperty position) {
                this.position = position;
                return this;
            }

            /**
             * Sets the value of {@link FormButtonProperty#getPosition}
             * @param position The position of the button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder position(software.amazon.awscdk.core.IResolvable position) {
                this.position = position;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FormButtonProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FormButtonProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FormButtonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FormButtonProperty {
            private final java.lang.String children;
            private final java.lang.Object excluded;
            private final java.lang.Object position;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.children = software.amazon.jsii.Kernel.get(this, "children", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excluded = software.amazon.jsii.Kernel.get(this, "excluded", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.position = software.amazon.jsii.Kernel.get(this, "position", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.children = builder.children;
                this.excluded = builder.excluded;
                this.position = builder.position;
            }

            @Override
            public final java.lang.String getChildren() {
                return this.children;
            }

            @Override
            public final java.lang.Object getExcluded() {
                return this.excluded;
            }

            @Override
            public final java.lang.Object getPosition() {
                return this.position;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getChildren() != null) {
                    data.set("children", om.valueToTree(this.getChildren()));
                }
                if (this.getExcluded() != null) {
                    data.set("excluded", om.valueToTree(this.getExcluded()));
                }
                if (this.getPosition() != null) {
                    data.set("position", om.valueToTree(this.getPosition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnForm.FormButtonProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FormButtonProperty.Jsii$Proxy that = (FormButtonProperty.Jsii$Proxy) o;

                if (this.children != null ? !this.children.equals(that.children) : that.children != null) return false;
                if (this.excluded != null ? !this.excluded.equals(that.excluded) : that.excluded != null) return false;
                return this.position != null ? this.position.equals(that.position) : that.position == null;
            }

            @Override
            public final int hashCode() {
                int result = this.children != null ? this.children.hashCode() : 0;
                result = 31 * result + (this.excluded != null ? this.excluded.hashCode() : 0);
                result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the call to action button configuration for the form.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * FormCTAProperty formCTAProperty = FormCTAProperty.builder()
     *         .cancel(FormButtonProperty.builder()
     *                 .children("children")
     *                 .excluded(false)
     *                 .position(FieldPositionProperty.builder()
     *                         .below("below")
     *                         .fixed("fixed")
     *                         .rightOf("rightOf")
     *                         .build())
     *                 .build())
     *         .clear(FormButtonProperty.builder()
     *                 .children("children")
     *                 .excluded(false)
     *                 .position(FieldPositionProperty.builder()
     *                         .below("below")
     *                         .fixed("fixed")
     *                         .rightOf("rightOf")
     *                         .build())
     *                 .build())
     *         .position("position")
     *         .submit(FormButtonProperty.builder()
     *                 .children("children")
     *                 .excluded(false)
     *                 .position(FieldPositionProperty.builder()
     *                         .below("below")
     *                         .fixed("fixed")
     *                         .rightOf("rightOf")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm.FormCTAProperty")
    @software.amazon.jsii.Jsii.Proxy(FormCTAProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FormCTAProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Displays a cancel button.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCancel() {
            return null;
        }

        /**
         * Displays a clear button.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClear() {
            return null;
        }

        /**
         * The position of the button.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPosition() {
            return null;
        }

        /**
         * Displays a submit button.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubmit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FormCTAProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FormCTAProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FormCTAProperty> {
            java.lang.Object cancel;
            java.lang.Object clear;
            java.lang.String position;
            java.lang.Object submit;

            /**
             * Sets the value of {@link FormCTAProperty#getCancel}
             * @param cancel Displays a cancel button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cancel(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormButtonProperty cancel) {
                this.cancel = cancel;
                return this;
            }

            /**
             * Sets the value of {@link FormCTAProperty#getCancel}
             * @param cancel Displays a cancel button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cancel(software.amazon.awscdk.core.IResolvable cancel) {
                this.cancel = cancel;
                return this;
            }

            /**
             * Sets the value of {@link FormCTAProperty#getClear}
             * @param clear Displays a clear button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clear(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormButtonProperty clear) {
                this.clear = clear;
                return this;
            }

            /**
             * Sets the value of {@link FormCTAProperty#getClear}
             * @param clear Displays a clear button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clear(software.amazon.awscdk.core.IResolvable clear) {
                this.clear = clear;
                return this;
            }

            /**
             * Sets the value of {@link FormCTAProperty#getPosition}
             * @param position The position of the button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder position(java.lang.String position) {
                this.position = position;
                return this;
            }

            /**
             * Sets the value of {@link FormCTAProperty#getSubmit}
             * @param submit Displays a submit button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder submit(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormButtonProperty submit) {
                this.submit = submit;
                return this;
            }

            /**
             * Sets the value of {@link FormCTAProperty#getSubmit}
             * @param submit Displays a submit button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder submit(software.amazon.awscdk.core.IResolvable submit) {
                this.submit = submit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FormCTAProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FormCTAProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FormCTAProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FormCTAProperty {
            private final java.lang.Object cancel;
            private final java.lang.Object clear;
            private final java.lang.String position;
            private final java.lang.Object submit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cancel = software.amazon.jsii.Kernel.get(this, "cancel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clear = software.amazon.jsii.Kernel.get(this, "clear", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.position = software.amazon.jsii.Kernel.get(this, "position", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.submit = software.amazon.jsii.Kernel.get(this, "submit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cancel = builder.cancel;
                this.clear = builder.clear;
                this.position = builder.position;
                this.submit = builder.submit;
            }

            @Override
            public final java.lang.Object getCancel() {
                return this.cancel;
            }

            @Override
            public final java.lang.Object getClear() {
                return this.clear;
            }

            @Override
            public final java.lang.String getPosition() {
                return this.position;
            }

            @Override
            public final java.lang.Object getSubmit() {
                return this.submit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCancel() != null) {
                    data.set("cancel", om.valueToTree(this.getCancel()));
                }
                if (this.getClear() != null) {
                    data.set("clear", om.valueToTree(this.getClear()));
                }
                if (this.getPosition() != null) {
                    data.set("position", om.valueToTree(this.getPosition()));
                }
                if (this.getSubmit() != null) {
                    data.set("submit", om.valueToTree(this.getSubmit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnForm.FormCTAProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FormCTAProperty.Jsii$Proxy that = (FormCTAProperty.Jsii$Proxy) o;

                if (this.cancel != null ? !this.cancel.equals(that.cancel) : that.cancel != null) return false;
                if (this.clear != null ? !this.clear.equals(that.clear) : that.clear != null) return false;
                if (this.position != null ? !this.position.equals(that.position) : that.position != null) return false;
                return this.submit != null ? this.submit.equals(that.submit) : that.submit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cancel != null ? this.cancel.hashCode() : 0;
                result = 31 * result + (this.clear != null ? this.clear.hashCode() : 0);
                result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
                result = 31 * result + (this.submit != null ? this.submit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the data type configuration for the data source associated with a form.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * FormDataTypeConfigProperty formDataTypeConfigProperty = FormDataTypeConfigProperty.builder()
     *         .dataSourceType("dataSourceType")
     *         .dataTypeName("dataTypeName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm.FormDataTypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FormDataTypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FormDataTypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The data source type, either an Amplify DataStore model or a custom data type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceType();

        /**
         * The unique name of the data type you are using as the data source for the form.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataTypeName();

        /**
         * @return a {@link Builder} of {@link FormDataTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FormDataTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FormDataTypeConfigProperty> {
            java.lang.String dataSourceType;
            java.lang.String dataTypeName;

            /**
             * Sets the value of {@link FormDataTypeConfigProperty#getDataSourceType}
             * @param dataSourceType The data source type, either an Amplify DataStore model or a custom data type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceType(java.lang.String dataSourceType) {
                this.dataSourceType = dataSourceType;
                return this;
            }

            /**
             * Sets the value of {@link FormDataTypeConfigProperty#getDataTypeName}
             * @param dataTypeName The unique name of the data type you are using as the data source for the form. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTypeName(java.lang.String dataTypeName) {
                this.dataTypeName = dataTypeName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FormDataTypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FormDataTypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FormDataTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FormDataTypeConfigProperty {
            private final java.lang.String dataSourceType;
            private final java.lang.String dataTypeName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSourceType = software.amazon.jsii.Kernel.get(this, "dataSourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataTypeName = software.amazon.jsii.Kernel.get(this, "dataTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSourceType = java.util.Objects.requireNonNull(builder.dataSourceType, "dataSourceType is required");
                this.dataTypeName = java.util.Objects.requireNonNull(builder.dataTypeName, "dataTypeName is required");
            }

            @Override
            public final java.lang.String getDataSourceType() {
                return this.dataSourceType;
            }

            @Override
            public final java.lang.String getDataTypeName() {
                return this.dataTypeName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSourceType", om.valueToTree(this.getDataSourceType()));
                data.set("dataTypeName", om.valueToTree(this.getDataTypeName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnForm.FormDataTypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FormDataTypeConfigProperty.Jsii$Proxy that = (FormDataTypeConfigProperty.Jsii$Proxy) o;

                if (!dataSourceType.equals(that.dataSourceType)) return false;
                return this.dataTypeName.equals(that.dataTypeName);
            }

            @Override
            public final int hashCode() {
                int result = this.dataSourceType.hashCode();
                result = 31 * result + (this.dataTypeName.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes the configuration for an input field on a form.
     * <p>
     * Use <code>FormInputValueProperty</code> to specify the values to render or bind by default.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * FormInputValuePropertyProperty formInputValuePropertyProperty = FormInputValuePropertyProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm.FormInputValuePropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(FormInputValuePropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FormInputValuePropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value to assign to the input field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FormInputValuePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FormInputValuePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FormInputValuePropertyProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link FormInputValuePropertyProperty#getValue}
             * @param value The value to assign to the input field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FormInputValuePropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FormInputValuePropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FormInputValuePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FormInputValuePropertyProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnForm.FormInputValuePropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FormInputValuePropertyProperty.Jsii$Proxy that = (FormInputValuePropertyProperty.Jsii$Proxy) o;

                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value != null ? this.value.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes the configuration settings for the form's style properties.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * FormStyleConfigProperty formStyleConfigProperty = FormStyleConfigProperty.builder()
     *         .tokenReference("tokenReference")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm.FormStyleConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FormStyleConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FormStyleConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to a design token to use to bind the form's style properties to an existing theme.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTokenReference() {
            return null;
        }

        /**
         * The value of the style setting.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FormStyleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FormStyleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FormStyleConfigProperty> {
            java.lang.String tokenReference;
            java.lang.String value;

            /**
             * Sets the value of {@link FormStyleConfigProperty#getTokenReference}
             * @param tokenReference A reference to a design token to use to bind the form's style properties to an existing theme.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenReference(java.lang.String tokenReference) {
                this.tokenReference = tokenReference;
                return this;
            }

            /**
             * Sets the value of {@link FormStyleConfigProperty#getValue}
             * @param value The value of the style setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FormStyleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FormStyleConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FormStyleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FormStyleConfigProperty {
            private final java.lang.String tokenReference;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tokenReference = software.amazon.jsii.Kernel.get(this, "tokenReference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tokenReference = builder.tokenReference;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getTokenReference() {
                return this.tokenReference;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTokenReference() != null) {
                    data.set("tokenReference", om.valueToTree(this.getTokenReference()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnForm.FormStyleConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FormStyleConfigProperty.Jsii$Proxy that = (FormStyleConfigProperty.Jsii$Proxy) o;

                if (this.tokenReference != null ? !this.tokenReference.equals(that.tokenReference) : that.tokenReference != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tokenReference != null ? this.tokenReference.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the configuration for the form's style.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * FormStyleProperty formStyleProperty = FormStyleProperty.builder()
     *         .horizontalGap(FormStyleConfigProperty.builder()
     *                 .tokenReference("tokenReference")
     *                 .value("value")
     *                 .build())
     *         .outerPadding(FormStyleConfigProperty.builder()
     *                 .tokenReference("tokenReference")
     *                 .value("value")
     *                 .build())
     *         .verticalGap(FormStyleConfigProperty.builder()
     *                 .tokenReference("tokenReference")
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm.FormStyleProperty")
    @software.amazon.jsii.Jsii.Proxy(FormStyleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FormStyleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The spacing for the horizontal gap.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHorizontalGap() {
            return null;
        }

        /**
         * The size of the outer padding for the form.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOuterPadding() {
            return null;
        }

        /**
         * The spacing for the vertical gap.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVerticalGap() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FormStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FormStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FormStyleProperty> {
            java.lang.Object horizontalGap;
            java.lang.Object outerPadding;
            java.lang.Object verticalGap;

            /**
             * Sets the value of {@link FormStyleProperty#getHorizontalGap}
             * @param horizontalGap The spacing for the horizontal gap.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder horizontalGap(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormStyleConfigProperty horizontalGap) {
                this.horizontalGap = horizontalGap;
                return this;
            }

            /**
             * Sets the value of {@link FormStyleProperty#getHorizontalGap}
             * @param horizontalGap The spacing for the horizontal gap.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder horizontalGap(software.amazon.awscdk.core.IResolvable horizontalGap) {
                this.horizontalGap = horizontalGap;
                return this;
            }

            /**
             * Sets the value of {@link FormStyleProperty#getOuterPadding}
             * @param outerPadding The size of the outer padding for the form.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outerPadding(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormStyleConfigProperty outerPadding) {
                this.outerPadding = outerPadding;
                return this;
            }

            /**
             * Sets the value of {@link FormStyleProperty#getOuterPadding}
             * @param outerPadding The size of the outer padding for the form.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outerPadding(software.amazon.awscdk.core.IResolvable outerPadding) {
                this.outerPadding = outerPadding;
                return this;
            }

            /**
             * Sets the value of {@link FormStyleProperty#getVerticalGap}
             * @param verticalGap The spacing for the vertical gap.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verticalGap(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormStyleConfigProperty verticalGap) {
                this.verticalGap = verticalGap;
                return this;
            }

            /**
             * Sets the value of {@link FormStyleProperty#getVerticalGap}
             * @param verticalGap The spacing for the vertical gap.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verticalGap(software.amazon.awscdk.core.IResolvable verticalGap) {
                this.verticalGap = verticalGap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FormStyleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FormStyleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FormStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FormStyleProperty {
            private final java.lang.Object horizontalGap;
            private final java.lang.Object outerPadding;
            private final java.lang.Object verticalGap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.horizontalGap = software.amazon.jsii.Kernel.get(this, "horizontalGap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outerPadding = software.amazon.jsii.Kernel.get(this, "outerPadding", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.verticalGap = software.amazon.jsii.Kernel.get(this, "verticalGap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.horizontalGap = builder.horizontalGap;
                this.outerPadding = builder.outerPadding;
                this.verticalGap = builder.verticalGap;
            }

            @Override
            public final java.lang.Object getHorizontalGap() {
                return this.horizontalGap;
            }

            @Override
            public final java.lang.Object getOuterPadding() {
                return this.outerPadding;
            }

            @Override
            public final java.lang.Object getVerticalGap() {
                return this.verticalGap;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHorizontalGap() != null) {
                    data.set("horizontalGap", om.valueToTree(this.getHorizontalGap()));
                }
                if (this.getOuterPadding() != null) {
                    data.set("outerPadding", om.valueToTree(this.getOuterPadding()));
                }
                if (this.getVerticalGap() != null) {
                    data.set("verticalGap", om.valueToTree(this.getVerticalGap()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnForm.FormStyleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FormStyleProperty.Jsii$Proxy that = (FormStyleProperty.Jsii$Proxy) o;

                if (this.horizontalGap != null ? !this.horizontalGap.equals(that.horizontalGap) : that.horizontalGap != null) return false;
                if (this.outerPadding != null ? !this.outerPadding.equals(that.outerPadding) : that.outerPadding != null) return false;
                return this.verticalGap != null ? this.verticalGap.equals(that.verticalGap) : that.verticalGap == null;
            }

            @Override
            public final int hashCode() {
                int result = this.horizontalGap != null ? this.horizontalGap.hashCode() : 0;
                result = 31 * result + (this.outerPadding != null ? this.outerPadding.hashCode() : 0);
                result = 31 * result + (this.verticalGap != null ? this.verticalGap.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Stores the configuration information for a visual helper element for a form.
     * <p>
     * A sectional element can be a header, a text block, or a divider. These elements are static and not associated with any data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * SectionalElementProperty sectionalElementProperty = SectionalElementProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .level(123)
     *         .orientation("orientation")
     *         .position(FieldPositionProperty.builder()
     *                 .below("below")
     *                 .fixed("fixed")
     *                 .rightOf("rightOf")
     *                 .build())
     *         .text("text")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm.SectionalElementProperty")
    @software.amazon.jsii.Jsii.Proxy(SectionalElementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SectionalElementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of sectional element.
         * <p>
         * Valid values are <code>Heading</code> , <code>Text</code> , and <code>Divider</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Specifies the size of the font for a `Heading` sectional element.
         * <p>
         * Valid values are <code>1 | 2 | 3 | 4 | 5 | 6</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLevel() {
            return null;
        }

        /**
         * Specifies the orientation for a `Divider` sectional element.
         * <p>
         * Valid values are <code>horizontal</code> or <code>vertical</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrientation() {
            return null;
        }

        /**
         * Specifies the position of the text in a field for a `Text` sectional element.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPosition() {
            return null;
        }

        /**
         * The text for a `Text` sectional element.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getText() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SectionalElementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SectionalElementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SectionalElementProperty> {
            java.lang.String type;
            java.lang.Number level;
            java.lang.String orientation;
            java.lang.Object position;
            java.lang.String text;

            /**
             * Sets the value of {@link SectionalElementProperty#getType}
             * @param type The type of sectional element. This parameter is required.
             *             Valid values are <code>Heading</code> , <code>Text</code> , and <code>Divider</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SectionalElementProperty#getLevel}
             * @param level Specifies the size of the font for a `Heading` sectional element.
             *              Valid values are <code>1 | 2 | 3 | 4 | 5 | 6</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder level(java.lang.Number level) {
                this.level = level;
                return this;
            }

            /**
             * Sets the value of {@link SectionalElementProperty#getOrientation}
             * @param orientation Specifies the orientation for a `Divider` sectional element.
             *                    Valid values are <code>horizontal</code> or <code>vertical</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orientation(java.lang.String orientation) {
                this.orientation = orientation;
                return this;
            }

            /**
             * Sets the value of {@link SectionalElementProperty#getPosition}
             * @param position Specifies the position of the text in a field for a `Text` sectional element.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder position(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FieldPositionProperty position) {
                this.position = position;
                return this;
            }

            /**
             * Sets the value of {@link SectionalElementProperty#getPosition}
             * @param position Specifies the position of the text in a field for a `Text` sectional element.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder position(software.amazon.awscdk.core.IResolvable position) {
                this.position = position;
                return this;
            }

            /**
             * Sets the value of {@link SectionalElementProperty#getText}
             * @param text The text for a `Text` sectional element.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SectionalElementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SectionalElementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SectionalElementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SectionalElementProperty {
            private final java.lang.String type;
            private final java.lang.Number level;
            private final java.lang.String orientation;
            private final java.lang.Object position;
            private final java.lang.String text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.level = software.amazon.jsii.Kernel.get(this, "level", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.orientation = software.amazon.jsii.Kernel.get(this, "orientation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.position = software.amazon.jsii.Kernel.get(this, "position", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.level = builder.level;
                this.orientation = builder.orientation;
                this.position = builder.position;
                this.text = builder.text;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getLevel() {
                return this.level;
            }

            @Override
            public final java.lang.String getOrientation() {
                return this.orientation;
            }

            @Override
            public final java.lang.Object getPosition() {
                return this.position;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getLevel() != null) {
                    data.set("level", om.valueToTree(this.getLevel()));
                }
                if (this.getOrientation() != null) {
                    data.set("orientation", om.valueToTree(this.getOrientation()));
                }
                if (this.getPosition() != null) {
                    data.set("position", om.valueToTree(this.getPosition()));
                }
                if (this.getText() != null) {
                    data.set("text", om.valueToTree(this.getText()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnForm.SectionalElementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SectionalElementProperty.Jsii$Proxy that = (SectionalElementProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.level != null ? !this.level.equals(that.level) : that.level != null) return false;
                if (this.orientation != null ? !this.orientation.equals(that.orientation) : that.orientation != null) return false;
                if (this.position != null ? !this.position.equals(that.position) : that.position != null) return false;
                return this.text != null ? this.text.equals(that.text) : that.text == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
                result = 31 * result + (this.orientation != null ? this.orientation.hashCode() : 0);
                result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
                result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Associates a complex object with a display value.
     * <p>
     * Use <code>ValueMapping</code> to store how to represent complex objects when they are displayed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * ValueMappingProperty valueMappingProperty = ValueMappingProperty.builder()
     *         .value(FormInputValuePropertyProperty.builder()
     *                 .value("value")
     *                 .build())
     *         // the properties below are optional
     *         .displayValue(FormInputValuePropertyProperty.builder()
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm.ValueMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(ValueMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ValueMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The complex object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValue();

        /**
         * The value to display for the complex object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisplayValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ValueMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ValueMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ValueMappingProperty> {
            java.lang.Object value;
            java.lang.Object displayValue;

            /**
             * Sets the value of {@link ValueMappingProperty#getValue}
             * @param value The complex object. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormInputValuePropertyProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link ValueMappingProperty#getValue}
             * @param value The complex object. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.core.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link ValueMappingProperty#getDisplayValue}
             * @param displayValue The value to display for the complex object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder displayValue(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormInputValuePropertyProperty displayValue) {
                this.displayValue = displayValue;
                return this;
            }

            /**
             * Sets the value of {@link ValueMappingProperty#getDisplayValue}
             * @param displayValue The value to display for the complex object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder displayValue(software.amazon.awscdk.core.IResolvable displayValue) {
                this.displayValue = displayValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ValueMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ValueMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ValueMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ValueMappingProperty {
            private final java.lang.Object value;
            private final java.lang.Object displayValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.displayValue = software.amazon.jsii.Kernel.get(this, "displayValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.displayValue = builder.displayValue;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            public final java.lang.Object getDisplayValue() {
                return this.displayValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));
                if (this.getDisplayValue() != null) {
                    data.set("displayValue", om.valueToTree(this.getDisplayValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnForm.ValueMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ValueMappingProperty.Jsii$Proxy that = (ValueMappingProperty.Jsii$Proxy) o;

                if (!value.equals(that.value)) return false;
                return this.displayValue != null ? this.displayValue.equals(that.displayValue) : that.displayValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                result = 31 * result + (this.displayValue != null ? this.displayValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the data binding configuration for a value map.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * ValueMappingsProperty valueMappingsProperty = ValueMappingsProperty.builder()
     *         .values(List.of(ValueMappingProperty.builder()
     *                 .value(FormInputValuePropertyProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 // the properties below are optional
     *                 .displayValue(FormInputValuePropertyProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplifyuibuilder.CfnForm.ValueMappingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ValueMappingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ValueMappingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value and display value pairs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValues();

        /**
         * @return a {@link Builder} of {@link ValueMappingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ValueMappingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ValueMappingsProperty> {
            java.lang.Object values;

            /**
             * Sets the value of {@link ValueMappingsProperty#getValues}
             * @param values The value and display value pairs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(software.amazon.awscdk.core.IResolvable values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of {@link ValueMappingsProperty#getValues}
             * @param values The value and display value pairs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<? extends java.lang.Object> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ValueMappingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ValueMappingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ValueMappingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ValueMappingsProperty {
            private final java.lang.Object values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.Object getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_amplifyuibuilder.CfnForm.ValueMappingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ValueMappingsProperty.Jsii$Proxy that = (ValueMappingsProperty.Jsii$Proxy) o;

                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.values.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.amplifyuibuilder.CfnForm}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.amplifyuibuilder.CfnForm> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.amplifyuibuilder.CfnFormProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.amplifyuibuilder.CfnFormProps.Builder();
        }

        /**
         * The type of data source to use to create the form.
         * <p>
         * @return {@code this}
         * @param dataType The type of data source to use to create the form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataType(final software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormDataTypeConfigProperty dataType) {
            this.props.dataType(dataType);
            return this;
        }
        /**
         * The type of data source to use to create the form.
         * <p>
         * @return {@code this}
         * @param dataType The type of data source to use to create the form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataType(final software.amazon.awscdk.core.IResolvable dataType) {
            this.props.dataType(dataType);
            return this;
        }

        /**
         * Stores the information about the form's fields.
         * <p>
         * @return {@code this}
         * @param fields Stores the information about the form's fields. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(final software.amazon.awscdk.core.IResolvable fields) {
            this.props.fields(fields);
            return this;
        }
        /**
         * Stores the information about the form's fields.
         * <p>
         * @return {@code this}
         * @param fields Stores the information about the form's fields. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(final java.util.Map<java.lang.String, ? extends java.lang.Object> fields) {
            this.props.fields(fields);
            return this;
        }

        /**
         * The operation to perform on the specified form.
         * <p>
         * @return {@code this}
         * @param formActionType The operation to perform on the specified form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder formActionType(final java.lang.String formActionType) {
            this.props.formActionType(formActionType);
            return this;
        }

        /**
         * The name of the form.
         * <p>
         * @return {@code this}
         * @param name The name of the form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The schema version of the form when it was imported.
         * <p>
         * @return {@code this}
         * @param schemaVersion The schema version of the form when it was imported. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaVersion(final java.lang.String schemaVersion) {
            this.props.schemaVersion(schemaVersion);
            return this;
        }

        /**
         * Stores the visual helper elements for the form that are not associated with any data.
         * <p>
         * @return {@code this}
         * @param sectionalElements Stores the visual helper elements for the form that are not associated with any data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sectionalElements(final software.amazon.awscdk.core.IResolvable sectionalElements) {
            this.props.sectionalElements(sectionalElements);
            return this;
        }
        /**
         * Stores the visual helper elements for the form that are not associated with any data.
         * <p>
         * @return {@code this}
         * @param sectionalElements Stores the visual helper elements for the form that are not associated with any data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sectionalElements(final java.util.Map<java.lang.String, ? extends java.lang.Object> sectionalElements) {
            this.props.sectionalElements(sectionalElements);
            return this;
        }

        /**
         * Stores the configuration for the form's style.
         * <p>
         * @return {@code this}
         * @param style Stores the configuration for the form's style. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder style(final software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormStyleProperty style) {
            this.props.style(style);
            return this;
        }
        /**
         * Stores the configuration for the form's style.
         * <p>
         * @return {@code this}
         * @param style Stores the configuration for the form's style. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder style(final software.amazon.awscdk.core.IResolvable style) {
            this.props.style(style);
            return this;
        }

        /**
         * The unique ID of the Amplify app associated with the form.
         * <p>
         * @return {@code this}
         * @param appId The unique ID of the Amplify app associated with the form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appId(final java.lang.String appId) {
            this.props.appId(appId);
            return this;
        }

        /**
         * Stores the call to action configuration for the form.
         * <p>
         * @return {@code this}
         * @param cta Stores the call to action configuration for the form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cta(final software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormCTAProperty cta) {
            this.props.cta(cta);
            return this;
        }
        /**
         * Stores the call to action configuration for the form.
         * <p>
         * @return {@code this}
         * @param cta Stores the call to action configuration for the form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cta(final software.amazon.awscdk.core.IResolvable cta) {
            this.props.cta(cta);
            return this;
        }

        /**
         * The name of the backend environment that is a part of the Amplify app.
         * <p>
         * @return {@code this}
         * @param environmentName The name of the backend environment that is a part of the Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentName(final java.lang.String environmentName) {
            this.props.environmentName(environmentName);
            return this;
        }

        /**
         * One or more key-value pairs to use when tagging the form.
         * <p>
         * @return {@code this}
         * @param tags One or more key-value pairs to use when tagging the form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.amplifyuibuilder.CfnForm}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.amplifyuibuilder.CfnForm build() {
            return new software.amazon.awscdk.services.amplifyuibuilder.CfnForm(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
