package software.amazon.awscdk.services.amplify;

/**
 * (experimental) Options to add a domain to an application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App amplifyApp;
 * Branch master;
 * Branch dev;
 * Domain domain = amplifyApp.addDomain("example.com", DomainOptions.builder()
 *         .enableAutoSubdomain(true) // in case subdomains should be auto registered for branches
 *         .autoSubdomainCreationPatterns(List.of("*", "pr*"))
 *         .build());
 * domain.mapRoot(master); // map master branch to domain root
 * domain.mapSubDomain(master, "www");
 * domain.mapSubDomain(dev);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.873Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplify.DomainOptions")
@software.amazon.jsii.Jsii.Proxy(DomainOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DomainOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Branches which should automatically create subdomains.
     * <p>
     * Default: - all repository branches ['*', 'pr*']
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAutoSubdomainCreationPatterns() {
        return null;
    }

    /**
     * (experimental) The name of the domain.
     * <p>
     * Default: - the construct's id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * (experimental) Automatically create subdomains for connected branches.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableAutoSubdomain() {
        return null;
    }

    /**
     * (experimental) Subdomains.
     * <p>
     * Default: - use `addSubDomain()` to add subdomains
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.amplify.SubDomain> getSubDomains() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DomainOptions> {
        java.util.List<java.lang.String> autoSubdomainCreationPatterns;
        java.lang.String domainName;
        java.lang.Boolean enableAutoSubdomain;
        java.util.List<software.amazon.awscdk.services.amplify.SubDomain> subDomains;

        /**
         * Sets the value of {@link DomainOptions#getAutoSubdomainCreationPatterns}
         * @param autoSubdomainCreationPatterns Branches which should automatically create subdomains.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoSubdomainCreationPatterns(java.util.List<java.lang.String> autoSubdomainCreationPatterns) {
            this.autoSubdomainCreationPatterns = autoSubdomainCreationPatterns;
            return this;
        }

        /**
         * Sets the value of {@link DomainOptions#getDomainName}
         * @param domainName The name of the domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link DomainOptions#getEnableAutoSubdomain}
         * @param enableAutoSubdomain Automatically create subdomains for connected branches.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableAutoSubdomain(java.lang.Boolean enableAutoSubdomain) {
            this.enableAutoSubdomain = enableAutoSubdomain;
            return this;
        }

        /**
         * Sets the value of {@link DomainOptions#getSubDomains}
         * @param subDomains Subdomains.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder subDomains(java.util.List<? extends software.amazon.awscdk.services.amplify.SubDomain> subDomains) {
            this.subDomains = (java.util.List<software.amazon.awscdk.services.amplify.SubDomain>)subDomains;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DomainOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainOptions {
        private final java.util.List<java.lang.String> autoSubdomainCreationPatterns;
        private final java.lang.String domainName;
        private final java.lang.Boolean enableAutoSubdomain;
        private final java.util.List<software.amazon.awscdk.services.amplify.SubDomain> subDomains;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoSubdomainCreationPatterns = software.amazon.jsii.Kernel.get(this, "autoSubdomainCreationPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableAutoSubdomain = software.amazon.jsii.Kernel.get(this, "enableAutoSubdomain", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.subDomains = software.amazon.jsii.Kernel.get(this, "subDomains", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.SubDomain.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoSubdomainCreationPatterns = builder.autoSubdomainCreationPatterns;
            this.domainName = builder.domainName;
            this.enableAutoSubdomain = builder.enableAutoSubdomain;
            this.subDomains = (java.util.List<software.amazon.awscdk.services.amplify.SubDomain>)builder.subDomains;
        }

        @Override
        public final java.util.List<java.lang.String> getAutoSubdomainCreationPatterns() {
            return this.autoSubdomainCreationPatterns;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.Boolean getEnableAutoSubdomain() {
            return this.enableAutoSubdomain;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.amplify.SubDomain> getSubDomains() {
            return this.subDomains;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutoSubdomainCreationPatterns() != null) {
                data.set("autoSubdomainCreationPatterns", om.valueToTree(this.getAutoSubdomainCreationPatterns()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getEnableAutoSubdomain() != null) {
                data.set("enableAutoSubdomain", om.valueToTree(this.getEnableAutoSubdomain()));
            }
            if (this.getSubDomains() != null) {
                data.set("subDomains", om.valueToTree(this.getSubDomains()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_amplify.DomainOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainOptions.Jsii$Proxy that = (DomainOptions.Jsii$Proxy) o;

            if (this.autoSubdomainCreationPatterns != null ? !this.autoSubdomainCreationPatterns.equals(that.autoSubdomainCreationPatterns) : that.autoSubdomainCreationPatterns != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.enableAutoSubdomain != null ? !this.enableAutoSubdomain.equals(that.enableAutoSubdomain) : that.enableAutoSubdomain != null) return false;
            return this.subDomains != null ? this.subDomains.equals(that.subDomains) : that.subDomains == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoSubdomainCreationPatterns != null ? this.autoSubdomainCreationPatterns.hashCode() : 0;
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.enableAutoSubdomain != null ? this.enableAutoSubdomain.hashCode() : 0);
            result = 31 * result + (this.subDomains != null ? this.subDomains.hashCode() : 0);
            return result;
        }
    }
}
