package software.amazon.awscdk.services.amplify;

/**
 * (experimental) Properties for a Branch.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amplify.*;
 * import software.amazon.awscdk.services.codebuild.*;
 * import software.amazon.awscdk.services.s3.assets.*;
 * App app;
 * Asset asset;
 * BasicAuth basicAuth;
 * BuildSpec buildSpec;
 * BranchProps branchProps = BranchProps.builder()
 *         .app(app)
 *         // the properties below are optional
 *         .asset(asset)
 *         .autoBuild(false)
 *         .basicAuth(basicAuth)
 *         .branchName("branchName")
 *         .buildSpec(buildSpec)
 *         .description("description")
 *         .environmentVariables(Map.of(
 *                 "environmentVariablesKey", "environmentVariables"))
 *         .performanceMode(false)
 *         .pullRequestEnvironmentName("pullRequestEnvironmentName")
 *         .pullRequestPreview(false)
 *         .stage("stage")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.822Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplify.BranchProps")
@software.amazon.jsii.Jsii.Proxy(BranchProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BranchProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.amplify.BranchOptions {

    /**
     * (experimental) The application within which the branch must be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.IApp getApp();

    /**
     * @return a {@link Builder} of {@link BranchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BranchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BranchProps> {
        software.amazon.awscdk.services.amplify.IApp app;
        software.amazon.awscdk.services.s3.assets.Asset asset;
        java.lang.Boolean autoBuild;
        software.amazon.awscdk.services.amplify.BasicAuth basicAuth;
        java.lang.String branchName;
        software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        java.lang.String description;
        java.util.Map<java.lang.String, java.lang.String> environmentVariables;
        java.lang.Boolean performanceMode;
        java.lang.String pullRequestEnvironmentName;
        java.lang.Boolean pullRequestPreview;
        java.lang.String stage;

        /**
         * Sets the value of {@link BranchProps#getApp}
         * @param app The application within which the branch must be created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder app(software.amazon.awscdk.services.amplify.IApp app) {
            this.app = app;
            return this;
        }

        /**
         * Sets the value of {@link BranchProps#getAsset}
         * @param asset Asset for deployment.
         *              The Amplify app must not have a sourceCodeProvider configured as this resource uses Amplify's
         *              startDeployment API to initiate and deploy a S3 asset onto the App.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder asset(software.amazon.awscdk.services.s3.assets.Asset asset) {
            this.asset = asset;
            return this;
        }

        /**
         * Sets the value of {@link BranchProps#getAutoBuild}
         * @param autoBuild Whether to enable auto building for the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoBuild(java.lang.Boolean autoBuild) {
            this.autoBuild = autoBuild;
            return this;
        }

        /**
         * Sets the value of {@link BranchProps#getBasicAuth}
         * @param basicAuth The Basic Auth configuration.
         *                  Use this to set password protection for
         *                  the branch
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder basicAuth(software.amazon.awscdk.services.amplify.BasicAuth basicAuth) {
            this.basicAuth = basicAuth;
            return this;
        }

        /**
         * Sets the value of {@link BranchProps#getBranchName}
         * @param branchName The name of the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder branchName(java.lang.String branchName) {
            this.branchName = branchName;
            return this;
        }

        /**
         * Sets the value of {@link BranchProps#getBuildSpec}
         * @param buildSpec BuildSpec for the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildSpec(software.amazon.awscdk.services.codebuild.BuildSpec buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        /**
         * Sets the value of {@link BranchProps#getDescription}
         * @param description A description for the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link BranchProps#getEnvironmentVariables}
         * @param environmentVariables Environment variables for the branch.
         *                             All environment variables that you add are encrypted to prevent rogue
         *                             access so you can use them to store secret information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environmentVariables(java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link BranchProps#getPerformanceMode}
         * @param performanceMode Enables performance mode for the branch.
         *                        Performance mode optimizes for faster hosting performance by keeping content cached at the edge
         *                        for a longer interval. When performance mode is enabled, hosting configuration or code changes
         *                        can take up to 10 minutes to roll out.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder performanceMode(java.lang.Boolean performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        /**
         * Sets the value of {@link BranchProps#getPullRequestEnvironmentName}
         * @param pullRequestEnvironmentName The dedicated backend environment for the pull request previews.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pullRequestEnvironmentName(java.lang.String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
            return this;
        }

        /**
         * Sets the value of {@link BranchProps#getPullRequestPreview}
         * @param pullRequestPreview Whether to enable pull request preview for the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pullRequestPreview(java.lang.Boolean pullRequestPreview) {
            this.pullRequestPreview = pullRequestPreview;
            return this;
        }

        /**
         * Sets the value of {@link BranchProps#getStage}
         * @param stage Stage for the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stage(java.lang.String stage) {
            this.stage = stage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BranchProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BranchProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BranchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BranchProps {
        private final software.amazon.awscdk.services.amplify.IApp app;
        private final software.amazon.awscdk.services.s3.assets.Asset asset;
        private final java.lang.Boolean autoBuild;
        private final software.amazon.awscdk.services.amplify.BasicAuth basicAuth;
        private final java.lang.String branchName;
        private final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, java.lang.String> environmentVariables;
        private final java.lang.Boolean performanceMode;
        private final java.lang.String pullRequestEnvironmentName;
        private final java.lang.Boolean pullRequestPreview;
        private final java.lang.String stage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.app = software.amazon.jsii.Kernel.get(this, "app", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.IApp.class));
            this.asset = software.amazon.jsii.Kernel.get(this, "asset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.assets.Asset.class));
            this.autoBuild = software.amazon.jsii.Kernel.get(this, "autoBuild", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.basicAuth = software.amazon.jsii.Kernel.get(this, "basicAuth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.BasicAuth.class));
            this.branchName = software.amazon.jsii.Kernel.get(this, "branchName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.buildSpec = software.amazon.jsii.Kernel.get(this, "buildSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.performanceMode = software.amazon.jsii.Kernel.get(this, "performanceMode", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.pullRequestEnvironmentName = software.amazon.jsii.Kernel.get(this, "pullRequestEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pullRequestPreview = software.amazon.jsii.Kernel.get(this, "pullRequestPreview", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.app = java.util.Objects.requireNonNull(builder.app, "app is required");
            this.asset = builder.asset;
            this.autoBuild = builder.autoBuild;
            this.basicAuth = builder.basicAuth;
            this.branchName = builder.branchName;
            this.buildSpec = builder.buildSpec;
            this.description = builder.description;
            this.environmentVariables = builder.environmentVariables;
            this.performanceMode = builder.performanceMode;
            this.pullRequestEnvironmentName = builder.pullRequestEnvironmentName;
            this.pullRequestPreview = builder.pullRequestPreview;
            this.stage = builder.stage;
        }

        @Override
        public final software.amazon.awscdk.services.amplify.IApp getApp() {
            return this.app;
        }

        @Override
        public final software.amazon.awscdk.services.s3.assets.Asset getAsset() {
            return this.asset;
        }

        @Override
        public final java.lang.Boolean getAutoBuild() {
            return this.autoBuild;
        }

        @Override
        public final software.amazon.awscdk.services.amplify.BasicAuth getBasicAuth() {
            return this.basicAuth;
        }

        @Override
        public final java.lang.String getBranchName() {
            return this.branchName;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildSpec getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final java.lang.Boolean getPerformanceMode() {
            return this.performanceMode;
        }

        @Override
        public final java.lang.String getPullRequestEnvironmentName() {
            return this.pullRequestEnvironmentName;
        }

        @Override
        public final java.lang.Boolean getPullRequestPreview() {
            return this.pullRequestPreview;
        }

        @Override
        public final java.lang.String getStage() {
            return this.stage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("app", om.valueToTree(this.getApp()));
            if (this.getAsset() != null) {
                data.set("asset", om.valueToTree(this.getAsset()));
            }
            if (this.getAutoBuild() != null) {
                data.set("autoBuild", om.valueToTree(this.getAutoBuild()));
            }
            if (this.getBasicAuth() != null) {
                data.set("basicAuth", om.valueToTree(this.getBasicAuth()));
            }
            if (this.getBranchName() != null) {
                data.set("branchName", om.valueToTree(this.getBranchName()));
            }
            if (this.getBuildSpec() != null) {
                data.set("buildSpec", om.valueToTree(this.getBuildSpec()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getPerformanceMode() != null) {
                data.set("performanceMode", om.valueToTree(this.getPerformanceMode()));
            }
            if (this.getPullRequestEnvironmentName() != null) {
                data.set("pullRequestEnvironmentName", om.valueToTree(this.getPullRequestEnvironmentName()));
            }
            if (this.getPullRequestPreview() != null) {
                data.set("pullRequestPreview", om.valueToTree(this.getPullRequestPreview()));
            }
            if (this.getStage() != null) {
                data.set("stage", om.valueToTree(this.getStage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_amplify.BranchProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BranchProps.Jsii$Proxy that = (BranchProps.Jsii$Proxy) o;

            if (!app.equals(that.app)) return false;
            if (this.asset != null ? !this.asset.equals(that.asset) : that.asset != null) return false;
            if (this.autoBuild != null ? !this.autoBuild.equals(that.autoBuild) : that.autoBuild != null) return false;
            if (this.basicAuth != null ? !this.basicAuth.equals(that.basicAuth) : that.basicAuth != null) return false;
            if (this.branchName != null ? !this.branchName.equals(that.branchName) : that.branchName != null) return false;
            if (this.buildSpec != null ? !this.buildSpec.equals(that.buildSpec) : that.buildSpec != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.performanceMode != null ? !this.performanceMode.equals(that.performanceMode) : that.performanceMode != null) return false;
            if (this.pullRequestEnvironmentName != null ? !this.pullRequestEnvironmentName.equals(that.pullRequestEnvironmentName) : that.pullRequestEnvironmentName != null) return false;
            if (this.pullRequestPreview != null ? !this.pullRequestPreview.equals(that.pullRequestPreview) : that.pullRequestPreview != null) return false;
            return this.stage != null ? this.stage.equals(that.stage) : that.stage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.app.hashCode();
            result = 31 * result + (this.asset != null ? this.asset.hashCode() : 0);
            result = 31 * result + (this.autoBuild != null ? this.autoBuild.hashCode() : 0);
            result = 31 * result + (this.basicAuth != null ? this.basicAuth.hashCode() : 0);
            result = 31 * result + (this.branchName != null ? this.branchName.hashCode() : 0);
            result = 31 * result + (this.buildSpec != null ? this.buildSpec.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.performanceMode != null ? this.performanceMode.hashCode() : 0);
            result = 31 * result + (this.pullRequestEnvironmentName != null ? this.pullRequestEnvironmentName.hashCode() : 0);
            result = 31 * result + (this.pullRequestPreview != null ? this.pullRequestPreview.hashCode() : 0);
            result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
            return result;
        }
    }
}
