package software.amazon.awscdk.services.amplify;

/**
 * (experimental) An Amplify Console branch.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App amplifyApp;
 * Branch master = amplifyApp.addBranch("master"); // `id` will be used as repo branch name
 * Branch dev = amplifyApp.addBranch("dev", BranchOptions.builder()
 *         .performanceMode(true)
 *         .build());
 * dev.addEnvironment("STAGE", "dev");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.819Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_amplify.Branch")
public class Branch extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.amplify.IBranch {

    protected Branch(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Branch(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Branch(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.BranchProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing branch.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param branchName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.IBranch fromBranchName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String branchName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.amplify.Branch.class, "fromBranchName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.IBranch.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(branchName, "branchName is required") });
    }

    /**
     * (experimental) Adds an environment variable to this branch.
     * <p>
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     * <p>
     * @param name This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.Branch addEnvironment(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.Kernel.call(this, "addEnvironment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amplify.Branch.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) The ARN of the branch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getArn() {
        return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the branch.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getBranchName() {
        return software.amazon.jsii.Kernel.get(this, "branchName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.amplify.Branch}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.amplify.Branch> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.amplify.BranchProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.amplify.BranchProps.Builder();
        }

        /**
         * (experimental) Asset for deployment.
         * <p>
         * The Amplify app must not have a sourceCodeProvider configured as this resource uses Amplify's
         * startDeployment API to initiate and deploy a S3 asset onto the App.
         * <p>
         * Default: - no asset
         * <p>
         * @return {@code this}
         * @param asset Asset for deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder asset(final software.amazon.awscdk.services.s3.assets.Asset asset) {
            this.props.asset(asset);
            return this;
        }

        /**
         * (experimental) Whether to enable auto building for the branch.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param autoBuild Whether to enable auto building for the branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoBuild(final java.lang.Boolean autoBuild) {
            this.props.autoBuild(autoBuild);
            return this;
        }

        /**
         * (experimental) The Basic Auth configuration.
         * <p>
         * Use this to set password protection for
         * the branch
         * <p>
         * Default: - no password protection
         * <p>
         * @return {@code this}
         * @param basicAuth The Basic Auth configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder basicAuth(final software.amazon.awscdk.services.amplify.BasicAuth basicAuth) {
            this.props.basicAuth(basicAuth);
            return this;
        }

        /**
         * (experimental) The name of the branch.
         * <p>
         * Default: - the construct's id
         * <p>
         * @return {@code this}
         * @param branchName The name of the branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder branchName(final java.lang.String branchName) {
            this.props.branchName(branchName);
            return this;
        }

        /**
         * (experimental) BuildSpec for the branch.
         * <p>
         * Default: - no build spec
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html">https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html</a>
         * @param buildSpec BuildSpec for the branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildSpec(final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec) {
            this.props.buildSpec(buildSpec);
            return this;
        }

        /**
         * (experimental) A description for the branch.
         * <p>
         * Default: - no description
         * <p>
         * @return {@code this}
         * @param description A description for the branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) Environment variables for the branch.
         * <p>
         * All environment variables that you add are encrypted to prevent rogue
         * access so you can use them to store secret information.
         * <p>
         * Default: - application environment variables
         * <p>
         * @return {@code this}
         * @param environmentVariables Environment variables for the branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environmentVariables(final java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }

        /**
         * (experimental) Enables performance mode for the branch.
         * <p>
         * Performance mode optimizes for faster hosting performance by keeping content cached at the edge
         * for a longer interval. When performance mode is enabled, hosting configuration or code changes
         * can take up to 10 minutes to roll out.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param performanceMode Enables performance mode for the branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder performanceMode(final java.lang.Boolean performanceMode) {
            this.props.performanceMode(performanceMode);
            return this;
        }

        /**
         * (experimental) The dedicated backend environment for the pull request previews.
         * <p>
         * Default: - automatically provision a temporary backend
         * <p>
         * @return {@code this}
         * @param pullRequestEnvironmentName The dedicated backend environment for the pull request previews. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pullRequestEnvironmentName(final java.lang.String pullRequestEnvironmentName) {
            this.props.pullRequestEnvironmentName(pullRequestEnvironmentName);
            return this;
        }

        /**
         * (experimental) Whether to enable pull request preview for the branch.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param pullRequestPreview Whether to enable pull request preview for the branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pullRequestPreview(final java.lang.Boolean pullRequestPreview) {
            this.props.pullRequestPreview(pullRequestPreview);
            return this;
        }

        /**
         * (experimental) Stage for the branch.
         * <p>
         * Default: - no stage
         * <p>
         * @return {@code this}
         * @param stage Stage for the branch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stage(final java.lang.String stage) {
            this.props.stage(stage);
            return this;
        }

        /**
         * (experimental) The application within which the branch must be created.
         * <p>
         * @return {@code this}
         * @param app The application within which the branch must be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder app(final software.amazon.awscdk.services.amplify.IApp app) {
            this.props.app(app);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.amplify.Branch}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.amplify.Branch build() {
            return new software.amazon.awscdk.services.amplify.Branch(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
