package software.amazon.awscdk.pipelines;

/**
 * (experimental) Options for customizing a single CodeBuild project.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * SecurityGroup mySecurityGroup;
 * CodePipeline.Builder.create(this, "Pipeline")
 *         // Standard CodePipeline properties
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(CodePipelineSource.connection("my-org/my-app", "main", ConnectionSourceOptions.builder()
 *                         .connectionArn("arn:aws:codestar-connections:us-east-1:222222222222:connection/7d2469ff-514a-4e4f-9003-5ca4a43cdc41")
 *                         .build()))
 *                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
 *                 .build())
 *         // Defaults for all CodeBuild projects
 *         .codeBuildDefaults(CodeBuildOptions.builder()
 *                 // Prepend commands and configuration to all projects
 *                 .partialBuildSpec(BuildSpec.fromObject(Map.of(
 *                         "version", "0.2")))
 *                 // Control the build environment
 *                 .buildEnvironment(BuildEnvironment.builder()
 *                         .computeType(ComputeType.LARGE)
 *                         .build())
 *                 // Control Elastic Network Interface creation
 *                 .vpc(vpc)
 *                 .subnetSelection(SubnetSelection.builder().subnetType(SubnetType.PRIVATE_WITH_NAT).build())
 *                 .securityGroups(List.of(mySecurityGroup))
 *                 // Additional policy statements for the execution role
 *                 .rolePolicy(List.of(
 *                     PolicyStatement.Builder.create().build()))
 *                 .build())
 *         .synthCodeBuildDefaults(CodeBuildOptions.builder().build())
 *         .assetPublishingCodeBuildDefaults(CodeBuildOptions.builder().build())
 *         .selfMutationCodeBuildDefaults(CodeBuildOptions.builder().build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:13.057Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.pipelines.CodeBuildOptions")
@software.amazon.jsii.Jsii.Proxy(CodeBuildOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CodeBuildOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Partial build environment, will be combined with other build environments that apply.
     * <p>
     * Default: - Non-privileged build, SMALL instance, LinuxBuildImage.STANDARD_5_0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildEnvironment getBuildEnvironment() {
        return null;
    }

    /**
     * (experimental) Partial buildspec, will be combined with other buildspecs that apply.
     * <p>
     * The BuildSpec must be available inline--it cannot reference a file
     * on disk.
     * <p>
     * Default: - No initial BuildSpec
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildSpec getPartialBuildSpec() {
        return null;
    }

    /**
     * (experimental) Policy statements to add to role.
     * <p>
     * Default: - No policy statements added to CodeBuild Project Role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getRolePolicy() {
        return null;
    }

    /**
     * (experimental) Which security group(s) to associate with the project network interfaces.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - Security group will be automatically created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * (experimental) Which subnets to use.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - All private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * (experimental) The number of minutes after which AWS CodeBuild stops the build if it's not complete.
     * <p>
     * For valid values, see the timeoutInMinutes field in the AWS
     * CodeBuild User Guide.
     * <p>
     * Default: Duration.hours(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTimeout() {
        return null;
    }

    /**
     * (experimental) The VPC where to create the CodeBuild network interfaces in.
     * <p>
     * Default: - No VPC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeBuildOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeBuildOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CodeBuildOptions> {
        software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment;
        software.amazon.awscdk.services.codebuild.BuildSpec partialBuildSpec;
        java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> rolePolicy;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        software.amazon.awscdk.core.Duration timeout;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link CodeBuildOptions#getBuildEnvironment}
         * @param buildEnvironment Partial build environment, will be combined with other build environments that apply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildEnvironment(software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment) {
            this.buildEnvironment = buildEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getPartialBuildSpec}
         * @param partialBuildSpec Partial buildspec, will be combined with other buildspecs that apply.
         *                         The BuildSpec must be available inline--it cannot reference a file
         *                         on disk.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder partialBuildSpec(software.amazon.awscdk.services.codebuild.BuildSpec partialBuildSpec) {
            this.partialBuildSpec = partialBuildSpec;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getRolePolicy}
         * @param rolePolicy Policy statements to add to role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder rolePolicy(java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> rolePolicy) {
            this.rolePolicy = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)rolePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getSecurityGroups}
         * @param securityGroups Which security group(s) to associate with the project network interfaces.
         *                       Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getSubnetSelection}
         * @param subnetSelection Which subnets to use.
         *                        Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getTimeout}
         * @param timeout The number of minutes after which AWS CodeBuild stops the build if it's not complete.
         *                For valid values, see the timeoutInMinutes field in the AWS
         *                CodeBuild User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getVpc}
         * @param vpc The VPC where to create the CodeBuild network interfaces in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeBuildOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CodeBuildOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeBuildOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeBuildOptions {
        private final software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment;
        private final software.amazon.awscdk.services.codebuild.BuildSpec partialBuildSpec;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> rolePolicy;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final software.amazon.awscdk.core.Duration timeout;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.buildEnvironment = software.amazon.jsii.Kernel.get(this, "buildEnvironment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildEnvironment.class));
            this.partialBuildSpec = software.amazon.jsii.Kernel.get(this, "partialBuildSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class));
            this.rolePolicy = software.amazon.jsii.Kernel.get(this, "rolePolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.buildEnvironment = builder.buildEnvironment;
            this.partialBuildSpec = builder.partialBuildSpec;
            this.rolePolicy = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)builder.rolePolicy;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.subnetSelection = builder.subnetSelection;
            this.timeout = builder.timeout;
            this.vpc = builder.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildEnvironment getBuildEnvironment() {
            return this.buildEnvironment;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildSpec getPartialBuildSpec() {
            return this.partialBuildSpec;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getRolePolicy() {
            return this.rolePolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBuildEnvironment() != null) {
                data.set("buildEnvironment", om.valueToTree(this.getBuildEnvironment()));
            }
            if (this.getPartialBuildSpec() != null) {
                data.set("partialBuildSpec", om.valueToTree(this.getPartialBuildSpec()));
            }
            if (this.getRolePolicy() != null) {
                data.set("rolePolicy", om.valueToTree(this.getRolePolicy()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.pipelines.CodeBuildOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeBuildOptions.Jsii$Proxy that = (CodeBuildOptions.Jsii$Proxy) o;

            if (this.buildEnvironment != null ? !this.buildEnvironment.equals(that.buildEnvironment) : that.buildEnvironment != null) return false;
            if (this.partialBuildSpec != null ? !this.partialBuildSpec.equals(that.partialBuildSpec) : that.partialBuildSpec != null) return false;
            if (this.rolePolicy != null ? !this.rolePolicy.equals(that.rolePolicy) : that.rolePolicy != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.buildEnvironment != null ? this.buildEnvironment.hashCode() : 0;
            result = 31 * result + (this.partialBuildSpec != null ? this.partialBuildSpec.hashCode() : 0);
            result = 31 * result + (this.rolePolicy != null ? this.rolePolicy.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
