/**
 * <h1>AWS Lambda Layer with AWS CLI</h1>
 * <p>
 * This module exports a single class called <code>AwsCliLayer</code> which is a <code>lambda.Layer</code> that bundles the AWS CLI.
 * <p>
 * Any Lambda Function that uses this layer must use a Python 3.x runtime.
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 * // AwsCliLayer bundles the AWS CLI in a lambda layer
 * import software.amazon.awscdk.lambdalayer.awscli.AwsCliLayer;
 * 
 * Function fn;
 * 
 * fn.addLayers(new AwsCliLayer(this, "AwsCliLayer"));
 * </pre></blockquote>
 * <p>
 * The CLI will be installed under <code>/opt/awscli/aws</code>.
 */
package software.amazon.awscdk.lambdalayer.awscli;
