package software.amazon.awscdk.integtests;

/**
 * (experimental) An integration test case stack. Allows the definition of test properties that should apply to this stack.
 * <p>
 * This should be used if there are multiple stacks in the integration test
 * and it is necessary to specify different test case option for each. Otherwise
 * normal stacks should be added to IntegTest
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App app;
 * Stack stackUnderTest;
 * IntegTestCaseStack testCaseWithAssets = IntegTestCaseStack.Builder.create(app, "TestCaseAssets")
 *         .diffAssets(true)
 *         .build();
 * IntegTest.Builder.create(app, "Integ").testCases(List.of(stackUnderTest, testCaseWithAssets)).build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:12.948Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.integ_tests.IntegTestCaseStack")
public class IntegTestCaseStack extends software.amazon.awscdk.core.Stack {

    protected IntegTestCaseStack(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IntegTestCaseStack(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public IntegTestCaseStack(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.integtests.IntegTestCaseStackProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public IntegTestCaseStack(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Returns whether the construct is a IntegTestCaseStack.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isIntegTestCaseStack(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.integtests.IntegTestCaseStack.class, "isIntegTestCaseStack", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * (experimental) Make assertions on resources in this test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.IDeployAssert getAssertions() {
        return software.amazon.jsii.Kernel.get(this, "assertions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.IDeployAssert.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.integtests.IntegTestCaseStack}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.integtests.IntegTestCaseStack> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.integtests.IntegTestCaseStackProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) List of CloudFormation resource types in this stack that can be destroyed as part of an update without failing the test.
         * <p>
         * This list should only include resources that for this specific
         * integration test we are sure will not cause errors or an outage if
         * destroyed. For example, maybe we know that a new resource will be created
         * first before the old resource is destroyed which prevents any outage.
         * <p>
         * e.g. ['AWS::IAM::Role']
         * <p>
         * Default: - do not allow destruction of any resources on update
         * <p>
         * @return {@code this}
         * @param allowDestroy List of CloudFormation resource types in this stack that can be destroyed as part of an update without failing the test. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowDestroy(final java.util.List<java.lang.String> allowDestroy) {
            this.props().allowDestroy(allowDestroy);
            return this;
        }

        /**
         * (experimental) Additional options to use for each CDK command.
         * <p>
         * Default: - runner default options
         * <p>
         * @return {@code this}
         * @param cdkCommandOptions Additional options to use for each CDK command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cdkCommandOptions(final software.amazon.awscdk.cloudassembly.schema.CdkCommands cdkCommandOptions) {
            this.props().cdkCommandOptions(cdkCommandOptions);
            return this;
        }

        /**
         * (experimental) Whether or not to include asset hashes in the diff Asset hashes can introduces a lot of unneccessary noise into tests, but there are some cases where asset hashes _should_ be included.
         * <p>
         * For example
         * any tests involving custom resources or bundling
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param diffAssets Whether or not to include asset hashes in the diff Asset hashes can introduces a lot of unneccessary noise into tests, but there are some cases where asset hashes _should_ be included. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder diffAssets(final java.lang.Boolean diffAssets) {
            this.props().diffAssets(diffAssets);
            return this;
        }

        /**
         * (experimental) Additional commands to run at predefined points in the test workflow.
         * <p>
         * e.g. { postDeploy: ['yarn', 'test'] }
         * <p>
         * Default: - no hooks
         * <p>
         * @return {@code this}
         * @param hooks Additional commands to run at predefined points in the test workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hooks(final software.amazon.awscdk.cloudassembly.schema.Hooks hooks) {
            this.props().hooks(hooks);
            return this;
        }

        /**
         * (experimental) Limit deployment to these regions.
         * <p>
         * Default: - can run in any region
         * <p>
         * @return {@code this}
         * @param regions Limit deployment to these regions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder regions(final java.util.List<java.lang.String> regions) {
            this.props().regions(regions);
            return this;
        }

        /**
         * (experimental) Run update workflow on this test case This should only be set to false to test scenarios that are not possible to test as part of the update workflow.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param stackUpdateWorkflow Run update workflow on this test case This should only be set to false to test scenarios that are not possible to test as part of the update workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stackUpdateWorkflow(final java.lang.Boolean stackUpdateWorkflow) {
            this.props().stackUpdateWorkflow(stackUpdateWorkflow);
            return this;
        }

        /**
         * (experimental) Include runtime versioning information in this Stack.
         * <p>
         * Default: `analyticsReporting` setting of containing `App`, or value of
         * 'aws:cdk:version-reporting' context key
         * <p>
         * @return {@code this}
         * @param analyticsReporting Include runtime versioning information in this Stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder analyticsReporting(final java.lang.Boolean analyticsReporting) {
            this.props().analyticsReporting(analyticsReporting);
            return this;
        }

        /**
         * (experimental) A description of the stack.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * (experimental) The AWS environment (account/region) where this stack will be deployed.
         * <p>
         * Set the <code>region</code>/<code>account</code> fields of <code>env</code> to either a concrete value to
         * select the indicated environment (recommended for production stacks), or to
         * the values of environment variables
         * <code>CDK_DEFAULT_REGION</code>/<code>CDK_DEFAULT_ACCOUNT</code> to let the target environment
         * depend on the AWS credentials/configuration that the CDK CLI is executed
         * under (recommended for development stacks).
         * <p>
         * If the <code>Stack</code> is instantiated inside a <code>Stage</code>, any undefined
         * <code>region</code>/<code>account</code> fields from <code>env</code> will default to the same field on the
         * encompassing <code>Stage</code>, if configured there.
         * <p>
         * If either <code>region</code> or <code>account</code> are not set nor inherited from <code>Stage</code>, the
         * Stack will be considered "<em>environment-agnostic</em>"". Environment-agnostic
         * stacks can be deployed to any environment but may not be able to take
         * advantage of all features of the CDK. For example, they will not be able to
         * use environmental context lookups such as <code>ec2.Vpc.fromLookup</code> and will not
         * automatically translate Service Principals to the right format based on the
         * environment's AWS partition, and other such enhancements.
         * <p>
         * Default: - The environment of the containing `Stage` if available,
         * otherwise create the stack will be environment-agnostic.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * // Use a concrete account and region to deploy this stack to:
         * // `.account` and `.region` will simply return these values.
         * // Use a concrete account and region to deploy this stack to:
         * // `.account` and `.region` will simply return these values.
         * Stack.Builder.create(app, "Stack1")
         *         .env(Environment.builder()
         *                 .account("123456789012")
         *                 .region("us-east-1")
         *                 .build())
         *         .build();
         * // Use the CLI's current credentials to determine the target environment:
         * // `.account` and `.region` will reflect the account+region the CLI
         * // is configured to use (based on the user CLI credentials)
         * // Use the CLI's current credentials to determine the target environment:
         * // `.account` and `.region` will reflect the account+region the CLI
         * // is configured to use (based on the user CLI credentials)
         * Stack.Builder.create(app, "Stack2")
         *         .env(Environment.builder()
         *                 .account(process.getEnv().getCDK_DEFAULT_ACCOUNT())
         *                 .region(process.getEnv().getCDK_DEFAULT_REGION())
         *                 .build())
         *         .build();
         * // Define multiple stacks stage associated with an environment
         * Stage myStage = Stage.Builder.create(app, "MyStage")
         *         .env(Environment.builder()
         *                 .account("123456789012")
         *                 .region("us-east-1")
         *                 .build())
         *         .build();
         * // both of these stacks will use the stage's account/region:
         * // `.account` and `.region` will resolve to the concrete values as above
         * // both of these stacks will use the stage's account/region:
         * // `.account` and `.region` will resolve to the concrete values as above
         * new MyStack(myStage, "Stack1");
         * new YourStack(myStage, "Stack2");
         * // Define an environment-agnostic stack:
         * // `.account` and `.region` will resolve to `{ "Ref": "AWS::AccountId" }` and `{ "Ref": "AWS::Region" }` respectively.
         * // which will only resolve to actual values by CloudFormation during deployment.
         * // Define an environment-agnostic stack:
         * // `.account` and `.region` will resolve to `{ "Ref": "AWS::AccountId" }` and `{ "Ref": "AWS::Region" }` respectively.
         * // which will only resolve to actual values by CloudFormation during deployment.
         * new MyStack(app, "Stack1");
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param env The AWS environment (account/region) where this stack will be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder env(final software.amazon.awscdk.core.Environment env) {
            this.props().env(env);
            return this;
        }

        /**
         * (experimental) Name to deploy the stack with.
         * <p>
         * Default: - Derived from construct path.
         * <p>
         * @return {@code this}
         * @param stackName Name to deploy the stack with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stackName(final java.lang.String stackName) {
            this.props().stackName(stackName);
            return this;
        }

        /**
         * (experimental) Synthesis method to use while deploying this stack.
         * <p>
         * Default: - `DefaultStackSynthesizer` if the `@aws-cdk/core:newStyleStackSynthesis` feature flag
         * is set, `LegacyStackSynthesizer` otherwise.
         * <p>
         * @return {@code this}
         * @param synthesizer Synthesis method to use while deploying this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder synthesizer(final software.amazon.awscdk.core.IStackSynthesizer synthesizer) {
            this.props().synthesizer(synthesizer);
            return this;
        }

        /**
         * (experimental) Stack tags that will be applied to all the taggable resources and the stack itself.
         * <p>
         * Default: {}
         * <p>
         * @return {@code this}
         * @param tags Stack tags that will be applied to all the taggable resources and the stack itself. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * (experimental) Whether to enable termination protection for this stack.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param terminationProtection Whether to enable termination protection for this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder terminationProtection(final java.lang.Boolean terminationProtection) {
            this.props().terminationProtection(terminationProtection);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.integtests.IntegTestCaseStack}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.integtests.IntegTestCaseStack build() {
            return new software.amazon.awscdk.integtests.IntegTestCaseStack(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.integtests.IntegTestCaseStackProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.integtests.IntegTestCaseStackProps.Builder();
            }
            return this.props;
        }
    }
}
