package software.amazon.awscdk.integtests;

/**
 * (experimental) Interface that allows for registering a list of assertions that should be performed on a construct.
 * <p>
 * This is only necessary
 * when writing integration tests.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:12.928Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.integ_tests.IDeployAssert")
@software.amazon.jsii.Jsii.Proxy(IDeployAssert.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IDeployAssert extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Query AWS using JavaScript SDK V2 API calls.
     * <p>
     * This can be used to either
     * trigger an action or to return a result that can then be asserted against
     * an expected value
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * App app;
     * IntegTest integ;
     * integ.assertions.awsApiCall("SQS", "sendMessage", Map.of(
     *         "QueueUrl", "url",
     *         "MessageBody", "hello"));
     * IAwsApiCall message = integ.assertions.awsApiCall("SQS", "receiveMessage", Map.of(
     *         "QueueUrl", "url"));
     * message.expect(ExpectedResult.objectLike(Map.of(
     *         "Messages", List.of(Map.of("Body", "hello")))));
     * </pre></blockquote>
     * <p>
     * @param service This parameter is required.
     * @param api This parameter is required.
     * @param parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.IAwsApiCall awsApiCall(final @org.jetbrains.annotations.NotNull java.lang.String service, final @org.jetbrains.annotations.NotNull java.lang.String api, final @org.jetbrains.annotations.Nullable java.lang.Object parameters);

    /**
     * (experimental) Query AWS using JavaScript SDK V2 API calls.
     * <p>
     * This can be used to either
     * trigger an action or to return a result that can then be asserted against
     * an expected value
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * App app;
     * IntegTest integ;
     * integ.assertions.awsApiCall("SQS", "sendMessage", Map.of(
     *         "QueueUrl", "url",
     *         "MessageBody", "hello"));
     * IAwsApiCall message = integ.assertions.awsApiCall("SQS", "receiveMessage", Map.of(
     *         "QueueUrl", "url"));
     * message.expect(ExpectedResult.objectLike(Map.of(
     *         "Messages", List.of(Map.of("Body", "hello")))));
     * </pre></blockquote>
     * <p>
     * @param service This parameter is required.
     * @param api This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.IAwsApiCall awsApiCall(final @org.jetbrains.annotations.NotNull java.lang.String service, final @org.jetbrains.annotations.NotNull java.lang.String api);

    /**
     * (experimental) Assert that the ExpectedResult is equal to the ActualResult.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * IntegTest integ;
     * AwsApiCall apiCall;
     * integ.assertions.expect("invoke", ExpectedResult.objectLike(Map.of("Payload", "OK")), ActualResult.fromAwsApiCall(apiCall, "Body"));
     * </pre></blockquote>
     * <p>
     * @param id This parameter is required.
     * @param expected This parameter is required.
     * @param actual This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    void expect(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult expected, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ActualResult actual);

    /**
     * (experimental) Invoke a lambda function and return the response which can be asserted.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * App app;
     * IntegTest integ;
     * IAwsApiCall invoke = integ.assertions.invokeFunction(LambdaInvokeFunctionProps.builder()
     *         .functionName("my-function")
     *         .build());
     * invoke.expect(ExpectedResult.objectLike(Map.of(
     *         "Payload", "200")));
     * </pre></blockquote>
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.IAwsApiCall invokeFunction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.LambdaInvokeFunctionProps props);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.integtests.IDeployAssert.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Query AWS using JavaScript SDK V2 API calls.
         * <p>
         * This can be used to either
         * trigger an action or to return a result that can then be asserted against
         * an expected value
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * App app;
         * IntegTest integ;
         * integ.assertions.awsApiCall("SQS", "sendMessage", Map.of(
         *         "QueueUrl", "url",
         *         "MessageBody", "hello"));
         * IAwsApiCall message = integ.assertions.awsApiCall("SQS", "receiveMessage", Map.of(
         *         "QueueUrl", "url"));
         * message.expect(ExpectedResult.objectLike(Map.of(
         *         "Messages", List.of(Map.of("Body", "hello")))));
         * </pre></blockquote>
         * <p>
         * @param service This parameter is required.
         * @param api This parameter is required.
         * @param parameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.IAwsApiCall awsApiCall(final @org.jetbrains.annotations.NotNull java.lang.String service, final @org.jetbrains.annotations.NotNull java.lang.String api, final @org.jetbrains.annotations.Nullable java.lang.Object parameters) {
            return software.amazon.jsii.Kernel.call(this, "awsApiCall", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.IAwsApiCall.class), new Object[] { java.util.Objects.requireNonNull(service, "service is required"), java.util.Objects.requireNonNull(api, "api is required"), parameters });
        }

        /**
         * (experimental) Query AWS using JavaScript SDK V2 API calls.
         * <p>
         * This can be used to either
         * trigger an action or to return a result that can then be asserted against
         * an expected value
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * App app;
         * IntegTest integ;
         * integ.assertions.awsApiCall("SQS", "sendMessage", Map.of(
         *         "QueueUrl", "url",
         *         "MessageBody", "hello"));
         * IAwsApiCall message = integ.assertions.awsApiCall("SQS", "receiveMessage", Map.of(
         *         "QueueUrl", "url"));
         * message.expect(ExpectedResult.objectLike(Map.of(
         *         "Messages", List.of(Map.of("Body", "hello")))));
         * </pre></blockquote>
         * <p>
         * @param service This parameter is required.
         * @param api This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.IAwsApiCall awsApiCall(final @org.jetbrains.annotations.NotNull java.lang.String service, final @org.jetbrains.annotations.NotNull java.lang.String api) {
            return software.amazon.jsii.Kernel.call(this, "awsApiCall", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.IAwsApiCall.class), new Object[] { java.util.Objects.requireNonNull(service, "service is required"), java.util.Objects.requireNonNull(api, "api is required") });
        }

        /**
         * (experimental) Assert that the ExpectedResult is equal to the ActualResult.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * IntegTest integ;
         * AwsApiCall apiCall;
         * integ.assertions.expect("invoke", ExpectedResult.objectLike(Map.of("Payload", "OK")), ActualResult.fromAwsApiCall(apiCall, "Body"));
         * </pre></blockquote>
         * <p>
         * @param id This parameter is required.
         * @param expected This parameter is required.
         * @param actual This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final void expect(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult expected, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ActualResult actual) {
            software.amazon.jsii.Kernel.call(this, "expect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(expected, "expected is required"), java.util.Objects.requireNonNull(actual, "actual is required") });
        }

        /**
         * (experimental) Invoke a lambda function and return the response which can be asserted.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * App app;
         * IntegTest integ;
         * IAwsApiCall invoke = integ.assertions.invokeFunction(LambdaInvokeFunctionProps.builder()
         *         .functionName("my-function")
         *         .build());
         * invoke.expect(ExpectedResult.objectLike(Map.of(
         *         "Payload", "200")));
         * </pre></blockquote>
         * <p>
         * @param props This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.IAwsApiCall invokeFunction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.LambdaInvokeFunctionProps props) {
            return software.amazon.jsii.Kernel.call(this, "invokeFunction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.IAwsApiCall.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
        }
    }

    /**
     * Internal default implementation for {@link IDeployAssert}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IDeployAssert {

        /**
         * (experimental) Query AWS using JavaScript SDK V2 API calls.
         * <p>
         * This can be used to either
         * trigger an action or to return a result that can then be asserted against
         * an expected value
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * App app;
         * IntegTest integ;
         * integ.assertions.awsApiCall("SQS", "sendMessage", Map.of(
         *         "QueueUrl", "url",
         *         "MessageBody", "hello"));
         * IAwsApiCall message = integ.assertions.awsApiCall("SQS", "receiveMessage", Map.of(
         *         "QueueUrl", "url"));
         * message.expect(ExpectedResult.objectLike(Map.of(
         *         "Messages", List.of(Map.of("Body", "hello")))));
         * </pre></blockquote>
         * <p>
         * @param service This parameter is required.
         * @param api This parameter is required.
         * @param parameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.IAwsApiCall awsApiCall(final @org.jetbrains.annotations.NotNull java.lang.String service, final @org.jetbrains.annotations.NotNull java.lang.String api, final @org.jetbrains.annotations.Nullable java.lang.Object parameters) {
            return software.amazon.jsii.Kernel.call(this, "awsApiCall", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.IAwsApiCall.class), new Object[] { java.util.Objects.requireNonNull(service, "service is required"), java.util.Objects.requireNonNull(api, "api is required"), parameters });
        }

        /**
         * (experimental) Assert that the ExpectedResult is equal to the ActualResult.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * IntegTest integ;
         * AwsApiCall apiCall;
         * integ.assertions.expect("invoke", ExpectedResult.objectLike(Map.of("Payload", "OK")), ActualResult.fromAwsApiCall(apiCall, "Body"));
         * </pre></blockquote>
         * <p>
         * @param id This parameter is required.
         * @param expected This parameter is required.
         * @param actual This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default void expect(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult expected, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ActualResult actual) {
            software.amazon.jsii.Kernel.call(this, "expect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(expected, "expected is required"), java.util.Objects.requireNonNull(actual, "actual is required") });
        }

        /**
         * (experimental) Invoke a lambda function and return the response which can be asserted.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * App app;
         * IntegTest integ;
         * IAwsApiCall invoke = integ.assertions.invokeFunction(LambdaInvokeFunctionProps.builder()
         *         .functionName("my-function")
         *         .build());
         * invoke.expect(ExpectedResult.objectLike(Map.of(
         *         "Payload", "200")));
         * </pre></blockquote>
         * <p>
         * @param props This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.IAwsApiCall invokeFunction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.LambdaInvokeFunctionProps props) {
            return software.amazon.jsii.Kernel.call(this, "invokeFunction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.IAwsApiCall.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
        }
    }
}
