package software.amazon.awscdk.integtests;

/**
 * (experimental) Interface for creating a custom resource that will perform an API call using the AWS SDK.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:12.921Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.integ_tests.IAwsApiCall")
@software.amazon.jsii.Jsii.Proxy(IAwsApiCall.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IAwsApiCall extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IConstruct {

    /**
     * (experimental) Assert that the ExpectedResult is equal to the result of the AwsApiCall at the given path.
     * <p>
     * For example the SQS.receiveMessage api response would look
     * like:
     * <p>
     * If you wanted to assert the value of <code>Body</code> you could do
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * IntegTest integ;
     * Map&lt;String, Map&lt;String, Object&gt;[]&gt; actual = Map.of(
     *         "Messages", List.of(Map.of(
     *                 "MessageId", "",
     *                 "ReceiptHandle", "",
     *                 "MD5OfBody", "",
     *                 "Body", "hello",
     *                 "Attributes", Map.of(),
     *                 "MD5OfMessageAttributes", Map.of(),
     *                 "MessageAttributes", Map.of())));
     * IAwsApiCall message = integ.assertions.awsApiCall("SQS", "receiveMessage");
     * message.assertAtPath("Messages.0.Body", ExpectedResult.stringLikeRegexp("hello"));
     * </pre></blockquote>
     * <p>
     * @param path This parameter is required.
     * @param expected This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    void assertAtPath(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult expected);

    /**
     * (experimental) Assert that the ExpectedResult is equal to the result of the AwsApiCall.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * IntegTest integ;
     * IAwsApiCall invoke = integ.assertions.invokeFunction(LambdaInvokeFunctionProps.builder()
     *         .functionName("my-func")
     *         .build());
     * invoke.expect(ExpectedResult.objectLike(Map.of("Payload", "OK")));
     * </pre></blockquote>
     * <p>
     * @param expected This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    void expect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult expected);

    /**
     * (experimental) Returns the value of an attribute of the custom resource of an arbitrary type.
     * <p>
     * Attributes are returned from the custom resource provider through the
     * <code>Data</code> map where the key is the attribute name.
     * <p>
     * @return a token for `Fn::GetAtt`. Use `Token.asXxx` to encode the returned `Reference` as a specific type or
     * use the convenience `getAttString` for string attributes.
     * @param attributeName the name of the attribute. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Reference getAtt(final @org.jetbrains.annotations.NotNull java.lang.String attributeName);

    /**
     * (experimental) Returns the value of an attribute of the custom resource of type string.
     * <p>
     * Attributes are returned from the custom resource provider through the
     * <code>Data</code> map where the key is the attribute name.
     * <p>
     * @return a token for `Fn::GetAtt` encoded as a string.
     * @param attributeName the name of the attribute. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getAttString(final @org.jetbrains.annotations.NotNull java.lang.String attributeName);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.integtests.IAwsApiCall.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * (experimental) Assert that the ExpectedResult is equal to the result of the AwsApiCall at the given path.
         * <p>
         * For example the SQS.receiveMessage api response would look
         * like:
         * <p>
         * If you wanted to assert the value of <code>Body</code> you could do
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * IntegTest integ;
         * Map&lt;String, Map&lt;String, Object&gt;[]&gt; actual = Map.of(
         *         "Messages", List.of(Map.of(
         *                 "MessageId", "",
         *                 "ReceiptHandle", "",
         *                 "MD5OfBody", "",
         *                 "Body", "hello",
         *                 "Attributes", Map.of(),
         *                 "MD5OfMessageAttributes", Map.of(),
         *                 "MessageAttributes", Map.of())));
         * IAwsApiCall message = integ.assertions.awsApiCall("SQS", "receiveMessage");
         * message.assertAtPath("Messages.0.Body", ExpectedResult.stringLikeRegexp("hello"));
         * </pre></blockquote>
         * <p>
         * @param path This parameter is required.
         * @param expected This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final void assertAtPath(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult expected) {
            software.amazon.jsii.Kernel.call(this, "assertAtPath", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(expected, "expected is required") });
        }

        /**
         * (experimental) Assert that the ExpectedResult is equal to the result of the AwsApiCall.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * IntegTest integ;
         * IAwsApiCall invoke = integ.assertions.invokeFunction(LambdaInvokeFunctionProps.builder()
         *         .functionName("my-func")
         *         .build());
         * invoke.expect(ExpectedResult.objectLike(Map.of("Payload", "OK")));
         * </pre></blockquote>
         * <p>
         * @param expected This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final void expect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult expected) {
            software.amazon.jsii.Kernel.call(this, "expect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(expected, "expected is required") });
        }

        /**
         * (experimental) Returns the value of an attribute of the custom resource of an arbitrary type.
         * <p>
         * Attributes are returned from the custom resource provider through the
         * <code>Data</code> map where the key is the attribute name.
         * <p>
         * @return a token for `Fn::GetAtt`. Use `Token.asXxx` to encode the returned `Reference` as a specific type or
         * use the convenience `getAttString` for string attributes.
         * @param attributeName the name of the attribute. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Reference getAtt(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
            return software.amazon.jsii.Kernel.call(this, "getAtt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Reference.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
        }

        /**
         * (experimental) Returns the value of an attribute of the custom resource of type string.
         * <p>
         * Attributes are returned from the custom resource provider through the
         * <code>Data</code> map where the key is the attribute name.
         * <p>
         * @return a token for `Fn::GetAtt` encoded as a string.
         * @param attributeName the name of the attribute. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String getAttString(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
            return software.amazon.jsii.Kernel.call(this, "getAttString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
        }
    }

    /**
     * Internal default implementation for {@link IAwsApiCall}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IAwsApiCall, software.amazon.awscdk.core.IConstruct.Jsii$Default {

        /**
         * (experimental) The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * (experimental) Assert that the ExpectedResult is equal to the result of the AwsApiCall at the given path.
         * <p>
         * For example the SQS.receiveMessage api response would look
         * like:
         * <p>
         * If you wanted to assert the value of <code>Body</code> you could do
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * IntegTest integ;
         * Map&lt;String, Map&lt;String, Object&gt;[]&gt; actual = Map.of(
         *         "Messages", List.of(Map.of(
         *                 "MessageId", "",
         *                 "ReceiptHandle", "",
         *                 "MD5OfBody", "",
         *                 "Body", "hello",
         *                 "Attributes", Map.of(),
         *                 "MD5OfMessageAttributes", Map.of(),
         *                 "MessageAttributes", Map.of())));
         * IAwsApiCall message = integ.assertions.awsApiCall("SQS", "receiveMessage");
         * message.assertAtPath("Messages.0.Body", ExpectedResult.stringLikeRegexp("hello"));
         * </pre></blockquote>
         * <p>
         * @param path This parameter is required.
         * @param expected This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default void assertAtPath(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult expected) {
            software.amazon.jsii.Kernel.call(this, "assertAtPath", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), java.util.Objects.requireNonNull(expected, "expected is required") });
        }

        /**
         * (experimental) Assert that the ExpectedResult is equal to the result of the AwsApiCall.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * IntegTest integ;
         * IAwsApiCall invoke = integ.assertions.invokeFunction(LambdaInvokeFunctionProps.builder()
         *         .functionName("my-func")
         *         .build());
         * invoke.expect(ExpectedResult.objectLike(Map.of("Payload", "OK")));
         * </pre></blockquote>
         * <p>
         * @param expected This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default void expect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult expected) {
            software.amazon.jsii.Kernel.call(this, "expect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(expected, "expected is required") });
        }

        /**
         * (experimental) Returns the value of an attribute of the custom resource of an arbitrary type.
         * <p>
         * Attributes are returned from the custom resource provider through the
         * <code>Data</code> map where the key is the attribute name.
         * <p>
         * @return a token for `Fn::GetAtt`. Use `Token.asXxx` to encode the returned `Reference` as a specific type or
         * use the convenience `getAttString` for string attributes.
         * @param attributeName the name of the attribute. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Reference getAtt(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
            return software.amazon.jsii.Kernel.call(this, "getAtt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Reference.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
        }

        /**
         * (experimental) Returns the value of an attribute of the custom resource of type string.
         * <p>
         * Attributes are returned from the custom resource provider through the
         * <code>Data</code> map where the key is the attribute name.
         * <p>
         * @return a token for `Fn::GetAtt` encoded as a string.
         * @param attributeName the name of the attribute. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.String getAttString(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
            return software.amazon.jsii.Kernel.call(this, "getAttString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
        }
    }
}
